/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeNameMatchRequestorWrapper
implements IRestrictedAccessTypeRequestor {
    TypeNameMatchRequestor requestor;
    private IJavaScriptSearchScope scope;
    private HandleFactory handleFactory;
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;

    public TypeNameMatchRequestorWrapper(TypeNameMatchRequestor requestor, IJavaScriptSearchScope scope) {
        this.requestor = requestor;
        this.scope = scope;
        if (!(scope instanceof JavaSearchScope)) {
            this.handleFactory = new HandleFactory();
        }
    }

    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
        try {
            IType type = null;
            if (this.handleFactory != null) {
                Openable openable = this.handleFactory.createOpenable(path, this.scope);
                if (openable == null) {
                    return;
                }
                switch (openable.getElementType()) {
                    case 5: {
                        IJavaScriptUnit cu = (IJavaScriptUnit)((Object)openable);
                        if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                            type = cu.getType(new String(enclosingTypeNames[0]));
                            int j = 1;
                            int l = enclosingTypeNames.length;
                            while (j < l) {
                                type = type.getType(new String(enclosingTypeNames[j]));
                                ++j;
                            }
                            type = type.getType(new String(simpleTypeName));
                            break;
                        }
                        type = cu.getType(new String(simpleTypeName));
                        break;
                    }
                    case 6: {
                        type = ((IClassFile)((Object)openable)).getType();
                    }
                }
            } else {
                int separatorIndex = path.indexOf("|");
                IType iType = type = separatorIndex == -1 ? this.createTypeFromPath(path, new String(simpleTypeName), enclosingTypeNames) : this.createTypeFromJar(path, separatorIndex);
            }
            if (type != null) {
                this.requestor.acceptTypeNameMatch(new JavaSearchTypeNameMatch(type, modifiers));
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    private IType createTypeFromJar(String resourcePath, int separatorIndex) throws JavaScriptModelException {
        Object[] pkgName;
        String classFilePath;
        String[] simpleNames;
        int length;
        if (this.lastPkgFragmentRootPath == null || this.lastPkgFragmentRootPath.length() > resourcePath.length() || !resourcePath.startsWith(this.lastPkgFragmentRootPath)) {
            String jarPath = resourcePath.substring(0, separatorIndex);
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRootPath = jarPath;
            this.lastPkgFragmentRoot = root;
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        return pkgFragment.getClassFile(simpleNames[length]).getType();
    }

    private IType createTypeFromPath(String resourcePath, String simpleTypeName, char[][] enclosingTypeNames) throws JavaScriptModelException {
        String simpleName;
        Object[] pkgName;
        boolean isLibrary;
        int rootPathLength = -1;
        boolean samePath = false;
        if (resourcePath != null && this.lastPkgFragmentRoot != null) {
            Path path1 = new Path(resourcePath);
            Path path2 = new Path(this.lastPkgFragmentRootPath);
            samePath = path1.equals((Object)path2);
        }
        if (!(samePath || this.lastPkgFragmentRootPath != null && resourcePath.startsWith(this.lastPkgFragmentRootPath) && (rootPathLength = this.lastPkgFragmentRootPath.length()) > 0 && rootPathLength < resourcePath.length() && resourcePath.charAt(rootPathLength) == '/')) {
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if (isLibrary = this.lastPkgFragmentRoot instanceof LibraryFragmentRoot) {
            Object[] pkgName2 = new String[]{this.lastPkgFragmentRootPath};
            IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName2);
            if (pkgFragment == null) {
                pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String)pkgName2[0]);
                this.packageHandles.put(pkgName2, pkgFragment);
            }
            IClassFile classFile = pkgFragment.getClassFile((String)pkgName2[0]);
            return classFile.getType(simpleTypeName);
        }
        String[] simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments();
        int length = simpleNames.length - 1;
        if (length > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if (Util.isJavaLikeFileName(simpleName = simpleNames[length]) && !(pkgFragment instanceof LibraryPackageFragment)) {
            IType type;
            IJavaScriptUnit unit = pkgFragment.getJavaScriptUnit(simpleName);
            int etnLength = enclosingTypeNames == null ? 0 : enclosingTypeNames.length;
            IType iType = type = etnLength == 0 ? unit.getType(simpleTypeName) : unit.getType(new String(enclosingTypeNames[0]));
            if (etnLength > 0) {
                int i = 1;
                while (i < etnLength) {
                    type = type.getType(new String(enclosingTypeNames[i]));
                    ++i;
                }
                type = type.getType(simpleTypeName);
            }
            return type;
        }
        IClassFile classFile = pkgFragment.getClassFile(simpleName);
        return classFile.getType(simpleTypeName);
    }
}

