/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.fwk;

import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.fwk.TestOpConstrBuilder;
import org.eclipse.jst.validation.test.fwk.validator.JDTUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.setup.IBuffer;

public class TestOpConstrInputOperation
implements IWorkspaceRunnable {
    public static final String FWK_NOBUILD_TEST_VALIDATOR_CLASS = "org.eclipse.jst.validation.test.fwk.validator.FwkNoBuildTestValidator";
    public static final String FWK_TEST_VALIDATOR_CLASS = "org.eclipse.jst.validation.test.fwk.validator.FwkTestValidator";
    public static final String PROPERTIES_VALIDATOR_CLASS = "org.eclipse.wst.validation.sample.PropertiesValidator";
    private IProject _project = null;
    private IBuffer _buffer = null;
    private static ICommand _builderCommand = null;
    private IResourceDelta _changedDelta = null;
    private IResourceDelta _emptyDelta = null;
    private JavaHelpers[] _changedClasses = null;

    public TestOpConstrInputOperation(IBuffer buffer, IProject project) {
        this.setProject(project);
        this.setBuffer(buffer);
    }

    public IBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(IBuffer b) {
        this._buffer = b;
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject p) {
        this._project = p;
    }

    static void debug(final IBuffer buffer, String title, IResourceDelta delta) {
        block2: {
            try {
                buffer.write(title);
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta subdelta) throws CoreException {
                        if (subdelta == null) {
                            return true;
                        }
                        IResource resource = subdelta.getResource();
                        buffer.write("resource is: " + resource.getFullPath());
                        return true;
                    }
                });
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
        }
    }

    public static IResource[] getEmptyResources(IProject project) {
        IResource[] changedResources = new IResource[]{project.getFile(".classpath")};
        return changedResources;
    }

    public static void touch(IProject project, IResource[] changedResources) {
        int i = 0;
        while (i < changedResources.length) {
            block3: {
                IResource res = changedResources[i];
                try {
                    res.touch(null);
                }
                catch (CoreException exc) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                    logger.write(Level.SEVERE, (Exception)((Object)exc));
                }
            }
            ++i;
        }
    }

    private static IResourceDelta getDelta(IProject project, IResource[] changedResources) {
        try {
            TestOpConstrInputOperation.touch(project, changedResources);
            project.build(10, "org.eclipse.jst.validation.test.fwk.bvtbuilder", _builderCommand.getArguments(), null);
            return TestOpConstrBuilder.singleton().getDelta();
        }
        catch (CoreException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
            return null;
        }
    }

    private static void addBuilder(IProject project, boolean doAdd) {
        block6: {
            if (doAdd) {
                try {
                    IProjectDescription description = project.getDescription();
                    ICommand[] oldCommands = description.getBuildSpec();
                    ICommand[] newCommands = new ICommand[oldCommands.length + 1];
                    System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
                    _builderCommand = description.newCommand();
                    _builderCommand.setBuilderName("org.eclipse.jst.validation.test.fwk.bvtbuilder");
                    newCommands[oldCommands.length] = _builderCommand;
                    description.setBuildSpec(newCommands);
                    project.setDescription(description, null);
                }
                catch (CoreException exc) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, (Exception)((Object)exc));
                    }
                    break block6;
                }
            }
            try {
                IProjectDescription description = project.getDescription();
                ICommand[] oldCommands = description.getBuildSpec();
                ICommand[] newCommands = new ICommand[oldCommands.length - 1];
                System.arraycopy(oldCommands, 0, newCommands, 0, newCommands.length);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
        }
    }

    public void run(IProgressMonitor monitor) {
        block3: {
            try {
                TestOpConstrInputOperation.addBuilder(this.getProject(), true);
                this.getProject().build(10, "org.eclipse.jst.validation.test.fwk.bvtbuilder", _builderCommand.getArguments(), null);
                ValidatorTestcase[] tmds = JDTUtility.getVFTests(monitor, this.getProject());
                if (tmds == null || tmds.length == 0) {
                    return;
                }
                IResource[] changedResources = TestOpConstrInputOperation.getChangedResources(this.getProject(), tmds);
                this._emptyDelta = TestOpConstrInputOperation.getDelta(this.getProject(), TestOpConstrInputOperation.getEmptyResources(this.getProject()));
                this._changedDelta = TestOpConstrInputOperation.getDelta(this.getProject(), changedResources);
                TestOpConstrInputOperation.addBuilder(this.getProject(), false);
                this._changedClasses = this.getChangedClasses(changedResources);
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                logger.write(Level.SEVERE, exc);
            }
        }
    }

    public IResourceDelta getChangedDelta() {
        return this._changedDelta;
    }

    public IResourceDelta getEmptyDelta() {
        return this._emptyDelta;
    }

    public static IResource[] getChangedResources(IProject project, ValidatorTestcase[] tmds) {
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < tmds.length) {
            ValidatorTestcase tmd = tmds[i];
            IResource[] res = tmd.getResources(project);
            int j = 0;
            while (j < res.length) {
                temp.add(res[j]);
                ++j;
            }
            ++i;
        }
        IResource[] result = new IResource[temp.size()];
        temp.toArray(result);
        return result;
    }

    public JavaHelpers[] getChangedClasses(IResource[] resources) {
        if (this._changedClasses == null) {
            if (resources == null) {
                return new JavaHelpers[0];
            }
            JavaHelpers[] result = new JavaHelpers[resources.length];
            int count = 0;
            int i = 0;
            while (i < resources.length) {
                JavaHelpers h;
                IResource resource = resources[i];
                if (resource instanceof IFile && (resource.getFileExtension().equals("java") || resource.getFileExtension().equals("class")) && (h = JDTUtility.getJavaHelpers((IFile)resource)) != null) {
                    result[count++] = h;
                }
                ++i;
            }
            if (count != resources.length) {
                JavaHelpers[] temp = new JavaHelpers[count];
                System.arraycopy(result, 0, temp, 0, count);
                return temp;
            }
            return result;
        }
        return this._changedClasses;
    }
}

