/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.io.PrintStream;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DebugDocument {
    public static void dump(Document document) {
        if (document == null) {
            return;
        }
        System.out.println("Dump of DOM");
        DebugDocument.dump(document, System.out);
        System.out.println();
        System.out.println("= = = = = =");
        System.out.println();
    }

    public static void dump(Document document, PrintStream out) {
        Node node = document.getFirstChild();
        while (node != null) {
            DebugDocument.dump(node, out);
            node = node.getNextSibling();
        }
    }

    public static void dump(Node topNode) {
        DebugDocument.dump(topNode, System.out);
    }

    public static void dump(Node topNode, PrintStream out) {
        if (topNode == null) {
            return;
        }
        DebugDocument.printNode(topNode, out);
    }

    public static void printNode(Node topNode) {
        DebugDocument.printNode(topNode, System.out);
    }

    public static void printNode(Node topNode, PrintStream out) {
        IStructuredDocumentRegion firstStructuredDocumentRegion = ((IDOMNode)topNode).getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion lastStructuredDocumentRegion = ((IDOMNode)topNode).getLastStructuredDocumentRegion();
        if (firstStructuredDocumentRegion != null && lastStructuredDocumentRegion != null) {
            int start = firstStructuredDocumentRegion.getStart();
            int end = lastStructuredDocumentRegion.getEnd();
            String outString = topNode.toString();
            outString = StringUtils.escape((String)outString);
            out.println("[" + start + ", " + end + "]" + outString);
        }
        NodeList nodes = topNode.getChildNodes();
        int len = nodes.getLength();
        int i = 0;
        while (i < len) {
            Node childNode = nodes.item(i);
            DebugDocument.printNode(childNode, out);
            ++i;
        }
    }
}

