/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;

public class ProjectModuleRefactoringTests
extends AbstractTests {
    public ProjectModuleRefactoringTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Module Dependency Refactoring Tests");
        suite.addTest((Test)new ProjectModuleRefactoringTests("testDeleteModuleDependency"));
        suite.addTest((Test)new ProjectModuleRefactoringTests("testRenameModuleDependency"));
        suite.addTest((Test)new ProjectModuleRefactoringTests("testDeleteModuleDependencyWithMarker"));
        suite.addTest((Test)new ProjectModuleRefactoringTests("testRenameModuleDependencyWithMarker"));
        suite.addTest((Test)new ProjectModuleRefactoringTests("testDeleteMultipleDependency"));
        suite.addTest((Test)new ProjectModuleRefactoringTests("testRenameMultipleModuleDependency"));
        return suite;
    }

    public void testDeleteModuleDependency() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupModuleDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, utilProject);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(webProject, utilProject);
    }

    public void testDeleteModuleDependencyWithMarker() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupModuleDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        utilProject.createMarker("TEST_MARKER");
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, utilProject);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(webProject, utilProject);
    }

    public void testRenameModuleDependency() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupModuleDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, utilProject, newUtil);
        DependencyVerificationUtil.verifyModuleDependencyChanged(webProject, utilProject, newUtil);
    }

    public void testRenameModuleDependencyWithMarker() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupModuleDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        utilProject.createMarker("TEST_MARKER");
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, utilProject, newUtil);
        DependencyVerificationUtil.verifyModuleDependencyChanged(webProject, utilProject, newUtil);
    }

    public void testDeleteMultipleDependency() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupMultipleDependency();
        IProject earProject1 = projects[0];
        IProject earProject2 = projects[1];
        IProject webProject = projects[2];
        IProject ejbProject = projects[3];
        IProject utilProject = projects[4];
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject1, utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject2, utilProject);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(webProject, utilProject);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(ejbProject, utilProject);
    }

    public void testRenameMultipleModuleDependency() throws Exception {
        IProject[] projects = ProjectModuleRefactoringTests.setupMultipleDependency();
        IProject earProject1 = projects[0];
        IProject earProject2 = projects[1];
        IProject webProject = projects[2];
        IProject ejbProject = projects[3];
        IProject utilProject = projects[4];
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject1, utilProject, newUtil);
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject2, utilProject, newUtil);
        DependencyVerificationUtil.verifyModuleDependencyChanged(webProject, utilProject, newUtil);
        DependencyVerificationUtil.verifyModuleDependencyChanged(ejbProject, utilProject, newUtil);
    }

    private static IProject[] setupModuleDependency() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject.getName());
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        DependencyCreationUtil.createModuleDependency(webProject, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        DependencyVerificationUtil.verifyModuleDependency(webProject, utilProject);
        return new IProject[]{earProject, webProject, utilProject};
    }

    private static IProject[] setupMultipleDependency() throws Exception {
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, utilProject);
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject1.getName());
        IProject ejbProject = ProjectUtil.createEJBProject("TestEJB", earProject2.getName());
        IProject ejbClientProject = ProjectUtil.getProject("TestEJBClient");
        DependencyCreationUtil.createModuleDependency(webProject, utilProject);
        DependencyCreationUtil.createModuleDependency(ejbProject, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject1, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject1, webProject, true);
        DependencyVerificationUtil.verifyEARDependency(earProject2, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject2, ejbProject, true);
        DependencyVerificationUtil.verifyEARDependency(earProject2, ejbClientProject, false);
        DependencyVerificationUtil.verifyModuleDependency(webProject, utilProject);
        DependencyVerificationUtil.verifyModuleDependency(ejbProject, utilProject);
        return new IProject[]{earProject1, earProject2, webProject, ejbProject, utilProject};
    }
}

