/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ArchiveComponentCreationTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ArchiveComponentCreationTest.class);
    }

    public ArchiveComponentCreationTest() {
    }

    public ArchiveComponentCreationTest(String name) {
        super(name);
    }

    public void testCreateWebComponent() throws Exception {
        this.createWebComponent(24, "TestWeb");
    }

    private void createWebComponent(int j2eeVersion, String aModuleName) throws Exception {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aModuleName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webModel = map.getFacetDataModel("jst.web");
        webModel.setIntProperty("IFacetDataModelPropeties.FACET_VERSION", j2eeVersion);
        model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject project = ProjectUtilities.getProject((String)aModuleName);
        if (project.exists()) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            this.createArchiveComponent(component);
        }
    }

    public void createArchiveComponent(IVirtualComponent component) {
        Path path = new Path("JUNIT_HOME/junit.jar");
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        File file = new File(resolvedPath.toOSString());
        if (file.isFile() && file.exists()) {
            String type = "var/";
            IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)component.getProject(), (String)(String.valueOf(type) + path.toString()));
            ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
            IVirtualReference[] oldrefs = component.getReferences();
            int j = 0;
            while (j < oldrefs.length) {
                IVirtualReference ref = oldrefs[j];
                vlist.add(ref);
                ++j;
            }
            IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)component, (IVirtualComponent)archive, (IPath)new Path("/WEB-INF/lib"));
            vlist.add(ref);
            IVirtualReference[] refs = new IVirtualReference[vlist.size()];
            int j2 = 0;
            while (j2 < vlist.size()) {
                IVirtualReference tmpref;
                refs[j2] = tmpref = (IVirtualReference)vlist.get(j2);
                ++j2;
            }
            component.setReferences(refs);
        }
    }
}

