/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.operations;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.internal.common.operations.INewJavaClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.web.operations.NewFilterClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.NewListenerClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebProjectCreationOperationTest;

public class AddWebArtifactOperationTest
extends OperationTestCase
implements INewJavaClassDataModelProperties {
    public static final String WEB_PROJECT_NAME = "WebProject";
    public static final String PACKAGE = "test";
    public static final String SERVLET_NAME = "TestServlet";
    public static final String SERVLET_CLASS_NAME = "test.TestServlet";
    public static final String SERVLET_DEFAULT_MAPPING = "/TestServlet";
    public static final String FILTER_NAME = "TestFilter";
    public static final String FILTER_CLASS_NAME = "test.TestFilter";
    public static final String FILTER_DEFAULT_MAPPING = "/TestFilter";
    public static final String LISTENER_NAME = "TestListener";
    public static final String LISTENER_CLASS_NAME = "test.TestListener";

    public AddWebArtifactOperationTest(String name) {
        super(name);
    }

    public AddWebArtifactOperationTest() {
    }

    public static Test suite() {
        return new TestSuite(AddWebArtifactOperationTest.class);
    }

    public void testAddServlet_Web24_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_24);
        WebArtifactEdit webEdit = null;
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        try {
            webEdit = new WebArtifactEdit(proj, false, true);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = webEdit.getWebApp();
            this.addServlet_Defaults();
            if (webApp != null) {
                this.assertJavaFileExists(SERVLET_CLASS_NAME);
                Servlet servlet = webApp.getServletNamed(SERVLET_NAME);
                AddWebArtifactOperationTest.assertNotNull((String)"Servlet TestServlet not found in the model", (Object)servlet);
                AddWebArtifactOperationTest.assertEquals((String)"Servlet points to an unexpected deployment descriptor object", (Object)webApp, (Object)servlet.getWebApp());
                AddWebArtifactOperationTest.assertEquals((String)("Servlet name is expected to be TestServlet, but it is " + servlet.getServletName()), (String)SERVLET_NAME, (String)servlet.getServletName());
                AddWebArtifactOperationTest.assertEquals((String)("Display name is expected to be TestServlet, but it is " + servlet.getDisplayName()), (String)SERVLET_NAME, (String)servlet.getDisplayName());
                EList params = servlet.getInitParams();
                AddWebArtifactOperationTest.assertNotNull((String)"List of initialization parameters cannot be retrieved", (Object)params);
                AddWebArtifactOperationTest.assertEquals((String)("None initialization parameter is expected, but " + params.size() + " are found"), (int)0, (int)params.size());
                List mappings = servlet.getMappings();
                AddWebArtifactOperationTest.assertEquals((int)1, (int)mappings.size());
                org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)mappings.get(0);
                AddWebArtifactOperationTest.assertEquals((String)("Servlet name of the mapping is expected to be TestServlet, but it is " + mapping.getName()), (String)SERVLET_NAME, (String)mapping.getName());
                AddWebArtifactOperationTest.assertEquals((String)("Servlet mapping URL pattern value is expected to be /TestServlet, but it is " + mapping.getUrlPattern()), (String)SERVLET_DEFAULT_MAPPING, (String)mapping.getUrlPattern());
                AddWebArtifactOperationTest.assertEquals((String)("Servlet mapping is expected to point to servlet " + servlet.getServletName() + ", but it points to servlet " + mapping.getServlet().getServletName()), (Object)servlet, (Object)mapping.getServlet());
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    public void testAddServlet_Web25_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_25);
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj);
        WebApp webApp = (WebApp)provider.getModelObject();
        this.addServlet_Defaults();
        this.assertJavaFileExists(SERVLET_CLASS_NAME);
        List servlets = webApp.getServlets();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one filter is expected in the model, but " + servlets.size() + " are found"), (int)1, (int)servlets.size());
        org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)servlets.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Servlet name is expected to be TestServlet, but it is " + servlet.getServletName()), (String)SERVLET_NAME, (String)servlet.getServletName());
        AddWebArtifactOperationTest.assertEquals((String)("Servlet class name is expected to be test.TestServlet, but it is " + servlet.getServletClass()), (String)SERVLET_CLASS_NAME, (String)servlet.getServletClass());
        List displayNames = servlet.getDisplayNames();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one display name is expected, but " + displayNames.size() + " are found"), (int)1, (int)displayNames.size());
        DisplayName displayName = (DisplayName)displayNames.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Display name is expected to be TestServlet, but it is " + displayName.getValue()), (String)SERVLET_NAME, (String)displayName.getValue());
        List params = servlet.getInitParams();
        AddWebArtifactOperationTest.assertNotNull((String)"List of initialization parameters cannot be retrieved", (Object)params);
        AddWebArtifactOperationTest.assertEquals((String)("None initialization parameter is expected, but " + params.size() + " are found"), (int)0, (int)params.size());
        List mappings = webApp.getServletMappings();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one servlet mapping is expected, but " + mappings.size() + " are found"), (int)1, (int)mappings.size());
        ServletMapping mapping = (ServletMapping)mappings.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Servlet name of the mapping is expected to be TestServlet, but it is " + mapping.getServletName()), (String)SERVLET_NAME, (String)mapping.getServletName());
        List urlPatterns = mapping.getUrlPatterns();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one URL pattern is expected in the mapping, but " + urlPatterns.size() + " are found"), (int)1, (int)urlPatterns.size());
        UrlPatternType urlPattern = (UrlPatternType)urlPatterns.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Servlet mapping URL pattern value is expected to be /TestServlet, but it is " + urlPattern.getValue()), (String)SERVLET_DEFAULT_MAPPING, (String)urlPattern.getValue());
    }

    public void testAddFilter_Web24_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_24);
        WebArtifactEdit webEdit = null;
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        try {
            webEdit = new WebArtifactEdit(proj, false, true);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = webEdit.getWebApp();
            this.addFilter_Defaults();
            if (webApp != null) {
                this.assertJavaFileExists(FILTER_CLASS_NAME);
                org.eclipse.jst.j2ee.webapplication.Filter filter = webApp.getFilterNamed(FILTER_NAME);
                AddWebArtifactOperationTest.assertNotNull((String)"Filter TestFilter not found in the model", (Object)filter);
                AddWebArtifactOperationTest.assertEquals((String)("Filter name is expected to be TestFilter, but it is " + filter.getName()), (String)FILTER_NAME, (String)filter.getName());
                AddWebArtifactOperationTest.assertEquals((String)("Display name is expected to be TestFilter, but it is " + filter.getDisplayName()), (String)FILTER_NAME, (String)filter.getDisplayName());
                AddWebArtifactOperationTest.assertEquals((String)("Filter class name is expected to be test.TestFilter, but it is " + filter.getFilterClassName()), (String)FILTER_CLASS_NAME, (String)filter.getFilterClassName());
                EList params = filter.getInitParams();
                AddWebArtifactOperationTest.assertNotNull((String)"List of initialization parameters cannot be retrieved", (Object)params);
                AddWebArtifactOperationTest.assertEquals((String)("None initialization parameter is expected, but " + params.size() + " are found"), (int)0, (int)params.size());
                EList mappings = webApp.getFilterMappings();
                AddWebArtifactOperationTest.assertEquals((String)("Exactly one filter mapping is expected, but " + mappings.size() + " are found"), (int)1, (int)mappings.size());
                FilterMapping mapping = (FilterMapping)mappings.get(0);
                AddWebArtifactOperationTest.assertEquals((String)("Filter of the mapping is expected to be " + filter.getName() + ", but it is " + mapping.getFilter().getName()), (Object)filter, (Object)mapping.getFilter());
                AddWebArtifactOperationTest.assertEquals((String)("Filter mapping URL pattern value is expected to be /TestFilter, but it is " + mapping.getUrlPattern()), (String)FILTER_DEFAULT_MAPPING, (String)mapping.getUrlPattern());
                AddWebArtifactOperationTest.assertEquals((String)("The filter mapping is not expected to point to a servlet, but it points to servlet " + mapping.getServlet()), null, (Object)mapping.getServlet());
                AddWebArtifactOperationTest.assertEquals((String)("The filter mapping is not expected to point to a servlet, but it points to servlet " + mapping.getServlet()), null, (String)mapping.getServletName());
                EList dispatchers = mapping.getDispatcherType();
                AddWebArtifactOperationTest.assertEquals((String)("None dispatcher is expected in the filter mapping, but " + dispatchers.size() + " are found"), (int)0, (int)dispatchers.size());
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    public void testAddFilter_Web25_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_25);
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj);
        WebApp webApp = (WebApp)provider.getModelObject();
        this.addFilter_Defaults();
        this.assertJavaFileExists(FILTER_CLASS_NAME);
        List filters = webApp.getFilters();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one filter is expected in the model, but " + filters.size() + " are found"), (int)1, (int)filters.size());
        Filter filter = (Filter)filters.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Filter name is expected to be TestFilter, but it is " + filter.getFilterName()), (String)FILTER_NAME, (String)filter.getFilterName());
        AddWebArtifactOperationTest.assertEquals((String)("Filter class name is expected to be test.TestFilter, but it is " + filter.getFilterClass()), (String)FILTER_CLASS_NAME, (String)filter.getFilterClass());
        List displayNames = filter.getDisplayNames();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one display name is expected, but " + displayNames.size() + " are found"), (int)1, (int)displayNames.size());
        DisplayName displayName = (DisplayName)displayNames.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Display name is expected to be TestFilter, but it is " + displayName.getValue()), (String)FILTER_NAME, (String)displayName.getValue());
        List params = filter.getInitParams();
        AddWebArtifactOperationTest.assertNotNull((String)"List of initialization parameters cannot be retrieved", (Object)params);
        AddWebArtifactOperationTest.assertEquals((String)("None initialization parameter is expected, but " + params.size() + " are found"), (int)0, (int)params.size());
        List mappings = webApp.getFilterMappings();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one filter mapping is expected, but " + mappings.size() + " are found"), (int)1, (int)mappings.size());
        org.eclipse.jst.javaee.web.FilterMapping mapping = (org.eclipse.jst.javaee.web.FilterMapping)mappings.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Filter name of the mapping is expected to be TestFilter, but it is " + mapping.getFilterName()), (String)FILTER_NAME, (String)mapping.getFilterName());
        List urlPatterns = mapping.getUrlPatterns();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one URL pattern is expected in the mapping, but " + urlPatterns.size() + " are found"), (int)1, (int)urlPatterns.size());
        UrlPatternType urlPattern = (UrlPatternType)urlPatterns.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Filter mapping URL pattern value is expected to be /TestFilter, but it is " + urlPattern.getValue()), (String)FILTER_DEFAULT_MAPPING, (String)urlPattern.getValue());
        AddWebArtifactOperationTest.assertEquals((String)("None servlet name is expected in the filter mapping, but " + mapping.getServletNames().size() + " are found"), (int)0, (int)mapping.getServletNames().size());
        AddWebArtifactOperationTest.assertEquals((String)("None dispatcher is expected in the filter mapping, but " + mapping.getDispatchers().size() + " are found"), (int)0, (int)mapping.getDispatchers().size());
    }

    public void testAddListener_Web24_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_24);
        WebArtifactEdit webEdit = null;
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        try {
            webEdit = new WebArtifactEdit(proj, false, true);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = webEdit.getWebApp();
            this.addListener_Defaults();
            if (webApp != null) {
                this.assertJavaFileExists(LISTENER_CLASS_NAME);
                EList listeners = webApp.getListeners();
                AddWebArtifactOperationTest.assertEquals((String)("Exactly one listener is expected in the model, but " + listeners.size() + " are found"), (int)1, (int)listeners.size());
                Listener listener = (Listener)listeners.get(0);
                AddWebArtifactOperationTest.assertEquals((String)("Listener test.TestListener is expected in the model, but " + listener.getListenerClassName() + " is found"), (String)LISTENER_CLASS_NAME, (String)listener.getListenerClassName());
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    public void testAddListener_Web25_Defaults() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME, JavaEEFacetConstants.WEB_25);
        IProject proj = ProjectUtilities.getProject((String)WEB_PROJECT_NAME);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj);
        WebApp webApp = (WebApp)provider.getModelObject();
        this.addListener_Defaults();
        this.assertJavaFileExists(LISTENER_CLASS_NAME);
        List listeners = webApp.getListeners();
        AddWebArtifactOperationTest.assertEquals((String)("Exactly one listener is expected in the model, but " + listeners.size() + " are found"), (int)1, (int)listeners.size());
        org.eclipse.jst.javaee.core.Listener listener = (org.eclipse.jst.javaee.core.Listener)listeners.get(0);
        AddWebArtifactOperationTest.assertEquals((String)("Listener test.TestListener is expected in the model, but " + listener.getListenerClass() + " is found"), (String)LISTENER_CLASS_NAME, (String)listener.getListenerClass());
    }

    public void createWebProject(String projectName, IProjectFacetVersion version) throws Exception {
        IDataModel dm = WebProjectCreationOperationTest.getWebDataModel(projectName, null, null, null, null, version, false);
        AddWebArtifactOperationTest.runAndVerify((IDataModel)dm);
    }

    private void addServlet_Defaults() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel(NewServletClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)WEB_PROJECT_NAME);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)SERVLET_NAME);
        AddWebArtifactOperationTest.runAndVerify((IDataModel)dm);
    }

    private void addFilter_Defaults() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel(NewFilterClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)WEB_PROJECT_NAME);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)FILTER_NAME);
        AddWebArtifactOperationTest.runAndVerify((IDataModel)dm);
    }

    private void addListener_Defaults() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel(NewListenerClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)WEB_PROJECT_NAME);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)LISTENER_NAME);
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.add(NewListenerClassDataModelProvider.LISTENER_INTERFACES[0]);
        dm.setProperty("NewJavaClassDataModel.INTERFACES", interfaces);
        AddWebArtifactOperationTest.runAndVerify((IDataModel)dm);
    }

    private void assertJavaFileExists(String fullyQualifiedName) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaModel().getJavaProject(WEB_PROJECT_NAME);
        AddWebArtifactOperationTest.assertNotNull((String)"Java project WebProject not found", (Object)javaProject);
        IType type = javaProject.findType(fullyQualifiedName);
        AddWebArtifactOperationTest.assertNotNull((String)("Java type " + fullyQualifiedName + " not found"), (Object)type);
        IFile file = (IFile)type.getResource();
        AddWebArtifactOperationTest.assertNotNull((String)("Source file for Java type " + fullyQualifiedName + " not found"), (Object)file);
        AddWebArtifactOperationTest.assertTrue((boolean)file.exists());
    }
}

