/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.SecurityIdentity;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.RoleSource;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBRelationshipRoleImpl;
import org.eclipse.jst.j2ee.ejb.internal.impl.MethodPermissionImpl;
import org.eclipse.jst.j2ee.ejb.internal.impl.QueryMethodImpl;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class EjbEMFTest
extends GeneralEMFPopulationTest {
    protected static final EjbPackage EJB_PKG;
    EARFile earFile;
    protected EJBJarFile ejbFile;
    EObject mesBean;
    EObject entityBean;
    SecurityIdentity secID;
    RoleSource roleSource;
    int NUM_BEANS = 10;
    final int NUM_RELATION_ROLES = 2;
    int createdBeans = 0;
    int createdSecRoles = 0;
    protected int createdSecurityIdentities = 0;
    boolean mpFlag = false;
    boolean firstReturnTypeMapping = true;
    static /* synthetic */ Class class$0;

    static {
        J2EEInit.init();
        EJB_PKG = EjbPackage.eINSTANCE;
    }

    public EjbEMFTest(String name) {
        super(name);
    }

    public EjbEMFTest(String name, RendererFactory factory) {
        super(name, factory);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.EjbEMFTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite(RendererFactory factory) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.EjbEMFTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new EjbEMFTest("testEJBJarPopulation", factory));
        suite.addTest((Test)new EjbEMFTest("test14EJBJarPopulation", factory));
        return suite;
    }

    public void testEJBJarPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createEJB();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(3);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEJBEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.setEquivalentLines(this.getEquivalentLinesMap());
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "/EMFTestNoID/ejb-jar.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestEJBEAR/fooEJB/META-INF/ejb-jar.xml";
        EjbEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14EJBJarPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createEJB();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(3);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEJBEAR14";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.setEquivalentLines(this.getEquivalentLinesMap());
        this.getEJB();
        EjbEMFTest.assertEquals((String)"2.1", (String)this.ejbFile.getDeploymentDescriptor().getVersion());
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEJBEAR14_2";
        this.ejbFile.extractTo(out, 126);
        this.ejbFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(out) + "/META-INF/ejb-jar.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestEJBEAR14/fooEJB/META-INF/ejb-jar.xml";
        EjbEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    private Map getEquivalentLinesMap() {
        HashMap<String, String> lines = new HashMap<String, String>();
        lines.put("<cascade-delete></cascade-delete>", "<cascade-delete/>");
        lines.put("<method-params></method-params>", "<method-params/>");
        lines.put("<unchecked></unchecked>", "<unchecked/>");
        lines.put("<use-caller-identity></use-caller-identity>", "<use-caller-identity/>");
        return lines;
    }

    public void getEJB() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEJBEAR14/fooEJB";
        this.ejbFile = this.getArchiveFactory().openEJBJarFile(in);
        EjbEMFTest.assertTrue((this.ejbFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEJB() throws DuplicateObjectException {
        this.ejbFile = this.getArchiveFactory().createEJBJarFileInitialized("fooEJB");
        this.ejbFile = (EJBJarFile)this.earFile.addCopy((ModuleFile)this.ejbFile);
        this.ejbFile.getDeploymentDescriptor().setDisplayName("fooEJB");
        EjbEMFTest.assertTrue((this.ejbFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        EjbEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public EObject createInstance(EReference ref, EObject eObject) {
        EClass eClassifier = (EClass)ref.getEType();
        if (eClassifier.getName().equals("EnterpriseBean")) {
            ++this.createdBeans;
            switch (this.createdBeans) {
                case 3: {
                    return this.createContainerManagedEntityInstance(eClassifier);
                }
                case 7: {
                    return this.createMessageBeanInstance(eClassifier);
                }
                case 4: 
                case 8: {
                    return this.createSessionBeanInstance(eClassifier);
                }
            }
            return this.createEntityBeanInstance(eClassifier);
        }
        if (eClassifier.getName().equals("SecurityIdentity")) {
            return this.createSecurityIdentitiyInstance(eClassifier);
        }
        if (eClassifier.getName().equals("RoleSource")) {
            return this.createRoleSourceInstance(eClassifier);
        }
        if (eClassifier == EcorePackage.eINSTANCE.getEAttribute()) {
            return this.getEjbFactory().createCMPAttribute();
        }
        return super.createInstance(ref, eObject);
    }

    private EObject createSecurityIdentitiyInstance(EClass eClassifier) {
        ++this.createdSecRoles;
        if ((this.createdSecRoles & 1) == 0) {
            return CommonFactory.eINSTANCE.createUseCallerIdentity();
        }
        return CommonFactory.eINSTANCE.createRunAsSpecifiedIdentity();
    }

    private EObject createRoleSourceInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createRoleSource();
    }

    private EObject createMessageBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createMessageDriven();
    }

    private EObject createSessionBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createSession();
    }

    private EObject createEntityBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createEntity();
    }

    private EObject createContainerManagedEntityInstance(EClass eClassifier) {
        return EjbFactory.eINSTANCE.createContainerManagedEntity();
    }

    public int getDepthForAttribute(EStructuralFeature ref) {
        if (ref.getName().equals("enterpriseBeans")) {
            return this.NUM_BEANS;
        }
        if (ref.getName().equals("entityBeans")) {
            return this.NUM_BEANS;
        }
        if (ref.getName().equals("relationshipRoles")) {
            return 2;
        }
        return super.getDepthForAttribute(ref);
    }

    public void populateFeatures(EObject eObject) {
        if (eObject.eClass() == EJB_PKG.getCMPAttribute()) {
            ((CMPAttribute)eObject).setName((String)EMFAttributeFeatureGenerator.createAttribute(EcorePackage.eINSTANCE.getENamedElement_Name(), eObject));
            ((CMPAttribute)eObject).setEType((EClassifier)EMFAttributeFeatureGenerator.createJavaClassProxy((EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType(), eObject));
        } else if (eObject.eClass() == EJB_PKG.getCMRField()) {
            ((CMRField)eObject).setName((String)EMFAttributeFeatureGenerator.createAttribute(EcorePackage.eINSTANCE.getENamedElement_Name(), eObject));
            this.populateSharedReference(eObject, EJB_PKG.getCMRField_CollectionType());
            this.populateSharedReference(eObject, EJB_PKG.getCMRField_Role());
        } else {
            super.populateFeatures(eObject);
        }
    }

    protected void populateAttributes(EObject eObject) {
        if (eObject instanceof QueryMethodImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!(att.equals(EJB_PKG.getMethodElement_Description()) || att.equals(EJB_PKG.getMethodElement_EnterpriseBean()) || att.equals(EJB_PKG.getMethodElement_Type()))) {
                    Object value = this.createAttributeValue(att, eObject);
                    if (att.getName().equals("parms") && value == null) {
                        value = this.createAttributeValue(att, eObject);
                    }
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                }
                ++i;
            }
        } else if (eObject instanceof MethodPermissionImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!att.getName().equals("unchecked") || !this.mpFlag) {
                    Object value = this.createAttributeValue(att, eObject);
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                }
                ++i;
            }
            this.mpFlag = !this.mpFlag;
        } else if (eObject instanceof EJBRelationshipRoleImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            EAttribute lastAttr = null;
            Object value = null;
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!att.getName().equals("cascadeDelete") || !lastAttr.getName().equals("multiplicity") || value.toString().equals("Many")) {
                    value = this.createAttributeValue(att, eObject);
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                    lastAttr = att;
                }
                ++i;
            }
            this.mpFlag = !this.mpFlag;
        } else {
            super.populateAttributes(eObject);
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (ref == EJB_PKG.getCMRField_CollectionType()) {
            this.setReferenceValue(eObject, (EStructuralFeature)ref, JavaClassImpl.createClassRef((String)"java.util.Collection"));
            return;
        }
        if (eObject instanceof MethodPermission && ref.getName().equals("roles")) {
            if (this.mpFlag) {
                return;
            }
            this.mpFlag = !this.mpFlag;
        }
        super.populateSharedReference(eObject, ref);
    }

    protected Object createAttributeValue(EAttribute att, EObject eObject) {
        if (this.firstReturnTypeMapping && att.equals(EJB_PKG.getQuery_ReturnTypeMapping())) {
            super.createAttributeValue(att, eObject);
            this.firstReturnTypeMapping = false;
        } else if (att.equals(EJB_PKG.getEnterpriseBean_Name())) {
            return EMFAttributeFeatureGenerator.createAttribute(att, EJB_PKG.getEntity());
        }
        return super.createAttributeValue(att, eObject);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.earFile = null;
        this.ejbFile = null;
        this.mesBean = null;
        this.entityBean = null;
        this.secID = null;
        this.roleSource = null;
    }
}

