/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.validation.sample.parser.APropertyFile;
import org.eclipse.jst.validation.sample.parser.MessageMetaData;

public class PropertyLine
implements Comparable {
    private String _messageId;
    private String _message = null;
    private String _messagePrefix = null;
    private String _shortMessage = null;
    private int _lineNumber = -1;
    private int _numWords = -1;
    private final String EMPTY = "";
    private APropertyFile _file = null;
    private int _offset = -1;
    private int _messageOffset = -1;
    private static final char QUOTE = '\'';
    private static final char OBRACKET = '{';
    private static final char CBRACKET = '}';
    public static final int UNASSIGNED = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    private int _severity = 0;
    private int _numParms = 0;
    private static final char[] BLANK = "                                                                                                    ".toCharArray();

    public PropertyLine(APropertyFile file, int offset, int messageOffset, String messageId, String message, int lineNumber) {
        this._offset = offset;
        this._messageOffset = messageOffset;
        this._messageId = messageId;
        this._message = message;
        this._lineNumber = lineNumber;
        this._file = file;
        this.parse(message);
    }

    public int compareTo(Object o) {
        if (!(o instanceof PropertyLine)) {
            return 1;
        }
        return this.getMessageId().compareTo(((PropertyLine)o).getMessageId());
    }

    public APropertyFile getFile() {
        return this._file;
    }

    public String getMessagePrefix() {
        return this._messagePrefix;
    }

    public boolean hasMessagePrefix() {
        if (this._messagePrefix == null) {
            return false;
        }
        return !this._messagePrefix.equals("");
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getMessage() {
        return this._message;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public String getShortMessage() {
        return this._shortMessage;
    }

    public int getNumWords() {
        if (this._numWords == -1) {
            this._numWords = 0;
            StringTokenizer tokenizer = new StringTokenizer(this.getShortMessage());
            this._numWords = tokenizer.countTokens();
        }
        return this._numWords;
    }

    public int getLength() {
        return this.getMessage().length();
    }

    public int getExpectedLength(int lengthParm) {
        if (this.hasParameters() && lengthParm > 0) {
            return this.getExpectedMessage(lengthParm).length();
        }
        return this.getLength();
    }

    public String getExpectedMessage(int lengthParm) {
        if (this.hasParameters() && lengthParm > 0) {
            String blank = PropertyLine.getBlank(lengthParm);
            int numParm = this.getNumParameters();
            Object[] parm = new String[numParm];
            int i = 0;
            while (i < parm.length) {
                parm[i] = blank;
                ++i;
            }
            try {
                return MessageFormat.format(this.getMessage(), parm);
            }
            catch (IllegalArgumentException exc) {
                if (this.getFile().debug()) {
                    this.getFile().report(exc.getMessage());
                    this.getFile().report(String.valueOf(this.getFile().getQualifiedFileName()) + "::" + this.getMessageId());
                }
                return this.getMessage();
            }
        }
        return this.getMessage();
    }

    public static String getBlank(int length) {
        char[] blank = new char[length];
        if (length > BLANK.length) {
            int i = 0;
            while (i < length) {
                blank[i] = 32;
                ++i;
            }
        } else {
            System.arraycopy(BLANK, 0, blank, 0, length);
        }
        return new String(blank);
    }

    public boolean hasParameters() {
        return this.getNumParameters() > 0;
    }

    public int getNumParameters() {
        return this._numParms;
    }

    public int getMessageOffset() {
        return this._messageOffset;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getSeverity() {
        return this._severity;
    }

    public void parse(String message) {
        if (message == null) {
            this._messagePrefix = "";
            this._shortMessage = "";
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(message);
        int numTokens = tokenizer.countTokens();
        if (numTokens == 0) {
            this._messagePrefix = "";
            this._shortMessage = message;
        } else {
            String errorId = tokenizer.nextToken();
            boolean prefixExists = false;
            String afterPrefix = null;
            if (errorId.length() >= 9) {
                afterPrefix = errorId.substring(0, 9);
                char[] temp = afterPrefix.toCharArray();
                prefixExists = Character.isLetter(temp[0]) && Character.isUpperCase(temp[0]);
                prefixExists = prefixExists && Character.isLetter(temp[1]) && Character.isUpperCase(temp[0]);
                prefixExists = prefixExists && Character.isLetter(temp[2]) && Character.isUpperCase(temp[0]);
                prefixExists = prefixExists && Character.isLetter(temp[3]) && Character.isUpperCase(temp[0]);
                prefixExists = prefixExists && Character.isDigit(temp[4]);
                prefixExists = prefixExists && Character.isDigit(temp[5]);
                prefixExists = prefixExists && Character.isDigit(temp[6]);
                prefixExists = prefixExists && Character.isDigit(temp[7]);
                boolean bl = prefixExists = prefixExists && Character.isLetter(temp[8]) && Character.isUpperCase(temp[0]);
                if (prefixExists) {
                    switch (temp[8]) {
                        case 'E': {
                            this._severity = 1;
                            break;
                        }
                        case 'W': {
                            this._severity = 2;
                            break;
                        }
                        case 'I': {
                            this._severity = 3;
                            break;
                        }
                        default: {
                            this._severity = 0;
                        }
                    }
                    this._messagePrefix = afterPrefix;
                    int colonIndex = errorId.indexOf(58);
                    boolean noColon = colonIndex == -1;
                    int shortMessageIndex = 10;
                    if (noColon) {
                        if (numTokens > 1) {
                            String nextToken = tokenizer.nextToken();
                            colonIndex = nextToken.indexOf(58);
                            boolean bl2 = noColon = colonIndex == -1 || nextToken.trim().indexOf(58) != 0;
                            if (noColon) {
                                shortMessageIndex = 10;
                            } else if (numTokens > 2) {
                                nextToken = tokenizer.nextToken();
                                shortMessageIndex = message.indexOf(nextToken);
                            } else {
                                shortMessageIndex = colonIndex + 1;
                            }
                            this._shortMessage = message.substring(shortMessageIndex, message.length());
                        } else {
                            this._shortMessage = "";
                        }
                    } else {
                        shortMessageIndex = colonIndex + 1;
                        this._shortMessage = message.substring(shortMessageIndex, message.length());
                    }
                }
            }
            if (!prefixExists) {
                this._messagePrefix = "";
                this._shortMessage = message;
            }
        }
        this.getFile().addParseWarnings(this.parseMessage());
    }

    public List parseMessage() {
        MessageMetaData mmd;
        ArrayList<Integer> intList = new ArrayList<Integer>();
        int numObrackets = 0;
        int numCbrackets = 0;
        int index = 0;
        int singleQuoteIndex = -1;
        int doubleQuoteIndex = -1;
        int missingTerminatingQuoteIndex = -1;
        boolean parmExists = false;
        int numCharBeforeShort = this.getMessageOffset() + this.getMessage().indexOf(this.getShortMessage());
        while (index < this.getShortMessage().length()) {
            int token = this.getShortMessage().charAt(index++);
            if (token == 39) {
                token = index < this.getShortMessage().length() ? (int)this.getShortMessage().charAt(index++) : 32;
                if (token == 123 || token == 125) {
                    token = index < this.getShortMessage().length() ? (int)this.getShortMessage().charAt(index++) : 32;
                    if (token == 39) continue;
                    missingTerminatingQuoteIndex = numCharBeforeShort + index - 1;
                    continue;
                }
                if (token == 39) {
                    doubleQuoteIndex = numCharBeforeShort + index - 1;
                    continue;
                }
                singleQuoteIndex = numCharBeforeShort + index - 1;
                continue;
            }
            if (token == 123) {
                ++numObrackets;
                parmExists = true;
                StringBuffer numBuffer = null;
                if (index >= this.getShortMessage().length()) continue;
                numBuffer = new StringBuffer();
                while (index < this.getShortMessage().length()) {
                    char digit = this.getShortMessage().charAt(index);
                    if (!Character.isDigit(digit) && digit != '-' && digit != '+') break;
                    numBuffer.append(digit);
                    ++index;
                }
                try {
                    if (numBuffer == null || numBuffer.length() <= 0) continue;
                    Integer parmNum = Integer.valueOf(numBuffer.toString());
                    intList.add(parmNum);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (token != 125) continue;
            ++numCbrackets;
        }
        this._numParms = Math.max(numObrackets, numCbrackets);
        ArrayList<MessageMetaData> messages = new ArrayList<MessageMetaData>();
        if (numObrackets != numCbrackets) {
            MessageMetaData mmd2 = new MessageMetaData("propertiesValidator", 1, "ABCD0000", new String[]{String.valueOf(numObrackets), String.valueOf(numCbrackets)}, this, this.getLineNumber());
            messages.add(mmd2);
        }
        if (missingTerminatingQuoteIndex != -1) {
            MessageMetaData mmd3 = new MessageMetaData("propertiesValidator", 3, "ABCD0110", new String[]{String.valueOf(missingTerminatingQuoteIndex)}, this, this.getLineNumber(), this.getOffset() + missingTerminatingQuoteIndex, 1);
            messages.add(mmd3);
        }
        Collections.sort(intList, new Comparator(){

            public int compare(Object a, Object b) {
                return (Integer)a - (Integer)b;
            }
        });
        Iterator iterator = intList.iterator();
        int parmCount = 0;
        int lastNumber = -1;
        int largestNumber = -1;
        while (iterator.hasNext()) {
            MessageMetaData mmd4;
            Integer parm = (Integer)iterator.next();
            if (parm < 0) {
                mmd4 = new MessageMetaData("propertiesValidator", 1, "ABCD0010E", new String[]{String.valueOf(parm)}, this, this.getLineNumber());
                messages.add(mmd4);
            } else if (parm == lastNumber) {
                mmd4 = new MessageMetaData("propertiesValidator", 3, "ABCD0020", new String[]{String.valueOf(lastNumber)}, this, this.getLineNumber());
                messages.add(mmd4);
            } else if (parm != parmCount) {
                mmd4 = new MessageMetaData("propertiesValidator", 3, "ABCD0030", new String[]{String.valueOf(parmCount)}, this, this.getLineNumber());
                messages.add(mmd4);
            } else {
                ++parmCount;
            }
            lastNumber = parm;
            largestNumber = Math.max(largestNumber, parm);
        }
        if (largestNumber > 0) {
            this._numParms = largestNumber + 1;
        }
        if (largestNumber > 9) {
            mmd = new MessageMetaData("propertiesValidator", 2, "ABCD0010W", new String[]{String.valueOf(largestNumber)}, this, this.getLineNumber());
            messages.add(mmd);
        }
        if (singleQuoteIndex > -1 && parmExists) {
            mmd = new MessageMetaData("propertiesValidator", 3, "ABCD0040", new String[]{String.valueOf(singleQuoteIndex)}, this, this.getLineNumber(), this.getOffset() + singleQuoteIndex, 1);
            messages.add(mmd);
        } else if (doubleQuoteIndex > -1 && !parmExists) {
            mmd = new MessageMetaData("propertiesValidator", 3, "ABCD0050", new String[]{String.valueOf(doubleQuoteIndex)}, this, this.getLineNumber(), this.getOffset() + doubleQuoteIndex, 1);
            messages.add(mmd);
        }
        return messages;
    }

    public String toString() {
        StringBuffer buffer = null;
        buffer = this.getFile() == null ? new StringBuffer() : new StringBuffer(this.getFile().getQualifiedFileName());
        buffer.append("\tLine number: ");
        buffer.append(String.valueOf(this.getLineNumber()));
        buffer.append("\t");
        buffer.append(this.getMessageId());
        buffer.append(" = ");
        buffer.append(this.getMessage());
        return buffer.toString();
    }

    public String toStringWithExpectedLength(int length) {
        StringBuffer buffer = null;
        buffer = this.getFile() == null ? new StringBuffer() : new StringBuffer(this.getFile().getQualifiedFileName());
        buffer.append("\tLine number: ");
        buffer.append(String.valueOf(this.getLineNumber()));
        buffer.append("\t");
        buffer.append(this.getMessageId());
        buffer.append(" = ");
        buffer.append(this.getExpectedMessage(length));
        return buffer.toString();
    }

    public String getShortMessagePrefix() {
        String prefix = this.getMessagePrefix();
        if (prefix.equals("")) {
            return "";
        }
        char prefixEnd = prefix.charAt(prefix.length() - 1);
        if (prefixEnd == 'E' || prefixEnd == 'W' || prefixEnd == 'I') {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyLine)) {
            return false;
        }
        PropertyLine oLine = (PropertyLine)o;
        if (this.getLineNumber() != oLine.getLineNumber()) {
            return false;
        }
        return this.getFile().equals(oLine.getFile());
    }

    public int hashCode() {
        return this.getFile().hashCode() + this.getLineNumber();
    }
}

