/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.modelListeners;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.tests.JavaProjectUtil;
import org.eclipse.jem.tests.modelListeners.IListenerTester;

public abstract class TestListeners
extends TestCase {
    protected IJavaProject jp;
    protected List setupSpecials = Arrays.asList("testOpen", "testClose", "testAddMethodInWorkcopy", "testSaveFromWorkingCopy", "testRevert", "testDeleteMethodNoWorkingCopy-obsolete, removed", "testAddClass", "testDeleteClassWithWorkingCopy", "testDeleteClassNoWorkingCopy", "testAddPackage", "testDeletePackage");
    protected IListenerTester tester;
    protected ICompilationUnit testCU;
    protected IPackageFragment testPkg;

    protected void setUp() throws Exception {
        super.setUp();
        this.jp = JavaCore.create((IProject)JavaProjectUtil.getProject("Test BeanInfo"));
        String testname = this.getName();
        int index = this.setupSpecials.indexOf(testname);
        switch (index) {
            case 0: {
                this.setUpOpen();
                break;
            }
            case 1: {
                this.setUpClose();
                break;
            }
            case 2: {
                this.setUpAddMethodInWorkingCopy();
                break;
            }
            case 3: {
                this.setUpSaveFromWorkingCopy();
                break;
            }
            case 4: {
                this.setUpRevert();
                break;
            }
            case 6: {
                this.setupAddClass();
                break;
            }
            case 7: {
                this.setupDeleteClassWithWorkingCopy();
                break;
            }
            case 8: {
                this.setUpDeleteClassNoWorkingCopy();
                break;
            }
            case 9: {
                this.setUpAddPackage();
                break;
            }
            case 10: {
                this.setUpDeletePackage();
                break;
            }
        }
    }

    protected void tearDown() throws Exception {
        String testname = this.getName();
        int index = this.setupSpecials.indexOf(testname);
        switch (index) {
            case 0: {
                this.tearDownOpen();
                break;
            }
            case 1: {
                this.tearDownClose();
                break;
            }
            case 2: {
                this.tearDownAddMethodInWorkingCopy();
                break;
            }
            case 3: {
                this.tearDownSaveFromWorkingCopy();
                break;
            }
            case 4: {
                this.tearDownRevert();
                break;
            }
            case 6: {
                this.tearDownAddClass();
                break;
            }
            case 7: {
                this.tearDownDeleteClassWithWorkingCopy();
                break;
            }
            case 8: {
                this.tearDownDeleteClassNoWorkingCopy();
                break;
            }
            case 9: {
                this.tearDownAddPackage();
                break;
            }
            case 10: {
                this.tearDownDeletePackage();
                break;
            }
        }
        super.tearDown();
    }

    protected void setTester(IListenerTester tester) {
        this.tester = tester;
    }

    protected void setUpOpen() {
    }

    public void testOpen() throws JavaModelException {
        this.testCU = (ICompilationUnit)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo/Test1Class.java"));
        this.testCU.becomeWorkingCopy(null, null);
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownOpen() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.discardWorkingCopy();
        }
    }

    protected void setUpClose() throws JavaModelException {
        this.testCU = (ICompilationUnit)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo/Test1Class.java"));
        this.testCU.becomeWorkingCopy(null, null);
    }

    public void testClose() throws JavaModelException {
        this.testCU.discardWorkingCopy();
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownClose() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.discardWorkingCopy();
        }
    }

    protected void setUpAddMethodInWorkingCopy() throws JavaModelException {
        this.testCU = (ICompilationUnit)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo/Test1Class.java"));
        this.testCU.becomeWorkingCopy(null, null);
    }

    public void testAddMethodInWorkcopy() throws JavaModelException {
        this.testCU.getTypes()[0].createMethod("private void getSomething() {}", null, true, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownAddMethodInWorkingCopy() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.discardWorkingCopy();
        }
    }

    protected void setUpSaveFromWorkingCopy() throws JavaModelException {
        this.testCU = (ICompilationUnit)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo/Test1Class.java"));
        this.testCU.becomeWorkingCopy(null, null);
        this.testCU.getTypes()[0].createMethod("private void getSomething() {}", null, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testSaveFromWorkingCopy() throws JavaModelException {
        this.testCU.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownSaveFromWorkingCopy() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.discardWorkingCopy();
        }
    }

    protected void setUpRevert() throws JavaModelException {
        this.testCU = (ICompilationUnit)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo/Test1Class.java"));
        this.testCU.becomeWorkingCopy(null, null);
        this.testCU.getTypes()[0].createMethod("private void getSomething() {}", null, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testRevert() throws JavaModelException {
        this.testCU.restore();
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownRevert() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.discardWorkingCopy();
        }
    }

    protected void setupAddClass() {
    }

    public void testAddClass() throws JavaModelException {
        IPackageFragment pkg = (IPackageFragment)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo"));
        this.testCU = pkg.createCompilationUnit("NewClass.java", "public class NewClass {}", true, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownAddClass() throws JavaModelException {
        if (this.testCU != null) {
            this.testCU.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void setupDeleteClassWithWorkingCopy() throws JavaModelException {
        IPackageFragment pkg = (IPackageFragment)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo"));
        this.testCU = pkg.createCompilationUnit("NewClass.java", "public class NewClass {}", true, (IProgressMonitor)new NullProgressMonitor());
        this.testCU.becomeWorkingCopy(null, null);
    }

    public void testDeleteClassWithWorkingCopy() throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestListeners.this.testCU.delete(true, (IProgressMonitor)new NullProgressMonitor());
                ResourcesPlugin.getWorkspace().checkpoint(true);
                TestListeners.this.testCU.discardWorkingCopy();
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
        this.testCU = null;
    }

    protected void tearDownDeleteClassWithWorkingCopy() throws JavaModelException {
        if (this.testCU != null && this.testCU.exists()) {
            this.testCU.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void setUpDeleteClassNoWorkingCopy() throws JavaModelException {
        IPackageFragment pkg = (IPackageFragment)this.jp.findElement((IPath)new Path("org/eclipse/jem/tests/beaninfo"));
        this.testCU = pkg.createCompilationUnit("NewClass.java", "public class NewClass {}", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testDeleteClassNoWorkingCopy() throws JavaModelException {
        this.testCU.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
        this.testCU = null;
    }

    protected void tearDownDeleteClassNoWorkingCopy() throws JavaModelException {
        if (this.testCU != null && this.testCU.exists()) {
            this.testCU.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void setUpAddPackage() throws JavaModelException {
        IPackageFragment pkg = (IPackageFragment)this.jp.findElement((IPath)new Path("test"));
        if (pkg != null) {
            pkg.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void testAddPackage() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.jp.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                roots[i].createPackageFragment("test", true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
        this.tester.isException();
        this.tester.isComplete();
    }

    protected void tearDownAddPackage() throws JavaModelException {
        IPackageFragment pkg = (IPackageFragment)this.jp.findElement((IPath)new Path("test"));
        if (pkg != null) {
            pkg.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void setUpDeletePackage() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.jp.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                this.testPkg = roots[i].createPackageFragment("test", true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
    }

    public void testDeletePackage() throws JavaModelException {
        this.testPkg.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.tester.isException();
        this.tester.isComplete();
        this.testPkg = null;
    }

    protected void tearDownDeletePackage() throws JavaModelException {
        if (this.testPkg != null && this.testPkg.exists()) {
            this.testPkg.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

