/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.tests.plugin.TestsPlugin;
import org.eclipse.jst.ws.tests.unittest.WSJUnitConstants;
import org.eclipse.jst.ws.tests.util.JUnitUtils;

public class ComponentCreationTests
extends TestCase
implements WSJUnitConstants {
    public static Test suite() {
        return new TestSuite(ComponentCreationTests.class);
    }

    public void testWebComponentCreation() {
        this.createServerRuntime();
        this.createDynamicWebModule(projectNames);
    }

    public static boolean createProjects() {
        IPath localZipPath = ComponentCreationTests.getLocalPath();
        ProjectUnzipUtil util = new ProjectUnzipUtil(localZipPath, projectNames);
        return util.createProjects();
    }

    private static IPath getLocalPath() {
        URL url = TestsPlugin.getDefault().find((IPath)zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    public void createServerRuntime() {
        try {
            JUnitUtils.createServerRuntime("org.eclipse.jst.server.tomcat.runtime.50", SERVER_INSTALL_PATH);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDynamicWebModule(String[] projectNames) {
        int i = 0;
        while (i < projectNames.length) {
            JUnitUtils.createWebModule(projectNames[i], projectNames[i], null, "org.eclipse.jst.server.tomcat.50", "14", null, (IProgressMonitor)new NullProgressMonitor());
            IProject p = ResourceUtils.getWorkspaceRoot().getProject(projectNames[i]);
            ComponentCreationTests.assertTrue((boolean)p.exists());
            ++i;
        }
    }
}

