/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeType;

public class ServerCreationTest
extends TestCase {
    RuntimeType j2eeRuntimeType = null;
    private static final String ID = "org.eclipse.jst.server.generic.jonas4";
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        IRuntimeType[] listAll = ServerCore.getRuntimeTypes();
        if (listAll != null) {
            int i = 0;
            while (i < listAll.length) {
                IRuntimeType runtimeType = listAll[i];
                if ("J2EE Runtime Library".equals(runtimeType.getName())) {
                    this.j2eeRuntimeType = (RuntimeType)runtimeType;
                }
                ++i;
            }
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ServerCreationTest(String name) {
        super(name);
    }

    public void testGetTypes() {
        ServerCreationTest.assertNotNull((Object)this.j2eeRuntimeType);
    }

    public void testCreateServer() throws Exception {
        IServerType[] sTypes = ServerCore.getServerTypes();
        IServerType serverType = null;
        int i = 0;
        while (i < sTypes.length) {
            IServerType sType = sTypes[i];
            if (ID.equals(sType.getId())) {
                serverType = sType;
            }
            ++i;
        }
        ServerCreationTest.assertNotNull((String)"Could not find org.eclipse.jst.server.generic.jonas4 server type", serverType);
        IRuntimeType runtimeType = serverType.getRuntimeType();
        ServerCreationTest.assertNotNull((String)"Could not find runtime type for the generic server type", (Object)runtimeType);
        IRuntimeWorkingCopy runtime = runtimeType.createRuntime("org.eclipse.jst.server.generic.jonas4.Jonas.Runtime", null);
        ServerCreationTest.assertNotNull((String)"Could not create runtime", (Object)runtime);
        IServerWorkingCopy server = serverType.createServer("org.eclipse.jst.server.generic.jonas4.Jonas.Server", null, (IRuntime)runtime, null);
        ServerCreationTest.assertNotNull((String)"Could not create server", (Object)server);
        server.save(false, null);
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        ServerCreationTest.assertNotNull((String)"Could not create runtime working copy", (Object)runtimeWorkingCopy);
        ServerUtil.setRuntimeDefaultName((IRuntimeWorkingCopy)runtimeWorkingCopy);
        ServerCreationTest.assertNotNull((String)"Runtime working copy has no name", (Object)runtimeWorkingCopy.getName());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericServerRuntime runtimeDelegate = (GenericServerRuntime)runtimeWorkingCopy.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
        ServerCreationTest.assertNotNull((String)"Could not obtain runtime delegate", (Object)runtimeDelegate);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("mappernames", "");
        props.put("classPathVariableName", "JONAS");
        props.put("serverAddress", "127.0.0.1");
        props.put("jonasBase", "C:\\nmd\\dev\\java\\appservers\\JOnAS-4.1.4");
        props.put("jonasRoot", "C:\\nmd\\dev\\java\\appservers\\JOnAS-4.1.4");
        props.put("classPath", "C:\\nmd\\dev\\java\\appservers\\JOnAS-4.1.4");
        props.put("protocols", "C:\\nmd\\dev\\java\\appservers\\JOnAS-4.1.4");
        props.put("port", "9000");
        runtimeDelegate.setServerInstanceProperties(props);
        runtimeWorkingCopy.save(false, null);
    }

    public void testGetWebTypes() {
        IRuntimeType[] listWeb = ServerUtil.getRuntimeTypes((String)"jst.web", null);
        ServerCreationTest.assertNotNull((Object)listWeb);
        boolean found = listWeb.length > 0;
        ServerCreationTest.assertTrue((boolean)found);
    }
}

