/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;

public class ResourceRenameChange
extends Change {
    private IPath fResourcePath;
    private String fNewName;

    public ResourceRenameChange(IResource resource, String newName) {
        this(resource.getFullPath(), newName);
    }

    private ResourceRenameChange(IPath resourcePath, String newName) {
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ResourceRenameChange resourceRenameChange;
        try {
            pm.beginTask(RefactoringMessages.getString("XSDRenameResourceChange.rename_resource"), 1);
            this.getResource().move(ResourceRenameChange.renamedResourcePath(this.fResourcePath, this.fNewName), this.getCoreRenameFlags(), pm);
            String oldName = this.fResourcePath.lastSegment();
            IPath newPath = ResourceRenameChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resourceRenameChange = new ResourceRenameChange(newPath, oldName);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return resourceRenameChange;
    }

    private int getCoreRenameFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    public String getName() {
        return RefactoringMessages.getFormattedString("XSDRenameResourceChange.name", new String[]{this.fResourcePath.toString(), ResourceRenameChange.renamedResourcePath(this.fResourcePath, this.fNewName).toString()});
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }
}

