/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;
import org.eclipse.wst.sse.core.internal.encoding.util.Assert;
import org.eclipse.wst.sse.core.internal.encoding.util.BufferedLimitedStream;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.encoding.util.NullInputStream;
import org.eclipse.wst.sse.core.internal.encoding.util.UnicodeBOMEncodingDetector;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;

public class CodedReaderCreator
extends CodedIO {
    private boolean fClientSuppliedStream;
    private EncodingMemento fEncodingMemento;
    private EncodingRule fEncodingRule;
    private String fFilename;
    private IFile fIFile;
    private InputStream fInputStream;

    public CodedReaderCreator() {
    }

    public CodedReaderCreator(IFile file) throws CoreException, IOException {
        this();
        this.set(file);
        this.setEncodingRule(EncodingRule.CONTENT_BASED);
    }

    public CodedReaderCreator(IFile file, EncodingRule encodingRule) throws CoreException, IOException {
        this();
        this.set(file);
        this.setEncodingRule(encodingRule);
    }

    public CodedReaderCreator(String filename, InputStream inputStream) {
        this();
        this.set(filename, inputStream);
        this.setEncodingRule(EncodingRule.CONTENT_BASED);
    }

    public CodedReaderCreator(String filename, InputStream inputStream, EncodingRule encodingRule) {
        this();
        this.set(filename, inputStream);
        this.setEncodingRule(encodingRule);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EncodingMemento checkForEncodingInContents(InputStream limitedStream) throws CoreException, IOException {
        EncodingMemento result = null;
        if (this.fEncodingMemento != null) {
            result = this.fEncodingMemento;
        } else {
            if (!this.fClientSuppliedStream) return null;
            try {
                limitedStream.reset();
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentDescription contentDescription = contentTypeManager.getDescriptionFor(limitedStream, this.fFilename, IContentDescription.ALL);
                if (contentDescription != null) {
                    this.fEncodingMemento = this.createMemento(contentDescription);
                }
                result = this.fEncodingMemento;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                limitedStream.reset();
                throw throwable;
            }
            {
                Object var5_7 = null;
                limitedStream.reset();
            }
        }
        if (result == null) return result;
        if (result.isValid()) return result;
        if (this.forceDefault()) return result;
        throw new UnsupportedCharsetExceptionWithDetail(result);
    }

    private EncodingMemento checkStreamForBOM(InputStream resettableLimitedStream) {
        EncodingMemento result = null;
        UnicodeBOMEncodingDetector unicodeBOMEncodingDetector = new UnicodeBOMEncodingDetector();
        unicodeBOMEncodingDetector.set(resettableLimitedStream);
        result = unicodeBOMEncodingDetector.getEncodingMemento();
        return result;
    }

    private EncodingMemento findMementoFromFileCase() throws CoreException, IOException {
        EncodingMemento result = null;
        IContentDescription contentDescription = null;
        try {
            if (this.fIFile.exists()) {
                contentDescription = this.fIFile.getContentDescription();
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (contentDescription == null && this.fIFile.isAccessible()) {
            InputStream contents = null;
            try {
                contents = this.fIFile.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(contents, this.fIFile.getName(), IContentDescription.ALL);
            }
            catch (CoreException e1) {
                Logger.logException(e1);
                throw e1;
            }
            catch (IOException e2) {
                Logger.logException(e2);
                throw e2;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException e2) {
                    Logger.logException(e2);
                }
            }
        }
        if (contentDescription != null) {
            result = this.createMemento(contentDescription);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private EncodingMemento findMementoFromStreamCase() throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean forceDefault() {
        boolean result = false;
        if (this.fEncodingRule != null && this.fEncodingRule == EncodingRule.FORCE_DEFAULT) {
            result = true;
        }
        return result;
    }

    public Reader getCodedReader() throws CoreException, IOException {
        BufferedReader result = null;
        EncodingMemento encodingMemento = this.getEncodingMemento();
        Assert.isNotNull(encodingMemento, "Appears reader requested before file or stream set");
        InputStream streamToReturn = this.getResettableStream();
        streamToReturn.reset();
        if (encodingMemento.isUnicodeStream()) {
            streamToReturn.skip(2L);
        } else if (encodingMemento.isUTF83ByteBOMUsed()) {
            streamToReturn.skip(3L);
        }
        String charsetName = encodingMemento.getJavaCharsetName();
        if (charsetName == null) {
            charsetName = encodingMemento.getDetectedCharsetName();
        }
        if (!encodingMemento.isValid() && !this.forceDefault()) {
            throw new UnsupportedCharsetExceptionWithDetail(encodingMemento);
        }
        if (this.fEncodingRule == EncodingRule.FORCE_DEFAULT) {
            charsetName = encodingMemento.getAppropriateDefault();
        }
        Charset charset = Charset.forName(charsetName);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        if (this.fEncodingRule == EncodingRule.IGNORE_CONVERSION_ERROR) {
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        } else {
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        result = new BufferedReader(new InputStreamReader(streamToReturn, charsetDecoder), 8192);
        ((Reader)result).mark(8192);
        return result;
    }

    public EncodingMemento getEncodingMemento() throws CoreException, IOException {
        if (this.fEncodingMemento == null) {
            if (this.fClientSuppliedStream) {
                this.fEncodingMemento = this.findMementoFromStreamCase();
            } else if (this.fIFile != null) {
                this.fEncodingMemento = this.findMementoFromFileCase();
            }
        }
        if (this.fEncodingMemento == null || this.fEncodingMemento.getDetectedCharsetName() == null) {
            this.fEncodingMemento = this.getEncodingMementoFromResourceAndPreference();
        }
        if (this.fEncodingMemento == null) {
            this.fEncodingMemento = this.handleNotProvidedFromContentCase();
        }
        return this.fEncodingMemento;
    }

    private EncodingMemento getEncodingMementoFromResourceAndPreference() throws IOException, CoreException {
        EncodingMemento encodingMemento = this.fEncodingMemento;
        if (this.fIFile != null) {
            String charset = this.fIFile.getCharset();
            encodingMemento = CodedIO.createEncodingMemento(charset);
        }
        return encodingMemento;
    }

    private InputStream getLimitedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original instanceof BufferedLimitedStream) {
            return original;
        }
        BufferedLimitedStream s = new BufferedLimitedStream(original, 8192);
        ((InputStream)s).mark(8192);
        return s;
    }

    private InputStream getResettableStream() throws CoreException, IOException {
        InputStream resettableStream = null;
        if (this.fIFile != null) {
            InputStream inputStream = null;
            try {
                inputStream = this.fIFile.getContents(true);
            }
            catch (CoreException e) {
                Logger.logException(e);
                inputStream = new NullInputStream();
            }
            resettableStream = new BufferedInputStream(inputStream, 8192);
        } else if (this.fInputStream != null) {
            if (this.fInputStream.markSupported()) {
                resettableStream = this.fInputStream;
                resettableStream.reset();
            } else {
                resettableStream = new BufferedInputStream(this.fInputStream, 8192);
            }
        }
        if (resettableStream == null) {
            resettableStream = new NullInputStream();
        }
        resettableStream.mark(8192);
        return resettableStream;
    }

    private EncodingMemento handleNotProvidedFromContentCase() {
        EncodingMemento result = null;
        String specDefault = null;
        String charset = NonContentBasedEncodingRules.useDefaultNameRules(specDefault);
        Assert.isNotNull(charset, "post condition failed");
        result = CodedIO.createEncodingMemento(charset);
        return result;
    }

    private void handleStreamClose(InputStream resettableInputStream) throws IOException {
        if (resettableInputStream != null) {
            if (this.fClientSuppliedStream) {
                resettableInputStream.reset();
            } else {
                resettableInputStream.close();
            }
        }
    }

    void migrateContentPropertiesEncoding(String encoding) throws CoreException {
        final IFile file = this.fIFile;
        final String charset = encoding;
        Job migrater = new Job(SSECoreMessages.Migrate_Charset){

            protected IStatus run(IProgressMonitor monitor) {
                if (file != null) {
                    try {
                        file.setCharset(charset, null);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        migrater.setSystem(true);
        migrater.schedule();
    }

    private void resetAll() {
        this.fEncodingRule = null;
        this.fIFile = null;
        this.fFilename = null;
        this.fInputStream = null;
        this.fEncodingMemento = null;
        this.fClientSuppliedStream = false;
    }

    public void set(IFile iFile) throws CoreException, IOException {
        Assert.isNotNull(iFile, "illegal argument");
        this.resetAll();
        this.fIFile = iFile;
    }

    public void set(String filename, InputStream inputStream) {
        this.resetAll();
        this.fFilename = filename;
        this.fInputStream = inputStream;
        this.fClientSuppliedStream = true;
    }

    public void setEncodingRule(EncodingRule encodingRule) {
        this.fEncodingRule = encodingRule;
    }
}

