/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.commands.range.ApplyStyleCommand;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.HTMLGraphicalViewerListenenerAdapter;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewerListener;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class ChangeStyleAction
extends Action
implements IUpdate {
    private IHTMLGraphicalViewer _viewer;
    private String _expectedTag;
    private IHTMLGraphicalViewerListener _listener = new HTMLGraphicalViewerListenenerAdapter(){

        public void selectionChangeFinished() {
            ChangeStyleAction.this.update();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ChangeStyleAction.this.update();
        }
    };

    public ChangeStyleAction(String text, String name, ImageDescriptor image, int style) {
        super(text, style);
        this._expectedTag = name;
        this.setImageDescriptor(image);
    }

    public void setViewer(IHTMLGraphicalViewer viewer) {
        if (viewer == this._viewer) {
            return;
        }
        if (this._viewer != null) {
            this._viewer.removeHTMLViewerListener(this._listener);
        }
        this._viewer = viewer;
        if (this._viewer != null) {
            this._viewer.addHTMLViewerListener(this._listener);
        }
        this.update();
    }

    public void update() {
        boolean update = this.checkForUpdateAndMaybeDisableState();
        if (update) {
            this.updateState();
        }
    }

    protected void updateState() {
        DesignRange range = this._viewer.getRangeSelection();
        this.updateStatus(RangeUtil.normalize(range));
    }

    protected final boolean checkForUpdateAndMaybeDisableState() {
        if (this._viewer == null) {
            this.setChecked(false);
            this.setEnabled(false);
            return false;
        }
        if (!this._viewer.isInRangeMode()) {
            this.setChecked(false);
            this.setEnabled(false);
            return false;
        }
        DesignRange range = this._viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            this.setChecked(false);
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    protected final DesignRange getDesignRange() {
        return this._viewer.getRangeSelection();
    }

    private void updateStatus(DesignRange range) {
        if (range.isEmpty()) {
            this.setEnabled(false);
            this.setChecked(false);
        } else {
            this.setEnabled(true);
            this.setChecked(false);
        }
    }

    public void run() {
        boolean apply;
        if (this._viewer == null || !this._viewer.isInRangeMode()) {
            return;
        }
        DesignRange range = this._viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            return;
        }
        if (range.isEmpty()) {
            return;
        }
        boolean bl = apply = !this.isChecked();
        if (apply) {
            this.applyStyle();
        }
    }

    private void applyStyle() {
        ApplyStyleCommand command = new ApplyStyleCommand(this._viewer, this.getExpectedTag(), this.getExpectedCSSProperty(), this.getExpectedCSSPropertyValue());
        command.execute();
    }

    protected abstract String getExpectedCSSPropertyValue();

    protected abstract String getExpectedCSSProperty();

    protected String getExpectedTag() {
        return this._expectedTag;
    }
}

