/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PackageFragment
extends Openable
implements IPackageFragment,
IVirtualParent,
SuffixConstants {
    protected static final IClassFile[] NO_CLASSFILES = new IClassFile[0];
    protected static final IJavaScriptUnit[] NO_COMPILATION_UNITS = new IJavaScriptUnit[0];
    public String[] names;

    protected PackageFragment(PackageFragmentRoot root, String[] names) {
        super(root);
        this.names = names;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int kind = this.getKind();
        if (kind == 1 && Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<IJavaScriptUnit> vChildren = new HashSet<IJavaScriptUnit>();
        try {
            PackageFragmentRoot root = this.getPackageFragmentRoot();
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int length = members.length;
            if (length > 0) {
                IJavaScriptProject project = this.getJavaScriptProject();
                String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                String complianceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                int i = 0;
                while (i < length) {
                    IResource child = members[i];
                    if (child.getType() != 2 && !Util.isExcluded(child, inclusionPatterns, exclusionPatterns)) {
                        ITypeRoot childElement;
                        if (kind == 1 && Util.isValidCompilationUnitName(child.getName(), sourceLevel, complianceLevel)) {
                            childElement = new CompilationUnit(this, child.getName(), DefaultWorkingCopyOwner.PRIMARY);
                            vChildren.add((IJavaScriptUnit)childElement);
                        } else if (kind == 2 && Util.isValidClassFileName(child.getName(), sourceLevel, complianceLevel)) {
                            childElement = this.getClassFile(child.getName());
                            vChildren.add((IJavaScriptUnit)childElement);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
        if (kind == 1) {
            IJavaScriptUnit[] primaryCompilationUnits = this.getJavaScriptUnits(DefaultWorkingCopyOwner.PRIMARY);
            int i = 0;
            int length = primaryCompilationUnits.length;
            while (i < length) {
                IJavaScriptUnit primary = primaryCompilationUnits[i];
                vChildren.add(primary);
                ++i;
            }
        }
        IJavaScriptElement[] children = new IJavaScriptElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public boolean containsJavaResources() throws JavaScriptModelException {
        return ((PackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public void copy(IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] containers = new IJavaScriptElement[]{container};
        IJavaScriptElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaScriptElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaScriptModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public IJavaScriptUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    protected Object createElementInfo() {
        return new PackageFragmentInfo();
    }

    public void delete(boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        this.getJavaScriptModel().delete(elements, force, monitor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragment)) {
            return false;
        }
        PackageFragment other = (PackageFragment)o;
        return Util.equalArraysOrNull(this.names, other.names) && this.parent.equals(other.parent);
    }

    public boolean exists() {
        return super.exists() && !Util.isExcluded(this);
    }

    public IClassFile getClassFile(String classFileName) {
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(classFileName) && !Util.isMetadataFileName(classFileName)) {
            throw new IllegalArgumentException(Messages.element_invalidClassFileName);
        }
        String filename = "";
        if (this.getResource() != null) {
            filename = String.valueOf(this.getResource().getLocation().toOSString()) + File.separator + classFileName;
        }
        return !Util.isMetadataFileName(classFileName) ? new ClassFile(this, filename) : new MetadataFile(this, filename);
    }

    public IClassFile[] getClassFiles() throws JavaScriptModelException {
        if (this.getKind() == 1) {
            return NO_CLASSFILES;
        }
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public IJavaScriptUnit getCompilationUnit(String cuName, String superTypeName) {
        int pi;
        if (!Util.isJavaLikeFileName(cuName)) {
            throw new IllegalArgumentException(Messages.convention_unit_notJavaName);
        }
        String parentName = new String();
        try {
            IResource parentNameR = this.parent.getResource();
            parentName = parentNameR == null ? null : String.valueOf(parentNameR.getName()) + "/";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (parentName != null && (pi = cuName.indexOf(parentName)) > -1 && pi < 2) {
            String newCp = "/" + cuName.substring(pi + parentName.length(), cuName.length());
            return new CompilationUnit(this, newCp, superTypeName, DefaultWorkingCopyOwner.PRIMARY);
        }
        return new CompilationUnit(this, cuName, superTypeName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IJavaScriptUnit getJavaScriptUnit(String cuName) {
        return this.getCompilationUnit(cuName, null);
    }

    public IJavaScriptUnit[] getJavaScriptUnits() throws JavaScriptModelException {
        if (this.getKind() == 2) {
            return NO_COMPILATION_UNITS;
        }
        ArrayList list = this.getChildrenOfType(5);
        IJavaScriptUnit[] array = new IJavaScriptUnit[list.size()];
        list.toArray(array);
        return array;
    }

    public IJavaScriptUnit[] getJavaScriptUnits(WorkingCopyOwner owner) {
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return JavaModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        IJavaScriptUnit[] result = new IJavaScriptUnit[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IJavaScriptUnit wc = workingCopies[i];
            if (this.equals(wc.getParent()) && !Util.isExcluded(wc)) {
                result[index++] = wc;
            }
            ++i;
        }
        if (index != length) {
            IJavaScriptUnit[] iJavaScriptUnitArray = result;
            result = new IJavaScriptUnit[index];
            System.arraycopy(iJavaScriptUnitArray, 0, result, 0, index);
        }
        return result;
    }

    public String getElementName() {
        return Util.concatWith(this.names, '/');
    }

    public int getElementType() {
        return 4;
    }

    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '(': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                JavaElement classFile = (JavaElement)((Object)this.getClassFile(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String cuName = memento.nextToken();
                CompilationUnit cu = new CompilationUnit(this, cuName, owner);
                return cu.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public int getKind() throws JavaScriptModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    public Object[] getNonJavaScriptResources() throws JavaScriptModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentInfo)this.getElementInfo()).getNonJavaResources(this.getResource(), this.getPackageFragmentRoot());
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        IPath path = root.getPath();
        int i = 0;
        int length = this.names.length;
        while (i < length) {
            String name = this.names[i];
            path = path.append(name);
            ++i;
        }
        return path;
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!root.isResourceContainer()) {
            return root.getResource();
        }
        int length = this.names.length;
        if (length == 0) {
            return root.getResource();
        }
        Path path = new Path(this.names[0]);
        int i = 1;
        while (i < length) {
            path = path.append(this.names[i]);
            ++i;
        }
        return ((IContainer)root.getResource()).getFolder((IPath)path);
    }

    public IResource getUnderlyingResource() throws JavaScriptModelException {
        IResource rootResource = this.parent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = this.names;
            int i = 0;
            while (i < segs.length) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
                ++i;
            }
            return folder;
        }
        return rootResource;
    }

    public int hashCode() {
        int hash = this.parent.hashCode();
        int i = 0;
        int length = this.names.length;
        while (i < length) {
            hash = Util.combineHashCodes(this.names[i].hashCode(), hash);
            ++i;
        }
        return hash;
    }

    public boolean hasChildren() throws JavaScriptModelException {
        return this.getChildren().length > 0;
    }

    public boolean hasSubpackages() throws JavaScriptModelException {
        IJavaScriptElement[] packages = ((IPackageFragmentRoot)this.getParent()).getChildren();
        int namesLength = this.names.length;
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                String[] otherNames = ((PackageFragment)packages[i]).names;
                if (otherNames.length > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.names[j].equals(otherNames[j])) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.names.length == 0;
    }

    public void move(IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] containers = new IJavaScriptElement[]{container};
        IJavaScriptElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaScriptElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaScriptModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] dests = new IJavaScriptElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getJavaScriptModel().rename(elements, dests, renamings, force, monitor);
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (tab == 0) {
            super.toStringChildren(tab, buffer, info);
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (this.names.length == 0) {
            buffer.append("<default>");
        } else {
            this.toStringName(buffer);
        }
        if (info == null) {
            buffer.append(" (not open)");
        } else if (tab > 0) {
            buffer.append(" (...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaScriptModelException {
        JavaModelManager.PerProjectInfo projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaScriptProject().getProject());
        String cachedJavadoc = null;
        LRUCache lRUCache = projectInfo.javadocCache;
        synchronized (lRUCache) {
            cachedJavadoc = (String)projectInfo.javadocCache.get(this);
        }
        if (cachedJavadoc != null) {
            return cachedJavadoc;
        }
        URL baseLocation = this.getJavadocBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        StringBuffer pathBuffer = new StringBuffer(baseLocation.toExternalForm());
        if (pathBuffer.charAt(pathBuffer.length() - 1) != '/') {
            pathBuffer.append('/');
        }
        String packPath = this.getElementName().replace('.', '/');
        pathBuffer.append(packPath).append('/').append("package-summary.html");
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String contents = this.getURLContents(String.valueOf(pathBuffer));
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (contents == null) {
            throw new JavaScriptModelException(new JavaModelStatus(1008, this));
        }
        LRUCache lRUCache2 = projectInfo.javadocCache;
        synchronized (lRUCache2) {
            projectInfo.javadocCache.put(this, contents);
        }
        return contents;
    }

    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        if (this.parent instanceof PackageFragmentRoot) {
            return ((PackageFragmentRoot)this.parent).getContainerInitializer();
        }
        return null;
    }

    public boolean isSource() {
        try {
            return this.getPackageFragmentRoot().getKind() == 1;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return true;
        }
    }
}

