/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class JRESelectDecorator
implements GenericServerCompositeDecorator {
    private List installedJREs;
    private String[] jreNames;
    private GenericServerRuntime fRuntime;
    private IWizardHandle fWizard;

    public JRESelectDecorator(GenericServerRuntime runtime, IWizardHandle wizardHandle) {
        this.fRuntime = runtime;
        this.fWizard = wizardHandle;
    }

    public void decorate(final GenericServerComposite composite) {
        this.updateJREs();
        Link link = new Link((Composite)composite, 0);
        link.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        link.setText(GenericServerUIMessages.installed_jre_link);
        Label label = new Label((Composite)composite, 0);
        label.setText(GenericServerUIMessages.jre_select_label);
        final Combo combo = new Combo((Composite)composite, 12);
        combo.setItems(this.jreNames);
        GridData data = new GridData(4, 0, false, false, 2, 1);
        combo.setLayoutData((Object)data);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)JRESelectDecorator.this.installedJREs.get(sel - 1);
                }
                JRESelectDecorator.this.fRuntime.setVMInstall(vmInstall);
                JRESelectDecorator.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = combo.getText();
                if (JRESelectDecorator.this.showPreferencePage(composite)) {
                    JRESelectDecorator.this.updateJREs();
                    combo.setItems(JRESelectDecorator.this.jreNames);
                    combo.setText(currentVM);
                    if (combo.getSelectionIndex() == -1) {
                        combo.select(0);
                    }
                }
            }
        });
        if (this.fRuntime != null) {
            if (this.fRuntime.isUsingDefaultJRE()) {
                combo.select(0);
            } else {
                combo.setText(this.fRuntime.getVMInstall().getName());
            }
        }
    }

    protected boolean showPreferencePage(GenericServerComposite composite) {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode("org.eclipse.jdt.debug.ui.preferences.VMPreferencePage");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(composite.getShell(), manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)composite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = GenericServerUIMessages.defaultJRE;
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    public boolean validate() {
        IStatus status = this.fRuntime.validate();
        if (status.getSeverity() != 0) {
            this.fWizard.setMessage(status.getMessage(), 3);
            this.fWizard.update();
            return true;
        }
        this.fWizard.setMessage("", 0);
        this.fWizard.update();
        return false;
    }
}

