/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.details.AbstractJpaDetailsPage;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeDetailsPage<T extends PersistentAttribute>
extends AbstractJpaDetailsPage<T> {
    private JpaComposite<AttributeMapping> currentMappingComposite;
    private String currentMappingKey;
    private Map<String, JpaComposite<AttributeMapping>> mappingComposites;
    private PageBook mappingPageBook;

    protected PersistentAttributeDetailsPage(Composite parent, WidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMappingProperty");
        propertyNames.add("specifiedMappingProperty");
    }

    protected AttributeMappingUiProvider<? extends AttributeMapping> attributeMappingUiProvider(String key) {
        Iterator<AttributeMappingUiProvider<AttributeMapping>> i = this.attributeMappingUiProviders();
        while (i.hasNext()) {
            AttributeMappingUiProvider<AttributeMapping> provider = i.next();
            if (provider.getMappingKey() != key) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported attribute mapping UI provider key: ");
    }

    protected abstract Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders();

    protected abstract AttributeMappingUiProvider<? extends AttributeMapping>[] attributeMappingUiProvidersFor(PersistentAttribute var1);

    private PropertyAspectAdapter<PersistentAttribute, AttributeMapping> buildGenericMappingHolder() {
        return new PropertyAspectAdapter<PersistentAttribute, AttributeMapping>(this.getSubjectHolder(), new String[]{"defaultMappingProperty", "specifiedMappingProperty"}){

            protected AttributeMapping buildValue_() {
                return ((PersistentAttribute)this.subject).getMapping();
            }
        };
    }

    protected JpaComposite<AttributeMapping> buildMappingComposite(PageBook pageBook, String mappingKey) {
        AttributeMappingUiProvider<AttributeMapping> uiProvider = this.mappingUIProvider(mappingKey);
        return uiProvider.buildAttributeMappingComposite(this.jpaUiFactory(), this.buildMappingHolder(mappingKey), (Composite)pageBook, this.getWidgetFactory());
    }

    private Filter<AttributeMapping> buildMappingFilter(String mappingKey) {
        return new MappingFilter(mappingKey);
    }

    private PropertyValueModel<AttributeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.buildGenericMappingHolder(), this.buildMappingFilter(key));
    }

    protected Label buildMappingLabel(Composite parent) {
        return this.buildLabel(parent, JptUiMessages.PersistentAttributePage_mapAs);
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        this.mappingPageBook = new PageBook(parent, 0);
        this.mappingPageBook.showPage((Control)this.buildLabel((Composite)this.mappingPageBook, ""));
        return this.mappingPageBook;
    }

    protected abstract AttributeMappingUiProvider<? extends AttributeMapping> defaultAttributeMappingUiProvider(String var1);

    protected abstract Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders();

    @Override
    protected void doDispose() {
        this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.doDispose()");
        if (this.currentMappingComposite != null) {
            this.currentMappingComposite.dispose();
            this.currentMappingComposite = null;
        }
        this.mappingComposites.clear();
        super.doDispose();
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateMappingPage();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.mappingComposites = new HashMap<String, JpaComposite<AttributeMapping>>();
    }

    @Override
    protected void log(String flag, String message) {
        super.log(flag, message);
        if ("/debug/ui/detailsView".equals(flag) && Tracing.booleanDebugOption("/debug/ui/detailsView")) {
            Tracing.log(message);
        }
    }

    private JpaComposite<AttributeMapping> mappingCompositeFor(String key) {
        JpaComposite<AttributeMapping> composite = this.mappingComposites.get(key);
        if (composite != null) {
            return composite;
        }
        composite = this.buildMappingComposite(this.mappingPageBook, key);
        if (composite != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    protected void mappingPageChanged(JpaComposite<AttributeMapping> mappingComposite) {
    }

    private AttributeMappingUiProvider<? extends AttributeMapping> mappingUIProvider(String key) {
        if (((PersistentAttribute)this.subject()).getMapping() == null || ((PersistentAttribute)this.subject()).getMapping().isDefault()) {
            return this.defaultAttributeMappingUiProvider(key);
        }
        return this.attributeMappingUiProvider(key);
    }

    private void populateMappingPage(String mappingKey) {
        if (this.currentMappingKey == mappingKey) {
            this.mappingPageChanged(this.currentMappingComposite);
            return;
        }
        if (this.currentMappingComposite != null) {
            this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.populateMappingPage() disposing of current page: " + this.currentMappingKey);
            try {
                this.currentMappingComposite.dispose();
                this.currentMappingComposite = null;
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
        this.currentMappingKey = mappingKey;
        if (this.currentMappingKey != null) {
            this.currentMappingComposite = this.mappingCompositeFor(mappingKey);
            try {
                this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.populateMappingPage() populating new page: " + this.currentMappingKey);
                this.currentMappingComposite.populate();
                this.mappingPageBook.showPage(this.currentMappingComposite.getControl());
                this.mappingPageChanged(this.currentMappingComposite);
                this.repaintDetailsView((Composite)this.mappingPageBook);
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
                this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.populateMappingPage() error encountered");
                try {
                    this.currentMappingComposite.dispose();
                }
                catch (Exception exception) {
                    JptUiPlugin.log(e);
                }
                this.mappingComposites.remove(this.currentMappingComposite);
                this.currentMappingComposite = null;
                this.mappingPageBook.showPage((Control)this.buildLabel((Composite)this.mappingPageBook, ""));
            }
        } else {
            this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.populateMappingPage() no page to show");
            this.mappingPageBook.showPage((Control)this.buildLabel((Composite)this.mappingPageBook, ""));
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "defaultMappingProperty" || propertyName == "specifiedMappingProperty") {
            this.updateMappingPage();
        }
    }

    @Override
    protected boolean repopulateWithNullSubject() {
        return false;
    }

    private void updateMappingPage() {
        AttributeMapping mapping = this.subject() != null ? ((PersistentAttribute)this.subject()).getMapping() : null;
        this.populateMappingPage(mapping == null ? null : mapping.getKey());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappingFilter
    implements Filter<AttributeMapping> {
        private String mappingKey;

        MappingFilter(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        public boolean accept(AttributeMapping mapping) {
            return mapping == null || this.mappingKey.equals(mapping.getKey());
        }
    }
}

