/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.jface;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.ui.jface.ItemContentProvider;
import org.eclipse.jpt.ui.jface.ItemContentProviderFactory;
import org.eclipse.jpt.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.ui.jface.ItemLabelProviderFactory;
import org.eclipse.swt.graphics.Image;

public abstract class DelegatingContentAndLabelProvider
extends BaseLabelProvider
implements IStructuredContentProvider,
ILabelProvider {
    private final ItemContentProviderFactory itemContentProviderFactory;
    private final ItemLabelProviderFactory itemLabelProviderFactory;
    private final Map<Object, ItemContentProvider> itemContentProviders;
    private final Map<Object, ItemLabelProvider> itemLabelProviders;
    StructuredViewer viewer;

    protected DelegatingContentAndLabelProvider(ItemContentProviderFactory itemContentProviderFactory) {
        this(itemContentProviderFactory, null);
    }

    protected DelegatingContentAndLabelProvider(ItemContentProviderFactory itemContentProviderFactory, ItemLabelProviderFactory itemLabelProviderFactory) {
        this.itemContentProviderFactory = itemContentProviderFactory;
        this.itemLabelProviderFactory = itemLabelProviderFactory;
        this.itemContentProviders = new HashMap<Object, ItemContentProvider>();
        this.itemLabelProviders = new HashMap<Object, ItemLabelProvider>();
    }

    protected ItemContentProvider itemContentProvider(Object item) {
        ItemContentProvider itemContentProvider = this.itemContentProviders.get(item);
        if (itemContentProvider != null) {
            return itemContentProvider;
        }
        itemContentProvider = this.itemContentProviderFactory.buildItemContentProvider(item, this);
        if (itemContentProvider == null) {
            return null;
        }
        this.itemContentProviders.put(item, itemContentProvider);
        return itemContentProvider;
    }

    protected ItemLabelProvider itemLabelProvider(Object item) {
        if (this.viewer == null) {
            throw new IllegalStateException("This provider must be used as a contentprovider *as well as* a label provider.");
        }
        ItemLabelProvider itemLabelProvider = this.itemLabelProviders.get(item);
        if (itemLabelProvider != null) {
            return itemLabelProvider;
        }
        itemLabelProvider = this.itemLabelProviderFactory.buildItemLabelProvider(item, this);
        if (itemLabelProvider == null) {
            return null;
        }
        this.itemLabelProviders.put(item, itemLabelProvider);
        return itemLabelProvider;
    }

    public Object[] getElements(Object inputElement) {
        return this.itemContentProvider(inputElement).getElements();
    }

    public Image getImage(Object element) {
        ItemLabelProvider provider = this.itemLabelProvider(element);
        return provider == null ? null : provider.getImage();
    }

    public String getText(Object element) {
        ItemLabelProvider provider = this.itemLabelProvider(element);
        return provider == null ? null : provider.getText();
    }

    public void dispose() {
        this.disposeProviders();
        super.dispose();
    }

    protected void disposeProviders() {
        while (!this.itemContentProviders.isEmpty()) {
            this.dispose(this.itemContentProviders.keySet().iterator().next());
        }
        while (!this.itemLabelProviders.isEmpty()) {
            this.dispose(this.itemLabelProviders.keySet().iterator().next());
        }
    }

    public void dispose(Object item) {
        if (this.itemContentProviders.containsKey(item)) {
            this.itemContentProviders.get(item).dispose();
            this.itemContentProviders.remove(item);
        }
        if (this.itemLabelProviders.containsKey(item)) {
            this.itemLabelProviders.get(item).dispose();
            this.itemLabelProviders.remove(item);
        }
    }

    public void inputChanged(Viewer structuredViewer, Object oldInput, Object newInput) {
        if (oldInput != newInput) {
            this.disposeProviders();
        }
        this.viewer = (StructuredViewer)structuredViewer;
    }

    public void updateContent(final Object item) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DelegatingContentAndLabelProvider.this.viewer != null && DelegatingContentAndLabelProvider.this.viewer.getControl() != null && !DelegatingContentAndLabelProvider.this.viewer.getControl().isDisposed()) {
                    DelegatingContentAndLabelProvider.this.viewer.refresh(item);
                }
            }
        };
        this.viewer.getControl().getDisplay().asyncExec(runnable);
    }

    protected void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        super.fireLabelProviderChanged(event);
    }

    public void updateLabel(final Object item) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DelegatingContentAndLabelProvider.this.viewer != null && DelegatingContentAndLabelProvider.this.viewer.getControl() != null && !DelegatingContentAndLabelProvider.this.viewer.getControl().isDisposed()) {
                    DelegatingContentAndLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DelegatingContentAndLabelProvider.this, item));
                }
            }
        };
        this.viewer.getControl().getDisplay().asyncExec(runnable);
    }
}

