/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class CreateProjectWithLinkedJarOperation
extends J2EEUtilityJarImportAssistantOperation {
    private String linkedPathVariable;
    private String projectRoot;

    public CreateProjectWithLinkedJarOperation(File utilityJar, String overridingProjectRoot, String linkedPathVariable) {
        super(NLS.bind((String)EARCreationResourceHandler.CreateProjectWithLinkedJarOperation_Creating_project_with_linked_archiv_, (Object)utilityJar.getName()), utilityJar);
        this.linkedPathVariable = linkedPathVariable;
        this.projectRoot = this.findUniqueLocation(overridingProjectRoot, this.getUtilityJarProjectName(utilityJar));
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, NLS.bind((String)EARCreationResourceHandler.CreateProjectWithLinkedJarOperation_Creating_project_with_linked_archiv_, (Object)this.getUtilityJar().getName()), null);
        try {
            IProject project = this.getWorkspaceRoot().getProject(this.getUtilityJarProjectName(this.getUtilityJar()));
            IDataModel createUtilityProject = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
            createUtilityProject.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.getUtilityJarProjectName(this.getUtilityJar()));
            if (this.projectRoot != null && this.projectRoot.length() > 0) {
                createUtilityProject.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", false);
                createUtilityProject.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)this.projectRoot);
            }
            createUtilityProject.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)this.getAssociatedEARProjectName());
            status.add(createUtilityProject.getDefaultOperation().execute(monitor, info));
            IProject utilityJarProject = this.getWorkspaceRoot().getProject(this.getUtilityJarProjectName(this.getUtilityJar()));
            IJavaProject utilityJarJavaProject = JavaCore.create((IProject)utilityJarProject);
            IPackageFragmentRoot srcFolder = utilityJarJavaProject.getPackageFragmentRoot((IResource)utilityJarProject.getFolder("src"));
            if (srcFolder.exists()) {
                srcFolder.delete(1, 2, monitor);
            }
            status.add(this.createLinkedArchive(project, this.getUtilityJar().getName(), this.getUtilityJar(), this.linkedPathVariable, monitor));
            IVirtualComponent utilComponent = ComponentCore.createComponent((IProject)project);
            status.add(this.removeRootMapping(utilComponent, "/src", monitor));
            status.add(this.createVirtualArchiveComponent(project, this.getUtilityJar().getName(), project.getFile(this.getUtilityJar().getName()), monitor));
            IProject associatedEARProject = this.getWorkspaceRoot().getProject(this.getAssociatedEARProjectName());
            status.add(this.linkArchiveToEAR(associatedEARProject, this.getUtilityJar().getName(), utilityJarProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        }
        catch (Exception e) {
            status.add(J2EEPlugin.createErrorStatus(0, EARCreationResourceHandler.J2EEUtilityJarListImportOperation_UI_2, e));
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }
}

