/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.utility.internal.StringTools;

public class AsynchronousJpaProjectUpdater
implements JpaProject.Updater {
    protected final JpaProject jpaProject;
    protected final UpdateJob job;

    public AsynchronousJpaProjectUpdater(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.job = this.buildJob();
    }

    protected UpdateJob buildJob() {
        return new UpdateJob();
    }

    public void start() {
        this.job.start();
        this.update();
    }

    public void update() {
        this.job.schedule();
    }

    public void dispose() {
        this.job.dispose();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.jpaProject);
    }

    protected class UpdateJob
    extends Job {
        protected boolean shouldSchedule;

        protected UpdateJob() {
            super("Update JPA project: " + AsynchronousJpaProjectUpdater.this.jpaProject.getName());
            this.shouldSchedule = false;
            this.setRule((ISchedulingRule)AsynchronousJpaProjectUpdater.this.jpaProject.getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            return AsynchronousJpaProjectUpdater.this.jpaProject.update(monitor);
        }

        public boolean shouldSchedule() {
            return this.shouldSchedule;
        }

        protected void start() {
            if (this.shouldSchedule) {
                throw new IllegalStateException("The Updater was not stopped.");
            }
            this.shouldSchedule = true;
        }

        protected void dispose() {
            this.shouldSchedule = false;
            this.cancel();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

