/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaFile
extends AbstractJpaNode
implements JpaFile {
    protected final IFile file;
    protected final ResourceModel resourceModel;
    protected final Map<Object, JpaStructureNode> rootStructureNodes;

    public GenericJpaFile(JpaProject jpaProject, IFile file, ResourceModel resourceModel) {
        super(jpaProject);
        this.file = file;
        this.resourceModel = resourceModel;
        this.rootStructureNodes = new HashMap<Object, JpaStructureNode>();
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("rootStructureNodes");
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public ResourceModel getResourceModel() {
        return this.resourceModel;
    }

    @Override
    public Iterator<JpaStructureNode> rootStructureNodes() {
        return new CloneIterator(this.rootStructureNodes.values());
    }

    @Override
    public int rootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    @Override
    public void addRootStructureNode(Object key, JpaStructureNode rootStructureNode) {
        if (this.rootStructureNodes.get(key) == rootStructureNode) {
            return;
        }
        if (this.rootStructureNodes.containsKey(key)) {
            JpaStructureNode removedStructureNode = this.rootStructureNodes.remove(key);
            this.fireItemRemoved("rootStructureNodes", removedStructureNode);
        }
        this.rootStructureNodes.put(key, rootStructureNode);
        this.fireItemAdded("rootStructureNodes", rootStructureNode);
    }

    @Override
    public void removeRootStructureNode(Object key) {
        JpaStructureNode removedStructureNode = this.rootStructureNodes.remove(key);
        this.fireItemRemoved("rootStructureNodes", removedStructureNode);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JpaStructureNode rootNode : CollectionTools.iterable(this.rootStructureNodes())) {
            JpaStructureNode node = rootNode.getStructureNode(textOffset);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getResourceType() {
        return this.getResourceModel().getResourceType();
    }

    @Override
    public void dispose() {
        this.getResourceModel().dispose();
        Set<Object> keys = this.rootStructureNodes.keySet();
        for (Object key : keys) {
            this.removeRootStructureNode(key);
        }
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.getResourceModel().javaElementChanged(event);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getFile().toString());
        sb.append(" (resourceType: ");
        sb.append(this.getResourceType());
        sb.append(")");
    }

    @Override
    public void updateFromResource() {
        this.resourceModel.updateFromResource();
    }
}

