/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinationIndexedDeclarationAnnotationAdapter
implements IndexedDeclarationAnnotationAdapter {
    private final SimpleDeclarationAnnotationAdapter standAloneAnnotationAdapter;
    private final NestedIndexedDeclarationAnnotationAdapter nestedAnnotationAdapter;
    private final NestedIndexedDeclarationAnnotationAdapter zeroNestedAnnotationAdapter;
    private static final AnnotationFactory MARKER_ANNOTATION_FACTORY = new AnnotationFactory(){

        public Annotation newAnnotation(DeclarationAnnotationAdapter adapter, ModifiedDeclaration declaration) {
            return adapter.newMarkerAnnotation(declaration);
        }

        public String toString() {
            return "MarkerAnnotationFactory";
        }
    };
    private static final AnnotationFactory SINGLE_MEMBER_ANNOTATION_FACTORY = new AnnotationFactory(){

        public Annotation newAnnotation(DeclarationAnnotationAdapter adapter, ModifiedDeclaration declaration) {
            return adapter.newSingleMemberAnnotation(declaration);
        }

        public String toString() {
            return "SingleMemberAnnotationFactory";
        }
    };
    private static final AnnotationFactory NORMAL_ANNOTATION_FACTORY = new AnnotationFactory(){

        public Annotation newAnnotation(DeclarationAnnotationAdapter adapter, ModifiedDeclaration declaration) {
            return adapter.newNormalAnnotation(declaration);
        }

        public String toString() {
            return "NormalAnnotationFactory";
        }
    };

    public CombinationIndexedDeclarationAnnotationAdapter(String annotationName, String containerAnnotationName, int index) {
        this(annotationName, containerAnnotationName, "value", index);
    }

    public CombinationIndexedDeclarationAnnotationAdapter(String annotationName, String containerAnnotationName, String elementName, int index) {
        this(new SimpleDeclarationAnnotationAdapter(annotationName), new SimpleDeclarationAnnotationAdapter(containerAnnotationName), elementName, index, annotationName);
    }

    public CombinationIndexedDeclarationAnnotationAdapter(SimpleDeclarationAnnotationAdapter standAloneAnnotationAdapter, SimpleDeclarationAnnotationAdapter containerAnnotationAdapter, int index, String nestedAnnotationName) {
        this(standAloneAnnotationAdapter, containerAnnotationAdapter, "value", index, nestedAnnotationName);
    }

    public CombinationIndexedDeclarationAnnotationAdapter(SimpleDeclarationAnnotationAdapter standAloneAnnotationAdapter, SimpleDeclarationAnnotationAdapter containerAnnotationAdapter, String elementName, int index, String nestedAnnotationName) {
        this.standAloneAnnotationAdapter = standAloneAnnotationAdapter;
        this.nestedAnnotationAdapter = new NestedIndexedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)containerAnnotationAdapter, elementName, index, nestedAnnotationName);
        this.zeroNestedAnnotationAdapter = new NestedIndexedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)containerAnnotationAdapter, elementName, 0, nestedAnnotationName);
    }

    @Override
    public Annotation getAnnotation(ModifiedDeclaration declaration) {
        Annotation standAloneAnnotation;
        if (this.getIndex() == 0 && (standAloneAnnotation = this.getStandAloneAnnotation(declaration)) != null) {
            return standAloneAnnotation;
        }
        return this.getNestedAnnotation(declaration);
    }

    @Override
    public MarkerAnnotation newMarkerAnnotation(ModifiedDeclaration declaration) {
        return (MarkerAnnotation)this.newAnnotation(MARKER_ANNOTATION_FACTORY, declaration);
    }

    @Override
    public SingleMemberAnnotation newSingleMemberAnnotation(ModifiedDeclaration declaration) {
        return (SingleMemberAnnotation)this.newAnnotation(SINGLE_MEMBER_ANNOTATION_FACTORY, declaration);
    }

    @Override
    public NormalAnnotation newNormalAnnotation(ModifiedDeclaration declaration) {
        return (NormalAnnotation)this.newAnnotation(NORMAL_ANNOTATION_FACTORY, declaration);
    }

    @Override
    public void removeAnnotation(ModifiedDeclaration declaration) {
        if (this.getIndex() == 0 && this.standAloneAnnotationIsPresent(declaration)) {
            this.removeStandAloneAnnotation(declaration);
            return;
        }
        this.removeNestedAnnotation(declaration);
        if (this.nestedElementCanBeConvertedToStandAlone(declaration)) {
            this.convertLastElementAnnotationToStandAloneAnnotation(declaration);
        }
    }

    @Override
    public ASTNode getAstNode(ModifiedDeclaration declaration) {
        Annotation annotation = this.getAnnotation(declaration);
        return annotation != null ? annotation : this.nestedAnnotationAdapter.getAstNode(declaration);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getAnnotationName());
    }

    @Override
    public int getIndex() {
        return this.nestedAnnotationAdapter.getIndex();
    }

    @Override
    public void moveAnnotation(int newIndex, ModifiedDeclaration declaration) {
        int oldIndex = this.getIndex();
        if (newIndex == oldIndex) {
            return;
        }
        Annotation standAloneAnnotation = this.getStandAloneAnnotation(declaration);
        if (standAloneAnnotation == null) {
            this.moveNestedAnnotation(newIndex, declaration);
            if (this.nestedElementCanBeConvertedToStandAlone(declaration)) {
                this.convertLastElementAnnotationToStandAloneAnnotation(declaration);
            }
        } else if (oldIndex == 0 && newIndex == 1) {
            this.moveStandAloneAnnotationToContainerAnnotation(standAloneAnnotation, declaration);
            this.moveNestedAnnotation(newIndex, declaration);
        } else if (newIndex == 0) {
            this.removeStandAloneAnnotation(declaration);
        } else {
            throw new IllegalStateException("old index = " + oldIndex + "; new index = " + newIndex);
        }
    }

    private Annotation newAnnotation(AnnotationFactory annotationFactory, ModifiedDeclaration declaration) {
        if (this.getIndex() == 0) {
            return this.newZeroAnnotation(annotationFactory, declaration);
        }
        if (this.zeroNestedAnnotationIsPresent(declaration)) {
            return annotationFactory.newAnnotation(this.nestedAnnotationAdapter, declaration);
        }
        this.moveStandAloneAnnotationToContainerAnnotation(declaration);
        return annotationFactory.newAnnotation(this.nestedAnnotationAdapter, declaration);
    }

    private Annotation newZeroAnnotation(AnnotationFactory annotationFactory, ModifiedDeclaration declaration) {
        if (this.standAloneAnnotationIsPresent(declaration)) {
            return annotationFactory.newAnnotation(this.standAloneAnnotationAdapter, declaration);
        }
        if (this.containerAnnotationIsPresent(declaration)) {
            return annotationFactory.newAnnotation(this.nestedAnnotationAdapter, declaration);
        }
        return annotationFactory.newAnnotation(this.standAloneAnnotationAdapter, declaration);
    }

    private void moveStandAloneAnnotationToContainerAnnotation(ModifiedDeclaration declaration) {
        Annotation standAloneAnnotation = this.getStandAloneAnnotation(declaration);
        if (standAloneAnnotation == null) {
            throw new IllegalStateException("the stand-alone annotation is missing");
        }
        this.moveStandAloneAnnotationToContainerAnnotation(standAloneAnnotation, declaration);
    }

    private void moveStandAloneAnnotationToContainerAnnotation(Annotation standAloneAnnotation, ModifiedDeclaration declaration) {
        if (standAloneAnnotation.isMarkerAnnotation()) {
            this.zeroNestedAnnotationAdapter.newMarkerAnnotation(declaration);
        } else if (standAloneAnnotation.isSingleMemberAnnotation()) {
            Expression vv = ((SingleMemberAnnotation)standAloneAnnotation).getValue();
            vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
            this.zeroNestedAnnotationAdapter.newSingleMemberAnnotation(declaration).setValue(vv);
        } else if (standAloneAnnotation.isNormalAnnotation()) {
            NormalAnnotation newNA = this.zeroNestedAnnotationAdapter.newNormalAnnotation(declaration);
            List<MemberValuePair> values = this.values(newNA);
            for (MemberValuePair pair : this.values((NormalAnnotation)standAloneAnnotation)) {
                values.add((MemberValuePair)ASTNode.copySubtree((AST)pair.getAST(), (ASTNode)pair));
            }
        } else {
            throw new IllegalStateException("unknown annotation type: " + standAloneAnnotation);
        }
        this.removeStandAloneAnnotation(declaration);
    }

    private boolean nestedElementCanBeConvertedToStandAlone(ModifiedDeclaration declaration) {
        Annotation containerAnnotation = this.getContainerAnnotation(declaration);
        if (containerAnnotation == null) {
            return false;
        }
        if (containerAnnotation.isMarkerAnnotation()) {
            return false;
        }
        if (containerAnnotation.isSingleMemberAnnotation()) {
            if (this.getElementName().equals("value")) {
                return ((SingleMemberAnnotation)containerAnnotation).getValue().getNodeType() != 4 && this.zeroNestedAnnotationAdapter.getAnnotation(declaration) != null;
            }
            return false;
        }
        if (containerAnnotation.isNormalAnnotation()) {
            NormalAnnotation na = (NormalAnnotation)containerAnnotation;
            if (na.values().size() == 0) {
                return false;
            }
            if (na.values().size() != 1) {
                return false;
            }
            MemberValuePair pair = (MemberValuePair)na.values().get(0);
            if (this.getElementName().equals(pair.getName().getFullyQualifiedName())) {
                return pair.getValue().getNodeType() != 4 && this.zeroNestedAnnotationAdapter.getAnnotation(declaration) != null;
            }
            return false;
        }
        throw new IllegalStateException("unknown annotation type: " + containerAnnotation);
    }

    private void convertLastElementAnnotationToStandAloneAnnotation(ModifiedDeclaration declaration) {
        Annotation last = this.zeroNestedAnnotationAdapter.getAnnotation(declaration);
        if (last == null) {
            throw new IllegalStateException("the last nested annotation is missing");
        }
        if (last.isMarkerAnnotation()) {
            this.newStandAloneMarkerAnnotation(declaration);
        } else if (last.isSingleMemberAnnotation()) {
            Expression vv = ((SingleMemberAnnotation)last).getValue();
            vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
            this.newStandAloneSingleMemberAnnotation(declaration).setValue(vv);
        } else if (last.isNormalAnnotation()) {
            NormalAnnotation newNA = this.newStandAloneNormalAnnotation(declaration);
            List<MemberValuePair> values = this.values(newNA);
            for (MemberValuePair pair : this.values((NormalAnnotation)last)) {
                values.add((MemberValuePair)ASTNode.copySubtree((AST)pair.getAST(), (ASTNode)pair));
            }
        } else {
            throw new IllegalStateException("unknown annotation type: " + last);
        }
        this.zeroNestedAnnotationAdapter.removeAnnotation(declaration);
    }

    private boolean standAloneAnnotationIsPresent(ModifiedDeclaration declaration) {
        return this.getStandAloneAnnotation(declaration) != null;
    }

    private Annotation getStandAloneAnnotation(ModifiedDeclaration declaration) {
        return this.standAloneAnnotationAdapter.getAnnotation(declaration);
    }

    private MarkerAnnotation newStandAloneMarkerAnnotation(ModifiedDeclaration declaration) {
        return this.standAloneAnnotationAdapter.newMarkerAnnotation(declaration);
    }

    private SingleMemberAnnotation newStandAloneSingleMemberAnnotation(ModifiedDeclaration declaration) {
        return this.standAloneAnnotationAdapter.newSingleMemberAnnotation(declaration);
    }

    private NormalAnnotation newStandAloneNormalAnnotation(ModifiedDeclaration declaration) {
        return this.standAloneAnnotationAdapter.newNormalAnnotation(declaration);
    }

    private void removeStandAloneAnnotation(ModifiedDeclaration declaration) {
        this.standAloneAnnotationAdapter.removeAnnotation(declaration);
    }

    private Annotation getNestedAnnotation(ModifiedDeclaration declaration) {
        return this.nestedAnnotationAdapter.getAnnotation(declaration);
    }

    private void moveNestedAnnotation(int newIndex, ModifiedDeclaration declaration) {
        this.nestedAnnotationAdapter.moveAnnotation(newIndex, declaration);
    }

    private void removeNestedAnnotation(ModifiedDeclaration declaration) {
        this.nestedAnnotationAdapter.removeAnnotation(declaration);
    }

    private boolean containerAnnotationIsPresent(ModifiedDeclaration declaration) {
        return this.getContainerAnnotation(declaration) != null;
    }

    private Annotation getContainerAnnotation(ModifiedDeclaration declaration) {
        return this.nestedAnnotationAdapter.getOuterAnnotationAdapter().getAnnotation(declaration);
    }

    private boolean zeroNestedAnnotationIsPresent(ModifiedDeclaration declaration) {
        return this.getZeroNestedAnnotation(declaration) != null;
    }

    private Annotation getZeroNestedAnnotation(ModifiedDeclaration declaration) {
        return this.zeroNestedAnnotationAdapter.getAnnotation(declaration);
    }

    private String getAnnotationName() {
        return this.nestedAnnotationAdapter.getAnnotationName();
    }

    private String getElementName() {
        return this.nestedAnnotationAdapter.getElementName();
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }

    private static interface AnnotationFactory {
        public Annotation newAnnotation(DeclarationAnnotationAdapter var1, ModifiedDeclaration var2);
    }
}

