/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.policy.utils;

import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.ws.service.internal.policy.DescriptorImpl;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;

public class RegistryUtils {
    public static DescriptorImpl loadDescriptor(IConfigurationElement element) {
        DescriptorImpl descriptor = new DescriptorImpl();
        String shortName = RegistryUtils.getAttribute(element, "shortname");
        String longName = RegistryUtils.getAttribute(element, "longname");
        String description = RegistryUtils.getAttribute(element, "description");
        String iconPath = RegistryUtils.getAttribute(element, "iconpath");
        String contextHelp = RegistryUtils.getAttribute(element, "contexthelpid");
        if (shortName == null && longName == null) {
            ServicePolicyActivator.logError("Short name or Long name missing from service policy descriptor.", null);
        } else if (shortName == null) {
            shortName = longName;
        } else if (longName == null) {
            longName = shortName;
        }
        descriptor.setDescription(description);
        descriptor.setShortName(shortName);
        descriptor.setLongName(longName);
        descriptor.setContextHelpId(contextHelp);
        if (iconPath != null) {
            descriptor.setIconPath(iconPath);
            descriptor.setIconBundleId(element.getContributor().getName());
        }
        descriptor.resetHasChanged();
        return descriptor;
    }

    public static String getAttributeName(IConfigurationElement element, String attribute) {
        String[] names = element.getAttributeNames();
        String result = null;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.toLowerCase(Locale.ENGLISH).equals(attribute)) {
                result = name;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static String getAttribute(IConfigurationElement element, String attribute) {
        String[] names = element.getAttributeNames();
        String value = null;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.toLowerCase(Locale.ENGLISH).equals(attribute)) {
                value = element.getAttribute(name);
                break;
            }
            ++n2;
        }
        return value;
    }
}

