/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.registry;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.Taxonomies;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistry;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistryFactory;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistryPackage;
import org.eclipse.wst.ws.internal.registry.RegistryService;

public class UDDIRegistryService {
    private static UDDIRegistryService instance_;

    private UDDIRegistryService() {
        UDDIRegistryPackage.eINSTANCE.getClass();
    }

    public static UDDIRegistryService instance() {
        if (instance_ == null) {
            instance_ = new UDDIRegistryService();
        }
        return instance_;
    }

    public void addTaxonomy(UDDIRegistry uddiRegistry, Taxonomy taxonomy) {
        this.addTaxonomies(uddiRegistry, new Taxonomy[]{taxonomy});
    }

    public void addTaxonomies(UDDIRegistry uddiRegistry, Taxonomy[] taxonomies) {
        if (taxonomies.length > 0) {
            Taxonomies taxonomySet = uddiRegistry.getTaxonomies();
            if (taxonomySet == null) {
                taxonomySet = UDDIRegistryFactory.eINSTANCE.createTaxonomies();
                uddiRegistry.setTaxonomies(taxonomySet);
            }
            EList list = taxonomySet.getTaxonomy();
            int i = 0;
            while (i < taxonomies.length) {
                list.add((Object)taxonomies[i]);
                ++i;
            }
        }
    }

    public String[] getTaxonomyURIs(UDDIRegistry uddiRegistry) {
        Taxonomies taxonomies = uddiRegistry.getTaxonomies();
        if (taxonomies == null) {
            return new String[0];
        }
        EList taxonomyList = taxonomies.getTaxonomy();
        ArrayList<String> taxonomyURIs = new ArrayList<String>(taxonomyList.size());
        for (Taxonomy taxonomy : taxonomyList) {
            if (taxonomy.getId() != null) {
                taxonomyURIs.add(taxonomy.getId());
                continue;
            }
            if (taxonomy.getRef() == null) continue;
            taxonomyURIs.add(taxonomy.getRef());
        }
        return taxonomyURIs.toArray(new String[0]);
    }

    public Taxonomy[] getTaxonomies(UDDIRegistry uddiRegistry) throws CoreException {
        RegistryService registryService = RegistryService.instance();
        Taxonomies taxonomies = uddiRegistry.getTaxonomies();
        if (taxonomies == null) {
            return new Taxonomy[0];
        }
        EList literalTaxonomyList = taxonomies.getTaxonomy();
        ArrayList<Taxonomy> resolvedTaxonomyList = new ArrayList<Taxonomy>(literalTaxonomyList.size());
        for (Taxonomy literalTaxonomy : literalTaxonomyList) {
            if (literalTaxonomy.getId() != null) {
                resolvedTaxonomyList.add(literalTaxonomy);
                continue;
            }
            if (literalTaxonomy.getLocation() == null) continue;
            try {
                Taxonomy resolvedTaxonomy = registryService.loadTaxonomy(new URL(literalTaxonomy.getLocation()));
                resolvedTaxonomyList.add(resolvedTaxonomy);
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
            }
        }
        return resolvedTaxonomyList.toArray(new Taxonomy[0]);
    }

    public UDDIRegistry newUDDIRegistry() {
        return UDDIRegistryFactory.eINSTANCE.createUDDIRegistry();
    }
}

