/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenScope;
import org.eclipse.jpt.gen.internal.ManyToManyRelation;
import org.eclipse.jpt.gen.internal.ManyToOneRelation;
import org.eclipse.jpt.gen.internal.OneToManyRelation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenTable {
    private final GenScope scope;
    private final Table table;
    private final EntityGenerator.Config entityConfig;
    private final String entityName;
    private ManyToManyRelation joinTableRelation;
    private Collection<ManyToManyRelation> ownedManyToManyRelations = new ArrayList<ManyToManyRelation>();
    private Collection<ManyToManyRelation> nonOwnedManyToManyRelations = new ArrayList<ManyToManyRelation>();
    private Collection<ManyToOneRelation> manyToOneRelations = new ArrayList<ManyToOneRelation>();
    private Collection<OneToManyRelation> oneToManyRelations = new ArrayList<OneToManyRelation>();
    private Set<Column> foreignKeyColumns = new HashSet<Column>();
    private final Map<Object, String> fieldNames = new HashMap<Object, String>();
    private static final Object EMBEDDED_ID_VIRTUAL_COLUMN = new Object();

    GenTable(GenScope scope, Table table, EntityGenerator.Config entityConfig, Collection<String> entityNames) {
        this.scope = scope;
        this.table = table;
        this.entityConfig = entityConfig;
        this.entityName = this.buildEntityName(entityNames);
    }

    private String buildEntityName(Collection<String> entityNames) {
        String name = this.table.getShortJavaClassName();
        String overrideEntityName = this.entityConfig.getOverrideEntityName(this.table);
        if (overrideEntityName == null) {
            if (this.entityConfig.convertToCamelCase()) {
                name = NameTools.convertToJavaIdentifier((String)StringTools.convertUnderscoresToCamelCase((String)name));
            }
        } else {
            name = overrideEntityName;
        }
        name = NameTools.uniqueNameForIgnoreCase((String)name, entityNames);
        entityNames.add(name);
        return name;
    }

    void configureManyToManyRelations() {
        if (this.table.foreignKeysSize() != 2) {
            return;
        }
        Iterator stream = this.table.columns();
        while (stream.hasNext()) {
            if (this.table.foreignKeyBaseColumnsContains((Column)stream.next())) continue;
            return;
        }
        Iterator fKeys = this.table.foreignKeys();
        ForeignKey owningFK = (ForeignKey)fKeys.next();
        ForeignKey nonOwningFK = (ForeignKey)fKeys.next();
        GenTable owningTable = this.scope.genTable(owningFK.getReferencedTable());
        GenTable nonOwningTable = this.scope.genTable(nonOwningFK.getReferencedTable());
        if (owningTable == null || nonOwningTable == null) {
            return;
        }
        this.joinTableRelation = new ManyToManyRelation(this, owningFK, owningTable, nonOwningFK, nonOwningTable);
    }

    void addReferencedTablesTo(Set<GenTable> referencedTables) {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable genTable = this.scope.genTable(fk.getReferencedTable());
            if (genTable == null) continue;
            referencedTables.add(genTable);
        }
    }

    void clearJoinTableRelation() {
        this.joinTableRelation.clear();
        this.joinTableRelation = null;
    }

    void configureManyToOneRelations() {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable referencedtable = this.scope.genTable(fk.getReferencedTable());
            if (referencedtable == null) continue;
            this.manyToOneRelations.add(new ManyToOneRelation(this, fk, referencedtable));
        }
    }

    void configureFieldNames() {
        Set columns = CollectionTools.set((Iterator)this.table.columns());
        if (this.table.primaryKeyColumnsSize() > 1 && this.entityConfig.generateEmbeddedIdForCompoundPK()) {
            this.configureFieldName(EMBEDDED_ID_VIRTUAL_COLUMN, "pk");
        }
        this.configureManyToOneFieldNames(columns);
        this.configureBasicFieldNames(columns);
        this.configureOneToManyFieldNames();
        this.configureOwnedManyToManyFieldNames();
        this.configureNonOwnedManyToManyFieldNames();
    }

    Iterator<Column> readOnlyPrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column column) {
                return GenTable.this.foreignKeyColumnsContains(column);
            }
        };
    }

    Iterator<Column> writablePrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column column) {
                return !GenTable.this.foreignKeyColumnsContains(column);
            }
        };
    }

    Iterator<Column> nonPrimaryKeyBasicColumns() {
        return new FilteringIterator<Column, Column>(this.table.columns()){

            protected boolean accept(Column column) {
                return !GenTable.this.primaryKeyColumnsContains(column) && !GenTable.this.foreignKeyColumnsContains(column);
            }
        };
    }

    Table getTable() {
        return this.table;
    }

    String getEntityName() {
        return this.entityName;
    }

    boolean isJoinTable() {
        return this.joinTableRelation != null;
    }

    void addOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.add(relation);
    }

    void removeOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.remove(relation);
    }

    void addNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.add(relation);
    }

    void removeNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.remove(relation);
    }

    void addOneToManyRelation(OneToManyRelation relation) {
        this.oneToManyRelations.add(relation);
    }

    String javaFieldName() {
        return this.table.getJavaFieldName();
    }

    Iterator<ManyToOneRelation> manyToOneRelations() {
        return this.manyToOneRelations.iterator();
    }

    Iterator<OneToManyRelation> oneToManyRelations() {
        return this.oneToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> ownedManyToManyRelations() {
        return this.ownedManyToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> nonOwnedManyToManyRelations() {
        return this.nonOwnedManyToManyRelations.iterator();
    }

    private String fieldNameForInternal(Object o) {
        return this.fieldNames.get(o);
    }

    String fieldNameForEmbeddedId() {
        return this.fieldNameForInternal(EMBEDDED_ID_VIRTUAL_COLUMN);
    }

    String fieldNameFor(Column column) {
        return this.fieldNameForInternal(column);
    }

    String fieldNameFor(ManyToOneRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String fieldNameFor(OneToManyRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String fieldNameFor(ManyToManyRelation relation) {
        return this.fieldNameForInternal(relation);
    }

    String name() {
        return this.table.getName();
    }

    private void configureManyToOneFieldNames(Set<Column> columns) {
        for (ManyToOneRelation relation : this.manyToOneRelations) {
            CollectionTools.removeAll(columns, (Iterator)relation.getForeignKey().nonPrimaryKeyBaseColumns());
            CollectionTools.addAll(this.foreignKeyColumns, (Iterator)relation.getForeignKey().baseColumns());
            relation.setMappedBy(this.configureFieldName(relation, relation.javaFieldName()));
        }
    }

    private String configureFieldName(Object o, String fieldName) {
        fieldName = this.camelCaseFieldName(fieldName);
        fieldName = NameTools.uniqueNameFor((String)fieldName, this.fieldNames.values());
        this.fieldNames.put(o, fieldName);
        return fieldName;
    }

    private String camelCaseFieldName(String name) {
        return this.entityConfig.convertToCamelCase() ? NameTools.convertToJavaIdentifier((String)StringTools.convertUnderscoresToCamelCase((String)name, (boolean)false)) : name;
    }

    private void configureBasicFieldNames(Set<Column> columns) {
        for (Column column : columns) {
            this.configureFieldName(column, column.getJavaFieldName());
        }
    }

    private void configureOneToManyFieldNames() {
        for (OneToManyRelation relation : this.oneToManyRelations) {
            this.configureFieldName(relation, relation.javaFieldName());
        }
    }

    private void configureOwnedManyToManyFieldNames() {
        for (ManyToManyRelation relation : this.ownedManyToManyRelations) {
            relation.setMappedBy(this.configureFieldName(relation, relation.javaFieldNameFor(this)));
        }
    }

    private void configureNonOwnedManyToManyFieldNames() {
        for (ManyToManyRelation relation : this.nonOwnedManyToManyRelations) {
            this.configureFieldName(relation, relation.javaFieldNameFor(this));
        }
    }

    boolean foreignKeyColumnsContains(Column column) {
        return this.foreignKeyColumns.contains(column);
    }

    boolean primaryKeyColumnsContains(Column column) {
        return this.table.primaryKeyColumnsContains(column);
    }
}

