/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SingleRelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaPersistentAttribute;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSingleRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaRelationshipMapping<T>
implements JavaSingleRelationshipMapping {
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();
    protected JavaJoinColumn defaultJoinColumn;
    protected Boolean specifiedOptional;

    protected AbstractJavaSingleRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public FetchType getDefaultFetch() {
        return SingleRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn newJoinColumn) {
        JavaJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefaultJoinColumn = this.getDefaultJoinColumn();
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnResource = (JoinColumnAnnotation)this.getResourcePersistentAttribute().addAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.initializeFromResource(joinColumnResource);
        this.fireItemAdded("specifiedJoinColumnsList", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(this.getResourcePersistentAttribute()));
        }
        this.getResourcePersistentAttribute().removeAnnotation(index, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourcePersistentAttribute().move(targetIndex, sourceIndex, "javax.persistence.JoinColumns");
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldSpecifiedOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.setOptionalOnResourceModel(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldSpecifiedOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldSpecifiedOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldSpecifiedOptional, newSpecifiedOptional);
    }

    protected abstract void setOptionalOnResourceModel(Boolean var1);

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initializeFromResource(resourcePersistentAttribute);
        this.initializeSpecifiedJoinColumns(resourcePersistentAttribute);
        this.initializeDefaultJoinColumn(resourcePersistentAttribute);
    }

    @Override
    protected void initialize(T relationshipMapping) {
        super.initialize(relationshipMapping);
        this.specifiedOptional = this.specifiedOptional(relationshipMapping);
    }

    protected void initializeSpecifiedJoinColumns(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator annotations = resourcePersistentAttribute.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn((JoinColumnAnnotation)annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns() && this.isRelationshipOwner();
    }

    protected void initializeDefaultJoinColumn(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(resourcePersistentAttribute));
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.updateSpecifiedJoinColumns(resourcePersistentAttribute);
        this.updateDefaultJoinColumn(resourcePersistentAttribute);
    }

    @Override
    protected void update(T relationshipMapping) {
        super.update(relationshipMapping);
        this.setSpecifiedOptional_(this.specifiedOptional(relationshipMapping));
    }

    protected abstract Boolean specifiedOptional(T var1);

    protected void updateSpecifiedJoinColumns(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator resourceJoinColumns = resourcePersistentAttribute.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((JoinColumnAnnotation)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize(), this.buildJoinColumn((JoinColumnAnnotation)resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumn(resourcePersistentAttribute)));
        } else {
            this.defaultJoinColumn.update(new NullJoinColumn(resourcePersistentAttribute));
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initializeFromResource(joinColumnResource);
        return joinColumn;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        if (resourcePersistentAttribute.typeIsContainer()) {
            return null;
        }
        return resourcePersistentAttribute.getQualifiedReferenceEntityTypeName();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        if (this.addJoinColumnMessages()) {
            this.addJoinColumnMessages(messages, astRoot);
        }
    }

    protected boolean addJoinColumnMessages() {
        return this.entityOwned() && this.isRelationshipOwner();
    }

    protected void addJoinColumnMessages(List<IMessage> messages, CompilationUnit astRoot) {
        ListIterator<JavaJoinColumn> stream = this.joinColumns();
        while (stream.hasNext()) {
            JavaJoinColumn joinColumn = (JavaJoinColumn)stream.next();
            String table = joinColumn.getTable();
            boolean doContinue = joinColumn.connectionProfileIsActive();
            if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{table, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange(astRoot)));
                doContinue = false;
            }
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
        }
    }

    public class JoinColumnOwner
    implements JavaJoinColumn.Owner {
        public String getDefaultTableName() {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping().getTableName();
        }

        public Entity getTargetEntity() {
            return AbstractJavaSingleRelationshipMapping.this.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return ((GenericJavaPersistentAttribute)AbstractJavaSingleRelationshipMapping.this.getPersistentAttribute()).getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return AbstractJavaSingleRelationshipMapping.this;
        }

        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaSingleRelationshipMapping.this.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractJavaSingleRelationshipMapping.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaSingleRelationshipMapping.this.getValidationTextRange(astRoot);
        }

        public int joinColumnsSize() {
            return AbstractJavaSingleRelationshipMapping.this.joinColumnsSize();
        }
    }
}

