/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.binding;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.StringToIProjectTransformer;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateServerCommand;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.command.data.EclipseIPath2URLStringTransformer;
import org.eclipse.jst.ws.internal.consumption.ui.common.FinishFragment;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.ClientWizardWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.ClientWizardWidgetOutputCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.extensions.ClientExtensionDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.extensions.ClientExtensionFragment;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.extensions.ClientExtensionOutputCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.ClientTestDelegateCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.ClientTestFragment;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.ClientTestWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.FinishDefaultCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.FinishTestFragment;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.TestDefaultingFragment;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.TestWebServiceClient;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.WebServiceClientTestArrivalCommand;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.data.Transformer;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactory;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.env.core.fragment.SimpleFragment;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.SelectionCommand;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributorFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceState;

public class GenSampleWidgetBinding
implements CommandWidgetBinding {
    public CommandFragmentFactory create() {
        return new CommandFragmentFactory(){

            public CommandFragment create() {
                return new GenSampleRootCommandFragment();
            }
        };
    }

    public SelectionList getLegitTestFacility() {
        ScenarioContext scenarioContext = WebServicePlugin.getInstance().getScenarioContext().copy();
        String[] testTypes = scenarioContext.getWebServiceTestTypes();
        ArrayList<String> newTestTypes = new ArrayList<String>();
        int i = 0;
        while (i < testTypes.length) {
            boolean defaultJaxrpc;
            WebServiceTestExtension extension = (WebServiceTestExtension)WebServiceTestRegistry.getInstance().getWebServiceExtensionsByName(testTypes[i]);
            if (extension.testJavaProxy() && (defaultJaxrpc = extension.isDefaultJAXRPC())) {
                newTestTypes.add(testTypes[i]);
            }
            ++i;
        }
        String[] tempArray = new String[newTestTypes.size()];
        return new SelectionList(newTestTypes.toArray(tempArray), 0);
    }

    public void registerCanFinish(CanFinishRegistry canFinishRegistry) {
    }

    public void registerDataMappings(DataMappingRegistry dataRegistry) {
        dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "TestService", FinishTestFragment.class);
        dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "TestService", ClientTestWidget.class);
        dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "RunTestClient", ClientTestWidget.class);
        dataRegistry.addMapping(InitializeProxyCommand.class, "CanRunTestClient", ClientTestWidget.class);
        dataRegistry.addMapping(SelectionCommand.class, "InitialSelection", ClientTestWidget.class);
        dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "SampleProject", ClientTestWidget.class);
        dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "SampleProjectEAR", ClientTestWidget.class);
        dataRegistry.addMapping(InitializeProxyCommand.class, "TestFacility", ClientTestWidget.class);
        dataRegistry.addMapping(InitializeProxyCommand.class, "Popup", ClientTestWidget.class);
        dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "Folder", ClientTestWidget.class);
        dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "JspFolder", ClientTestWidget.class);
        dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "Methods", ClientTestWidget.class);
        dataRegistry.addMapping(ClientTestWidget.class, "SampleProjectEAR", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "SampleProject", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "TestFacility", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "Folder", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "JspFolder", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "RunTestClient", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "Methods", ClientTestDelegateCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "TestService", FinishTestFragment.class);
        dataRegistry.addMapping(ClientTestWidget.class, "TestID", FinishTestFragment.class);
        dataRegistry.addMapping(ClientTestWidget.class, "IsTestWidget", FinishTestFragment.class);
        dataRegistry.addMapping(ClientTestWidget.class, "ServerInstanceId", FinishDefaultCommand.class);
        dataRegistry.addMapping(ClientTestWidget.class, "ExistingServerId", FinishDefaultCommand.class);
    }

    public void registerWidgetMappings(WidgetRegistry widgetRegistry) {
        widgetRegistry.add("ClientTestWidget", ConsumptionUIMessages.PAGE_TITLE_WS_SAMPLE, ConsumptionUIMessages.PAGE_DESC_WS_SAMPLE, new WidgetContributorFactory(){

            public WidgetContributor create() {
                return new ClientTestWidget();
            }
        });
    }

    private class ForceTrue
    implements Transformer {
        private ForceTrue() {
        }

        public Object transform(Object value) {
            return new Boolean(true);
        }
    }

    private class GenSampleRootCommandFragment
    extends SequenceFragment {
        public GenSampleRootCommandFragment() {
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientWizardWidgetDefaultingCommand(true), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientWizardWidgetOutputCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new WSDLSelectionWidgetDefaultingCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientRuntimeSelectionWidgetDefaultingCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientExtensionDefaultingCommand(true), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new InitializeProxyCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientExtensionOutputCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new TestDefaultingFragment(), ""));
            this.add((CommandFragment)new ClientTestFragment("ClientTestWidget"));
            this.add((CommandFragment)new FinishFragment());
        }

        public void registerDataMappings(DataMappingRegistry dataRegistry) {
            dataRegistry.addMapping(SelectionCommand.class, "InitialSelection", ClientRuntimeSelectionWidgetDefaultingCommand.class, "ClientInitialSelection", null);
            dataRegistry.addMapping(SelectionCommand.class, "InitialSelection", InitializeProxyCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetDefaultingCommand.class, "ClientTypeRuntimeServer", ClientWizardWidgetOutputCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetDefaultingCommand.class, "TestService", ClientWizardWidgetOutputCommand.class, "TestService", (Transformer)new ForceTrue());
            dataRegistry.addMapping(ClientWizardWidgetDefaultingCommand.class, "ResourceContext", ClientWizardWidgetOutputCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetDefaultingCommand.class, "RunTestClient", ClientWizardWidgetOutputCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetOutputCommand.class, "ClientTypeRuntimeServer", ClientRuntimeSelectionWidgetDefaultingCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetOutputCommand.class, "TestService", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetOutputCommand.class, "RunTestClient", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientWizardWidgetOutputCommand.class, "ResourceContext", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientRuntimeSelectionWidgetDefaultingCommand.class, "ClientTypeRuntimeServer", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientRuntimeSelectionWidgetDefaultingCommand.class, "ClientProjectName", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientRuntimeSelectionWidgetDefaultingCommand.class, "ClientEarProjectName", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientRuntimeSelectionWidgetDefaultingCommand.class, "ClientComponentType", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(SelectionCommand.class, "InitialSelection", WSDLSelectionWidgetDefaultingCommand.class);
            dataRegistry.addMapping(WSDLSelectionWidgetDefaultingCommand.class, "GenWSIL", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(WSDLSelectionWidgetDefaultingCommand.class, "WsilURI", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(WSDLSelectionWidgetDefaultingCommand.class, "WebServiceURI", ClientExtensionDefaultingCommand.class, "WsdlURI", (Transformer)new EclipseIPath2URLStringTransformer());
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientTypeRuntimeServer", ClientExtensionFragment.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProject", WebServiceClientTestArrivalCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProjectEAR", WebServiceClientTestArrivalCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "GenerateProxy", ClientTestFragment.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "TestService", ClientTestFragment.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientNeedEAR", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientEarProjectName", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientEarProjectName", ClientTestDelegateCommand.class, "ClientEarComponentName", null);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProject", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientTypeRuntimeServer", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ServiceServerInstanceId", FinishDefaultCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientServer", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "WsdlURI", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "RunTestClient", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientTypeRuntimeServer", InitializeProxyCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientJ2EEVersion", InitializeProxyCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProject", InitializeProxyCommand.class, "Module", null);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProjectType", InitializeProxyCommand.class, "ModuleType", null);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProjectEAR", InitializeProxyCommand.class, "Ear", null);
            dataRegistry.addMapping(ClientWizardWidgetOutputCommand.class, "ResourceContext", InitializeProxyCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "WsdlURI", InitializeProxyCommand.class);
            dataRegistry.addMapping(InitializeProxyCommand.class, "WebServiceClient", ClientExtensionOutputCommand.class);
            dataRegistry.addMapping(InitializeProxyCommand.class, "GenerateProxy", ClientExtensionDefaultingCommand.class);
            dataRegistry.addMapping(ClientExtensionOutputCommand.class, "ProxyBean", WebServiceClientTestArrivalCommand.class);
            dataRegistry.addMapping(ClientExtensionOutputCommand.class, "ProxyBean", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "GenerateProxy", TestDefaultingFragment.class);
            dataRegistry.addMapping(InitializeProxyCommand.class, "CanGenerateProxy", ClientTestFragment.class);
            dataRegistry.addMapping(InitializeProxyCommand.class, "CanRunTestClient", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "GenerateProxy", FinishTestFragment.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "GenerateProxy", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionOutputCommand.class, "RunTestClient", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(ClientExtensionOutputCommand.class, "ServerInstanceId", FinishDefaultCommand.class);
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientProjectEAR", ClientExtensionOutputCommand.class, "EARProjectName", (Transformer)new StringToIProjectTransformer());
            dataRegistry.addMapping(ClientExtensionDefaultingCommand.class, "ClientServerInstance", ClientExtensionOutputCommand.class, "ExistingServerId", null);
            dataRegistry.addMapping(TestDefaultingFragment.class, "TestFacility", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "TestFacility", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "Folder", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "JspFolder", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "Methods", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "SampleProject", ClientTestDelegateCommand.class);
            dataRegistry.addMapping(WebServiceClientTestArrivalCommand.class, "SampleProjectEAR", ClientTestDelegateCommand.class);
        }
    }

    private class InitializeProxyCommand
    extends AbstractDataModelOperation {
        private IStructuredSelection selection_;
        private TypeRuntimeServer typeRuntimeServer_;
        private String project_;
        private String module_;
        private String ear_;
        private IWebServiceClient webServiceClient_;
        private String wsdlURI_;
        private boolean canRunTestClient_;

        private InitializeProxyCommand() {
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
            boolean j2eeProject;
            int earIndex;
            IEnvironment env = this.getEnvironment();
            IStatus status = Status.OK_STATUS;
            int index = this.module_.indexOf("/");
            if (index != -1) {
                this.project_ = this.module_.substring(0, index);
                this.module_ = this.module_.substring(index + 1);
            }
            if (this.ear_ != null && this.ear_.length() > 0 && (earIndex = this.ear_.indexOf("/")) != -1) {
                this.ear_ = this.ear_.substring(earIndex + 1);
            }
            WebServiceClientInfo clientInfo = new WebServiceClientInfo();
            clientInfo.setImplURL(this.getProxyBean());
            clientInfo.setServerFactoryId(this.typeRuntimeServer_.getServerId());
            clientInfo.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
            clientInfo.setState(WebServiceState.UNKNOWN_LITERAL);
            clientInfo.setWebServiceRuntimeId(this.typeRuntimeServer_.getRuntimeId());
            clientInfo.setWsdlURL(this.wsdlURI_);
            if (clientInfo.getServerInstanceId() == null) {
                CreateServerCommand createServerCommand = new CreateServerCommand();
                createServerCommand.setServerFactoryid(clientInfo.getServerFactoryId());
                createServerCommand.setEnvironment(env);
                IStatus createServerStatus = createServerCommand.execute(null, null);
                if (createServerStatus.getSeverity() == 0) {
                    clientInfo.setServerInstanceId(createServerCommand.getServerInstanceId());
                    clientInfo.setServerCreated(true);
                    this.canRunTestClient_ = true;
                } else if (createServerStatus.getSeverity() == 4) {
                    this.canRunTestClient_ = false;
                }
            } else {
                this.canRunTestClient_ = true;
            }
            IProject project = ProjectUtilities.getProject((String)this.project_);
            IProject[] earproject = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
            boolean earNull = false;
            if (earproject.length < 1) {
                earNull = true;
            }
            if ((j2eeProject = J2EEProjectUtilities.isJEEProject((IProject)project)) && earNull) {
                this.canRunTestClient_ = false;
            }
            if (!earNull && clientInfo.getServerInstanceId() != null) {
                AddModuleToServerCommand command = new AddModuleToServerCommand();
                command.setServerInstanceId(clientInfo.getServerInstanceId());
                command.setProject(this.project_);
                command.setModule(this.module_);
                command.setEnvironment(env);
                status = command.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                }
            }
            this.webServiceClient_ = new TestWebServiceClient(clientInfo);
            return status;
        }

        public boolean getPopup() {
            return true;
        }

        public String getProxyBean() {
            String proxyBean = "";
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)this.selection_.getFirstElement());
                String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)resource.getFullPath());
                beanPackage = beanPackage == null ? "" : String.valueOf(beanPackage) + ".";
                proxyBean = String.valueOf(beanPackage) + resource.getName();
                if (proxyBean.toLowerCase().endsWith(".java") || proxyBean.toLowerCase().endsWith(".class")) {
                    proxyBean = proxyBean.substring(0, proxyBean.lastIndexOf(46));
                }
            }
            catch (CoreException coreException) {}
            return proxyBean;
        }

        public IWebServiceClient getWebServiceClient() {
            return this.webServiceClient_;
        }

        public boolean getCanRunTestClient() {
            return this.canRunTestClient_;
        }

        public boolean getGenerateProxy() {
            return true;
        }

        public boolean getCanGenerateProxy() {
            return true;
        }

        public SelectionList getTestFacility() {
            return GenSampleWidgetBinding.this.getLegitTestFacility();
        }

        public void setClientTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
            this.typeRuntimeServer_ = typeRuntimeServer;
        }

        public void setModule(String module) {
            this.module_ = module;
        }

        public void setModuleType(String moduleType) {
        }

        public void setResourceContext(ResourceContext resourceContext) {
        }

        public void setInitialSelection(IStructuredSelection selection) {
            this.selection_ = selection;
        }
    }
}

