/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTModifiedDeclaration
implements ModifiedDeclaration {
    private final Adapter adapter;

    public JDTModifiedDeclaration(Adapter adapter) {
        this.adapter = adapter;
    }

    public JDTModifiedDeclaration(BodyDeclaration declaration) {
        this(new BodyDeclarationAdapter(declaration));
    }

    public JDTModifiedDeclaration(SingleVariableDeclaration declaration) {
        this(new SingleVariableDeclarationAdapter(declaration));
    }

    public JDTModifiedDeclaration(VariableDeclarationExpression declaration) {
        this(new VariableDeclarationExpressionAdapter(declaration));
    }

    public JDTModifiedDeclaration(VariableDeclarationStatement declaration) {
        this(new VariableDeclarationStatementAdapter(declaration));
    }

    @Override
    public ASTNode getDeclaration() {
        return this.adapter.declaration();
    }

    public List<IExtendedModifier> modifiers() {
        return this.adapter.modifiers();
    }

    @Override
    public AST getAst() {
        return this.getDeclaration().getAST();
    }

    public CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this.getDeclaration().getRoot();
    }

    public ICompilationUnit getICompilationUnit() {
        return (ICompilationUnit)this.getCompilationUnit().getJavaElement();
    }

    public Iterator<Annotation> annotations() {
        return new FilteringIterator<IExtendedModifier, Annotation>(this.modifiers().iterator()){

            protected boolean accept(IExtendedModifier next) {
                return next.isAnnotation();
            }
        };
    }

    @Override
    public Annotation getAnnotationNamed(String annotationName) {
        Iterator<Annotation> stream = this.annotations();
        while (stream.hasNext()) {
            Annotation annotation = stream.next();
            if (!this.annotationIsNamed(annotation, annotationName)) continue;
            return annotation;
        }
        return null;
    }

    public boolean containsAnnotationNamed(String annotationName) {
        return this.getAnnotationNamed(annotationName) != null;
    }

    public void addAnnotation(Annotation annotation) {
        List<IExtendedModifier> modifiers = this.modifiers();
        ListIterator<IExtendedModifier> stream = modifiers.listIterator();
        while (stream.hasNext()) {
            if (!stream.next().isModifier()) continue;
            stream.previous();
            stream.add((IExtendedModifier)annotation);
            return;
        }
        modifiers.add((IExtendedModifier)annotation);
    }

    @Override
    public void removeAnnotationNamed(String annotationName) {
        Iterator<IExtendedModifier> stream = this.modifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = stream.next();
            if (!modifier.isAnnotation() || !this.annotationIsNamed((Annotation)modifier, annotationName)) continue;
            stream.remove();
            break;
        }
    }

    public void removeAnnotation(Annotation annotation) {
        if (!this.modifiers().remove(annotation)) {
            throw new IllegalArgumentException("invalid annotation: " + annotation);
        }
    }

    public void replaceAnnotation(Annotation oldAnnotation, Annotation newAnnotation) {
        ListIterator<IExtendedModifier> stream = this.modifiers().listIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(oldAnnotation)) continue;
            stream.set((IExtendedModifier)newAnnotation);
            return;
        }
        throw new IllegalArgumentException("invalid old annotation: " + oldAnnotation);
    }

    @Override
    public void replaceAnnotationNamed(String oldAnnotationName, Annotation newAnnotation) {
        List<IExtendedModifier> modifiers = this.modifiers();
        ListIterator<IExtendedModifier> stream = modifiers.listIterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = stream.next();
            if (!modifier.isAnnotation() || !this.annotationIsNamed((Annotation)modifier, oldAnnotationName)) continue;
            stream.set((IExtendedModifier)newAnnotation);
            return;
        }
        this.addAnnotation(newAnnotation);
    }

    @Override
    public void addImport(String importName) {
        this.addImport(importName, false);
    }

    @Override
    public void addStaticImport(String importName) {
        this.addImport(importName, true);
    }

    @Override
    public void addImport(String importName, boolean static_) {
        if (importName.indexOf(46) != -1) {
            this.addImportTo(this.getCompilationUnit(), importName, static_);
        }
    }

    public String getImportFor(String shortName) {
        return this.getImportFor(shortName, false);
    }

    public String getStaticImportFor(String shortName) {
        return this.getImportFor(shortName, true);
    }

    public String getImportFor(String shortName, boolean static_) {
        if (shortName.indexOf(46) != -1) {
            return shortName;
        }
        List<ImportDeclaration> imports = this.imports(this.getCompilationUnit());
        for (ImportDeclaration importDeclaration : imports) {
            if (!this.importIsFor(importDeclaration, shortName, static_)) continue;
            return importDeclaration.getName().getFullyQualifiedName();
        }
        return null;
    }

    protected boolean importIsFor(ImportDeclaration importDeclaration, String shortName, boolean static_) {
        if (importDeclaration.isStatic() != static_) {
            return false;
        }
        String importDeclarationName = importDeclaration.getName().getFullyQualifiedName();
        return importDeclarationName.endsWith(shortName);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.adapter.toString());
    }

    @Override
    public boolean annotationIsNamed(Annotation annotation, String name) {
        String qualifiedName = this.qualifiedName(annotation);
        return qualifiedName != null && qualifiedName.equals(name);
    }

    private String qualifiedName(Annotation annotation) {
        String resolvedName;
        ITypeBinding typeBinding = annotation.resolveTypeBinding();
        if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
            return resolvedName;
        }
        return this.getImportFor(annotation.getTypeName().getFullyQualifiedName());
    }

    protected void addImportTo(CompilationUnit astRoot, String importName, boolean static_) {
        List<ImportDeclaration> imports = this.imports(astRoot);
        if (this.importsInclude(imports, importName, static_)) {
            return;
        }
        AST ast = astRoot.getAST();
        ImportDeclaration import_ = ast.newImportDeclaration();
        import_.setName(ast.newName(importName));
        import_.setStatic(static_);
        imports.add(import_);
    }

    protected List<ImportDeclaration> imports(CompilationUnit astRoot) {
        return astRoot.imports();
    }

    protected boolean importsInclude(List<ImportDeclaration> imports, String importName, boolean static_) {
        for (ImportDeclaration importDeclaration : imports) {
            if (!this.importIncludes(importDeclaration, importName, static_)) continue;
            return true;
        }
        return false;
    }

    protected boolean importIncludes(ImportDeclaration importDeclaration, String importName, boolean static_) {
        if (importDeclaration.isStatic() != static_) {
            return false;
        }
        String importDeclarationName = importDeclaration.getName().getFullyQualifiedName();
        if (importName.equals(importDeclarationName)) {
            return true;
        }
        return importDeclaration.isOnDemand() && this.onDemandNameFor(importName).equals(importDeclarationName);
    }

    protected String onDemandNameFor(String importName) {
        int lastPeriod = importName.lastIndexOf(46);
        return lastPeriod == -1 ? "" : importName.substring(0, lastPeriod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter {
        public ASTNode declaration();

        public List<IExtendedModifier> modifiers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BodyDeclarationAdapter
    implements Adapter {
        private final BodyDeclaration declaration;

        public BodyDeclarationAdapter(BodyDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode declaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> modifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.declaration.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleVariableDeclarationAdapter
    implements Adapter {
        private final SingleVariableDeclaration declaration;

        public SingleVariableDeclarationAdapter(SingleVariableDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode declaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> modifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.declaration.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableDeclarationExpressionAdapter
    implements Adapter {
        private final VariableDeclarationExpression declaration;

        public VariableDeclarationExpressionAdapter(VariableDeclarationExpression declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode declaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> modifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.declaration.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableDeclarationStatementAdapter
    implements Adapter {
        private final VariableDeclarationStatement declaration;

        public VariableDeclarationStatementAdapter(VariableDeclarationStatement declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode declaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> modifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.declaration.toString());
        }
    }
}

