/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.service.internal.policy;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.ws.service.internal.policy.DescriptorImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyImpl;
import org.eclipse.wst.ws.service.internal.policy.ServicePolicyPlatformImpl;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyEnumerationList;
import org.eclipse.wst.ws.service.policy.IPolicyRelationship;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.PolicyEnumerationListImpl;
import org.eclipse.wst.ws.service.policy.PolicyRelationshipImpl;
import org.eclipse.wst.ws.service.policy.ServicePolicyActivator;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalUtils {
    private static final String BASE_KEY = "org.eclipse.wst.";
    private static final String LOCAL_IDS_KEY = "localIds";
    private static final String PARENT_KEY = "parentId";
    private static final String MUTABLE_KEY = "mutable";
    private static final String DESCR_KEY = "description";
    private static final String LONGNAME_KEY = "longname";
    private static final String SHORTNAME_KEY = "shortname";
    private static final String ICONPATH_KEY = "iconpath";
    private static final String ICONBUND_KEY = "iconbundleid";
    private static final String HELPID_KEY = "contexthelpid";
    private static final String ENUMLIST_KEY = "enumlistid";
    private static final String DEFENUM_KEY = "defaultenumid";
    private static final String REL_KEY = "rel";
    private static final String TARGET_SUFFIX = ".target";
    private static final String SOURCE_SUFFIX = ".source";

    public static List<String> getLocalPolicyIds() {
        String key;
        List<String> result = new Vector<String>();
        IEclipsePreferences preferences = LocalUtils.getPreferences();
        String idsValue = preferences.get(key = "org.eclipse.wst.localIds", "");
        if (!idsValue.equals("")) {
            result = LocalUtils.createStringList(idsValue);
        }
        return result;
    }

    public static void saveLocalIds(List<String> localIds) {
        IEclipsePreferences preferences = LocalUtils.getPreferences();
        String key = "org.eclipse.wst.localIds";
        if (localIds.size() > 0) {
            preferences.put(key, LocalUtils.createSpaceDelimitedString(localIds));
        }
    }

    public static void removeAllPreferencePolicies(String startsWith, IEclipsePreferences prefs) {
        if (startsWith == null) {
            startsWith = BASE_KEY;
        }
        try {
            String[] keys;
            IEclipsePreferences preferences = prefs == null ? LocalUtils.getPreferences() : prefs;
            String[] stringArray = keys = preferences.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.startsWith(startsWith)) {
                    preferences.remove(key);
                }
                ++n2;
            }
        }
        catch (BackingStoreException exc) {
            ServicePolicyActivator.logError("Error loading service policy local preferences.", exc);
        }
    }

    public static void saveLocalPolicy(ServicePolicyImpl policy) {
        IEclipsePreferences preferences = LocalUtils.getPreferences();
        String policyId = policy.getId();
        IDescriptor descriptor = policy.getDescriptor();
        IServicePolicy parent = policy.getParentPolicy();
        LocalUtils.save(preferences, policyId, PARENT_KEY, parent == null ? null : parent.getId());
        LocalUtils.save(preferences, policyId, MUTABLE_KEY, "" + policy.getPolicyState().isMutable());
        LocalUtils.save(preferences, policyId, ENUMLIST_KEY, policy.getEnumListId());
        LocalUtils.save(preferences, policyId, DEFENUM_KEY, policy.getDefaultEnumId());
        LocalUtils.save(preferences, policyId, DESCR_KEY, descriptor.getDescription());
        LocalUtils.save(preferences, policyId, SHORTNAME_KEY, descriptor.getShortName());
        LocalUtils.save(preferences, policyId, LONGNAME_KEY, descriptor.getLongName());
        LocalUtils.save(preferences, policyId, ICONPATH_KEY, descriptor.getIconPath());
        LocalUtils.save(preferences, policyId, ICONBUND_KEY, descriptor.getIconBundleId());
        LocalUtils.save(preferences, policyId, HELPID_KEY, descriptor.getContextHelpId());
        LocalUtils.saveRelationships(preferences, policyId, policy.getRelationships());
    }

    public static void loadLocalPolicy(String policyId, ServicePolicyPlatformImpl platform) {
        IEclipsePreferences preferences = LocalUtils.getPreferences();
        ServicePolicyImpl policy = platform.getServicePolicy(policyId);
        DescriptorImpl descriptor = (DescriptorImpl)policy.getDescriptor();
        String parentId = preferences.get(LocalUtils.createKey(policyId, PARENT_KEY), null);
        if (parentId != null) {
            ServicePolicyImpl parentPolicy = platform.getServicePolicy(parentId);
            policy.setParent(parentPolicy);
        }
        policy.getPolicyState().setMutable(preferences.getBoolean(LocalUtils.createKey(policyId, MUTABLE_KEY), true));
        policy.setEnumListId(preferences.get(LocalUtils.createKey(policyId, ENUMLIST_KEY), null));
        policy.setDefaultEnumId(preferences.get(LocalUtils.createKey(policyId, DEFENUM_KEY), null));
        descriptor.setDescription(preferences.get(LocalUtils.createKey(policyId, DESCR_KEY), null));
        descriptor.setShortName(preferences.get(LocalUtils.createKey(policyId, SHORTNAME_KEY), null));
        descriptor.setLongName(preferences.get(LocalUtils.createKey(policyId, LONGNAME_KEY), null));
        descriptor.setIconPath(preferences.get(LocalUtils.createKey(policyId, ICONPATH_KEY), null));
        descriptor.setIconBundleId(preferences.get(LocalUtils.createKey(policyId, ICONBUND_KEY), null));
        descriptor.setContextHelpId(preferences.get(LocalUtils.createKey(policyId, HELPID_KEY), null));
        policy.setRelationships(LocalUtils.loadRelationships(preferences, policyId, platform));
    }

    private static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode("org.eclipse.wst.ws.service.policy");
    }

    private static List<String> createStringList(String spaceDelimitedString) {
        String[] splitValues = spaceDelimitedString.split(" ");
        return Arrays.asList(splitValues);
    }

    private static String createSpaceDelimitedString(List<String> stringList) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (index < stringList.size()) {
            String id = stringList.get(index);
            buffer.append(id);
            if (index < stringList.size() - 1) {
                buffer.append(' ');
            }
            ++index;
        }
        return buffer.toString();
    }

    private static void saveRelationships(IEclipsePreferences preferences, String policyId, List<IPolicyRelationship> relationships) {
        int index = 0;
        while (index < relationships.size()) {
            IPolicyRelationship relationship = relationships.get(index);
            IPolicyEnumerationList policyList = relationship.getPolicyEnumerationList();
            List<IPolicyEnumerationList> targetPolicies = relationship.getRelatedPolicies();
            LocalUtils.savePolicyRelationship(index + 1, preferences, policyId, policyList, SOURCE_SUFFIX);
            int targetIndex = 0;
            while (targetIndex < targetPolicies.size()) {
                IPolicyEnumerationList targetPolicy = targetPolicies.get(targetIndex);
                String targetSuffix = TARGET_SUFFIX + (targetIndex + 1);
                LocalUtils.savePolicyRelationship(index + 1, preferences, policyId, targetPolicy, targetSuffix);
                ++targetIndex;
            }
            ++index;
        }
    }

    private static List<IPolicyRelationship> loadRelationships(IEclipsePreferences preferences, String policyId, ServicePolicyPlatformImpl platform) {
        Vector<IPolicyRelationship> relationships = new Vector<IPolicyRelationship>();
        int relCount = 1;
        IPolicyEnumerationList sourceList = LocalUtils.loadPolicyRelationship(relCount, preferences, platform, policyId, SOURCE_SUFFIX);
        while (sourceList != null) {
            int targetCount = 1;
            String targetSuffix = TARGET_SUFFIX + targetCount;
            IPolicyEnumerationList targetList = LocalUtils.loadPolicyRelationship(relCount, preferences, platform, policyId, targetSuffix);
            Vector<IPolicyEnumerationList> targets = new Vector<IPolicyEnumerationList>();
            while (targetList != null) {
                targets.add(targetList);
                targetSuffix = TARGET_SUFFIX + ++targetCount;
                targetList = LocalUtils.loadPolicyRelationship(relCount, preferences, platform, policyId, targetSuffix);
            }
            relationships.add(new PolicyRelationshipImpl(sourceList, targets));
            sourceList = LocalUtils.loadPolicyRelationship(++relCount, preferences, platform, policyId, SOURCE_SUFFIX);
        }
        return relationships;
    }

    private static void savePolicyRelationship(int relCount, IEclipsePreferences preferences, String policyId, IPolicyEnumerationList enumList, String keySuffix) {
        String key = LocalUtils.createKey(policyId, REL_KEY + relCount + keySuffix);
        String value = LocalUtils.createRelationshipValue(enumList);
        preferences.put(key, value);
    }

    private static IPolicyEnumerationList loadPolicyRelationship(int relCount, IEclipsePreferences preferences, ServicePolicyPlatformImpl platform, String policyId, String keySuffix) {
        String key = LocalUtils.createKey(policyId, REL_KEY + relCount + keySuffix);
        String value = preferences.get(key, "");
        PolicyEnumerationListImpl enumList = null;
        if (!value.equals("")) {
            String[] splitValue = value.split(" ");
            String targetPolicyId = splitValue[0];
            ServicePolicyImpl targetPolicy = platform.getServicePolicy(targetPolicyId);
            Vector<IStateEnumerationItem> items = new Vector<IStateEnumerationItem>();
            int index = 1;
            while (index < splitValue.length) {
                IStateEnumerationItem item = platform.getStateItemEnumeration(splitValue[index]);
                items.add(item);
                ++index;
            }
            enumList = new PolicyEnumerationListImpl(items, targetPolicy);
        }
        return enumList;
    }

    private static String createRelationshipValue(IPolicyEnumerationList enumList) {
        Vector<String> stringList = new Vector<String>();
        List<IStateEnumerationItem> itemList = enumList.getEnumerationList();
        stringList.add(enumList.getPolicy().getId());
        for (IStateEnumerationItem item : itemList) {
            stringList.add(item.getId());
        }
        return LocalUtils.createSpaceDelimitedString(stringList);
    }

    private static void save(IEclipsePreferences preferences, String policyId, String key, String value) {
        if (value != null && !value.equals("")) {
            preferences.put(LocalUtils.createKey(policyId, key), value);
        }
    }

    private static String createKey(String id, String key) {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(BASE_KEY);
        buffer.append(id);
        buffer.append('.');
        buffer.append(key);
        return buffer.toString();
    }
}

