/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EnumType;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlBasicImpl;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmBasicMapping
extends AbstractOrmAttributeMapping<XmlBasic>
implements OrmBasicMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected EnumType specifiedEnumerated;
    protected TemporalType temporal;
    protected boolean lob;

    public GenericOrmBasicMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((XmlBasic)this.getAttributeMapping()).setFetch(FetchType.toOrmResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((XmlBasic)this.getAttributeMapping()).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public void setLob(boolean newLob) {
        boolean oldLob = this.lob;
        this.lob = newLob;
        ((XmlBasic)this.getAttributeMapping()).setLob(newLob);
        this.firePropertyChanged("lobProperty", oldLob, newLob);
    }

    protected void setLob_(boolean newLob) {
        boolean oldLob = this.lob;
        this.lob = newLob;
        this.firePropertyChanged("lobProperty", oldLob, newLob);
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        ((XmlBasic)this.getAttributeMapping()).setTemporal(TemporalType.toOrmResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    protected void setTemporal_(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public EnumType getEnumerated() {
        return this.getSpecifiedEnumerated() == null ? this.getDefaultEnumerated() : this.getSpecifiedEnumerated();
    }

    @Override
    public EnumType getDefaultEnumerated() {
        return BasicMapping.DEFAULT_ENUMERATED;
    }

    @Override
    public EnumType getSpecifiedEnumerated() {
        return this.specifiedEnumerated;
    }

    @Override
    public void setSpecifiedEnumerated(EnumType newSpecifiedEnumerated) {
        EnumType oldEnumerated = this.specifiedEnumerated;
        this.specifiedEnumerated = newSpecifiedEnumerated;
        ((XmlBasic)this.getAttributeMapping()).setEnumerated(EnumType.toOrmResourceModel(newSpecifiedEnumerated));
        this.firePropertyChanged("specifiedEnumeratedProperty", (Object)oldEnumerated, (Object)newSpecifiedEnumerated);
    }

    protected void setSpecifiedEnumerated_(EnumType newSpecifiedEnumerated) {
        EnumType oldEnumerated = this.specifiedEnumerated;
        this.specifiedEnumerated = newSpecifiedEnumerated;
        this.firePropertyChanged("specifiedEnumeratedProperty", (Object)oldEnumerated, (Object)newSpecifiedEnumerated);
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmBasicMapping(this);
    }

    @Override
    public void initializeFromXmlColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromXmlColumnMapping(oldMapping);
        this.setTemporal(oldMapping.getTemporal());
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public int getXmlSequence() {
        return 2;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public void initialize(XmlBasic basic) {
        super.initialize(basic);
        this.specifiedFetch = this.specifiedFetch(basic);
        this.specifiedOptional = this.specifiedOptional(basic);
        this.specifiedEnumerated = this.specifiedEnumerated(basic);
        this.temporal = this.specifiedTemporal(basic);
        this.lob = this.specifiedLob(basic);
        this.column.initialize(basic.getColumn());
    }

    @Override
    public void update(XmlBasic basic) {
        super.update(basic);
        this.setSpecifiedFetch_(this.specifiedFetch(basic));
        this.setSpecifiedOptional_(this.specifiedOptional(basic));
        this.setSpecifiedEnumerated_(this.specifiedEnumerated(basic));
        this.setTemporal_(this.specifiedTemporal(basic));
        this.setLob_(this.specifiedLob(basic));
        this.column.update(basic.getColumn());
    }

    protected Boolean specifiedOptional(XmlBasic basic) {
        return basic.getOptional();
    }

    protected FetchType specifiedFetch(XmlBasic basic) {
        return FetchType.fromOrmResourceModel(basic.getFetch());
    }

    protected EnumType specifiedEnumerated(XmlBasic basic) {
        return EnumType.fromOrmResourceModel(basic.getEnumerated());
    }

    protected TemporalType specifiedTemporal(XmlBasic basic) {
        return TemporalType.fromOrmResourceModel(basic.getTemporal());
    }

    protected boolean specifiedLob(XmlBasic basic) {
        return basic.isLob();
    }

    @Override
    public XmlBasic addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlBasicImpl basic = OrmFactory.eINSTANCE.createXmlBasicImpl();
        this.getPersistentAttribute().initialize(basic);
        typeMapping.getAttributes().getBasics().add((Object)basic);
        return basic;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getBasics().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public XmlColumn getColumnResource() {
        return ((XmlBasic)this.getAttributeMapping()).getColumn();
    }

    @Override
    public void addColumnResource() {
        ((XmlBasic)this.getAttributeMapping()).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeColumnResource() {
        ((XmlBasic)this.getAttributeMapping()).setColumn(null);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
    }

    protected void addColumnMessages(List<IMessage> messages) {
        OrmColumn column = this.getColumn();
        String table = column.getTable();
        boolean doContinue = this.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), table, column.getName()}, column, column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), column.getName()}, column, column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange()));
            }
        }
    }
}

