/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class BorderUtil {
    public static final int VERTICAL_BAR = 0;
    public static final int HORIZONTAL_BAR = 1;
    public static final int BOTH = 2;
    public static final int SCROLL_WIDTH = 16;
    public static final int BORDER_THICK = 2;

    public static void maskRectangle(Graphics g, Rectangle rect, Color color) {
        if (color == null) {
            color = ColorConstants.blue;
        }
        int lineStyle = g.getLineStyle();
        Color foregroundColor = g.getForegroundColor();
        g.setLineStyle(1);
        g.setForegroundColor(color);
        int i = 0;
        int n = rect.height;
        while (i < n) {
            int j = 0;
            int m = rect.width;
            while (j < m) {
                g.drawLine(rect.x + j, rect.y + i, rect.x + j, rect.y + i);
                ++j;
                ++j;
            }
            ++i;
            ++i;
        }
        g.setLineStyle(lineStyle);
        g.setForegroundColor(foregroundColor);
    }

    public static void drawBorder(Graphics g, Rectangle rect, int thick, boolean inset) {
        BorderUtil.drawBorder(g, rect.x, rect.y, rect.width, rect.height, thick, inset);
    }

    public static void drawBorder(Graphics g, int left, int top, int width, int height, int thick, boolean inset) {
        Color[] ltColors = new Color[]{Display.getCurrent().getSystemColor(19), Display.getCurrent().getSystemColor(20)};
        if (inset) {
            ltColors = new Color[]{ColorConstants.buttonDarker, ColorConstants.buttonDarkest};
        }
        int i = 0;
        while (i < thick) {
            g.setForegroundColor(ltColors[ltColors.length * i / thick]);
            g.drawLine(left + i, top + i, left + width - 1 - i, top + i);
            g.drawLine(left + i, top + i, left + i, top + height - i - i);
            ++i;
        }
        Color[] rbColors = new Color[]{Display.getCurrent().getSystemColor(17), Display.getCurrent().getSystemColor(16)};
        if (inset) {
            rbColors = new Color[]{ColorConstants.buttonLightest, ColorConstants.button};
        }
        int i2 = 0;
        while (i2 < thick) {
            g.setForegroundColor(rbColors[ltColors.length * i2 / thick]);
            g.drawLine(left + i2, top - i2 + height - 1, left + width - 1 - i2, top - i2 + height - 1);
            g.drawLine(left + width - 1 - i2, top + i2, left + width - 1 - i2, top + height - 1 - i2);
            ++i2;
        }
    }

    public static void drawScrollBar(Graphics g, int scrollWidth, Rectangle rect, int style) {
        BorderUtil.drawScrollBar(g, scrollWidth, 2, rect, style);
    }

    public static void drawScrollBar(Graphics g, int scrollWidth, int borderThick, Rectangle rect, int style) {
        if (style == 2) {
            int width = scrollWidth;
            int left = rect.x + rect.width - width;
            int top = rect.y;
            int height = rect.height;
            Rectangle barRect = new Rectangle(left, top, width, height);
            BorderUtil.fillBar(g, barRect);
            barRect = new Rectangle(left, top, width, height - scrollWidth);
            BorderUtil.drawVerticalPart(g, scrollWidth, borderThick, barRect);
            left = rect.x + borderThick;
            top = top + height - scrollWidth;
            width = rect.width;
            height = scrollWidth;
            barRect = new Rectangle(left, top, width, height);
            BorderUtil.fillBar(g, barRect);
            barRect = new Rectangle(left, top, width - scrollWidth - 2, height);
            BorderUtil.drawHorizontalPart(g, scrollWidth, borderThick, barRect);
        } else if (style == 0) {
            int width = scrollWidth;
            int left = rect.x + rect.width - width;
            int top = rect.y;
            int height = rect.height;
            Rectangle barRect = new Rectangle(left, top, width, height);
            BorderUtil.fillBar(g, barRect);
            BorderUtil.drawVerticalPart(g, scrollWidth, borderThick, barRect);
        } else if (style == 1) {
            int left = rect.x + borderThick;
            int top = rect.y + rect.height - scrollWidth;
            int width = rect.width;
            int height = scrollWidth;
            Rectangle barRect = new Rectangle(left, top, width, height);
            BorderUtil.fillBar(g, barRect);
            BorderUtil.drawHorizontalPart(g, scrollWidth, borderThick, barRect);
        }
    }

    private static void fillBar(Graphics g, Rectangle rect) {
        g.setBackgroundColor(ColorConstants.button);
        g.fillRectangle(rect);
    }

    private static void drawVerticalPart(Graphics g, int arrawLength, int borderThick, Rectangle rect) {
        int left = rect.x;
        int top = rect.y;
        int width = Math.min(arrawLength, rect.width);
        int height = Math.min(arrawLength, rect.height / 2);
        Rectangle borderRect = new Rectangle(left, top, width, height);
        BorderUtil.drawBorder(g, borderRect, borderThick, false);
        g.setForegroundColor(ColorConstants.black);
        int decoratorWidth = (width - borderThick * 2) / 2;
        int length = decoratorWidth / 2 + 1;
        int leftX = rect.x + (width - decoratorWidth) / 2 - 1;
        int bottomY = rect.y + (height + length) / 2 - 1;
        int i = 0;
        while (i < length) {
            g.drawLine(leftX + i, bottomY - i, leftX - i + decoratorWidth, bottomY - i);
            ++i;
        }
        top = rect.y + rect.height - height;
        borderRect = new Rectangle(left, top, width, height);
        BorderUtil.drawBorder(g, borderRect, borderThick, false);
        int topY = top + (height - length) / 2;
        g.setForegroundColor(ColorConstants.black);
        int i2 = 0;
        while (i2 < length) {
            g.drawLine(leftX + i2, topY + i2, leftX - i2 + decoratorWidth, topY + i2);
            ++i2;
        }
    }

    private static void drawHorizontalPart(Graphics g, int arrawLength, int borderThick, Rectangle rect) {
        int left = rect.x;
        int top = rect.y;
        int width = Math.min(arrawLength, rect.width / 2);
        int height = Math.min(arrawLength, rect.height);
        Rectangle borderRect = new Rectangle(left, top, width, height);
        BorderUtil.drawBorder(g, borderRect, borderThick, false);
        g.setForegroundColor(ColorConstants.black);
        int decoratorHeight = (height - borderThick * 2) / 2;
        int length = decoratorHeight / 2 + 1;
        int leftX = rect.x + (width + length) / 2 - 1;
        int bottomY = rect.y + (height - length) / 2 - 1;
        int i = 0;
        while (i < length) {
            g.drawLine(leftX - i, bottomY + i, leftX - i, bottomY - i + decoratorHeight);
            ++i;
        }
        left = rect.x + rect.width - width;
        borderRect = new Rectangle(left, top, width, height);
        BorderUtil.drawBorder(g, borderRect, borderThick, false);
        leftX = left + (width - length) / 2;
        g.setForegroundColor(ColorConstants.black);
        i = 0;
        while (i < length) {
            g.drawLine(leftX + i, bottomY + i, leftX + i, bottomY - i + decoratorHeight);
            ++i;
        }
    }

    public static void drawVertialBar(Graphics g, int arrawWidth, int arrawHeight, int borderThick, Rectangle rect) {
        BorderUtil.drawScrollBar(g, arrawWidth, borderThick, rect, 0);
    }

    public static void drawBorderDecorator(CSSFigure figure, Graphics graphics) {
        graphics.setLineWidth(1);
        graphics.setLineStyle(2);
        graphics.setForegroundColor(ColorConstants.lightGray);
        List fragments = figure.getFragmentsForRead();
        int i = 0;
        int size = fragments.size();
        while (i < size) {
            FlowBox box = (FlowBox)fragments.get(i);
            graphics.drawRectangle(box.getX(), box.getY(), box.getWidth() - 1, box.getHeight() - 1);
            ++i;
        }
        graphics.restoreState();
    }

    public static void maskFigure(CSSFigure figure, Graphics g) {
        List fragments = figure.getFragmentsForRead();
        int i = 0;
        int size = fragments.size();
        while (i < size) {
            FlowBox box = (FlowBox)fragments.get(i);
            BorderUtil.maskRectangle(g, new Rectangle(box.getX(), box.getY(), box.getWidth(), box.getHeight()), null);
            ++i;
        }
    }

    private BorderUtil() {
    }
}

