/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

class ConstructorReferenceFinder {
    private final IType fType;
    private final IFunction[] fConstructors;

    private ConstructorReferenceFinder(IType type) throws JavaScriptModelException {
        this.fConstructors = JavaElementUtil.getAllConstructors(type);
        this.fType = type;
    }

    private ConstructorReferenceFinder(IFunction constructor) {
        this.fConstructors = new IFunction[]{constructor};
        this.fType = constructor.getDeclaringType();
    }

    public static SearchResultGroup[] getConstructorReferences(IType type, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        return new ConstructorReferenceFinder(type).getConstructorReferences(pm, null, 2, status);
    }

    public static SearchResultGroup[] getConstructorReferences(IType type, WorkingCopyOwner owner, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        return new ConstructorReferenceFinder(type).getConstructorReferences(pm, owner, 2, status);
    }

    public static SearchResultGroup[] getConstructorOccurrences(IFunction constructor, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isTrue((boolean)constructor.isConstructor());
        return new ConstructorReferenceFinder(constructor).getConstructorReferences(pm, null, 3, status);
    }

    private SearchResultGroup[] getConstructorReferences(IProgressMonitor pm, WorkingCopyOwner owner, int limitTo, RefactoringStatus status) throws JavaScriptModelException {
        IJavaScriptSearchScope scope = this.createSearchScope();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])this.fConstructors, limitTo);
        if (pattern == null) {
            if (this.fConstructors.length != 0) {
                return new SearchResultGroup[0];
            }
            return this.getImplicitConstructorReferences(pm, owner, status);
        }
        return this.removeUnrealReferences(RefactoringSearchEngine.search(pattern, owner, scope, pm, status));
    }

    private SearchResultGroup[] removeUnrealReferences(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                JavaScriptUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)cu, false);
                SearchMatch[] allSearchResults = group.getSearchResults();
                ArrayList<SearchMatch> realConstructorReferences = new ArrayList<SearchMatch>(Arrays.asList(allSearchResults));
                int j = 0;
                while (j < allSearchResults.length) {
                    SearchMatch searchResult = allSearchResults[j];
                    if (!this.isRealConstructorReferenceNode(ASTNodeSearchUtil.getAstNode(searchResult, cuNode))) {
                        realConstructorReferences.remove(searchResult);
                    }
                    ++j;
                }
                if (!realConstructorReferences.isEmpty()) {
                    result.add(new SearchResultGroup(group.getResource(), realConstructorReferences.toArray(new SearchMatch[realConstructorReferences.size()])));
                }
            }
            ++i;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private boolean isRealConstructorReferenceNode(ASTNode node) {
        FunctionDeclaration md;
        String typeName = this.fConstructors[0].getDeclaringType().getElementName();
        if (node.getParent() instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)node.getParent()).getNameProperty().equals(node.getLocationInParent())) {
            return false;
        }
        return !(node.getParent() instanceof FunctionDeclaration) || !FunctionDeclaration.NAME_PROPERTY.equals(node.getLocationInParent()) || !(md = (FunctionDeclaration)node.getParent()).isConstructor() || md.getName().getIdentifier().equals(typeName);
    }

    private IJavaScriptSearchScope createSearchScope() throws JavaScriptModelException {
        if (this.fConstructors.length == 0) {
            return RefactoringScopeFactory.create((IJavaScriptElement)this.fType);
        }
        return RefactoringScopeFactory.create((IJavaScriptElement)this.getMostVisibleConstructor());
    }

    private IFunction getMostVisibleConstructor() throws JavaScriptModelException {
        Assert.isTrue((this.fConstructors.length > 0 ? 1 : 0) != 0);
        IFunction candidate = this.fConstructors[0];
        int visibility = JdtFlags.getVisibilityCode((IMember)this.fConstructors[0]);
        int i = 1;
        while (i < this.fConstructors.length) {
            IFunction constructor = this.fConstructors[i];
            if (JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)constructor), visibility)) {
                candidate = constructor;
            }
            ++i;
        }
        return candidate;
    }

    private SearchResultGroup[] getImplicitConstructorReferences(IProgressMonitor pm, WorkingCopyOwner owner, RefactoringStatus status) throws JavaScriptModelException {
        pm.beginTask("", 2);
        ArrayList searchMatches = new ArrayList();
        searchMatches.addAll(this.getImplicitConstructorReferencesFromHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        searchMatches.addAll(this.getImplicitConstructorReferencesInClassCreations(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1), status));
        pm.done();
        return RefactoringSearchEngine.groupByCu(searchMatches.toArray(new SearchMatch[searchMatches.size()]), status);
    }

    private List getImplicitConstructorReferencesInClassCreations(WorkingCopyOwner owner, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)this.fType, (int)2, (int)24);
        IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)this.fType);
        SearchResultGroup[] refs = RefactoringSearchEngine.search(pattern, owner, scope, pm, status);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>();
        int i = 0;
        while (i < refs.length) {
            SearchResultGroup group = refs[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                JavaScriptUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)cu, false);
                SearchMatch[] results = group.getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch searchResult = results[j];
                    ASTNode node = ASTNodeSearchUtil.getAstNode(searchResult, cuNode);
                    if (ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                        result.add(searchResult);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isImplicitConstructorReferenceNodeInClassCreations(ASTNode node) {
        if (node instanceof Type) {
            ASTNode grandParent;
            ASTNode parent = node.getParent();
            if (parent instanceof ClassInstanceCreation) {
                return node.equals((Object)((ClassInstanceCreation)parent).getType());
            }
            if (parent instanceof ParameterizedType && (grandParent = parent.getParent()) instanceof ClassInstanceCreation) {
                ParameterizedType type = (ParameterizedType)((ClassInstanceCreation)grandParent).getType();
                return node.equals((Object)type.getType());
            }
        }
        return false;
    }

    private List getImplicitConstructorReferencesFromHierarchy(WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        IType[] subTypes = ConstructorReferenceFinder.getNonBinarySubtypes(owner, this.fType, pm);
        ArrayList result = new ArrayList(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            result.addAll(ConstructorReferenceFinder.getAllSuperConstructorInvocations(subTypes[i]));
            ++i;
        }
        return result;
    }

    private static IType[] getNonBinarySubtypes(WorkingCopyOwner owner, IType type, IProgressMonitor monitor) throws JavaScriptModelException {
        ITypeHierarchy hierarchy = null;
        hierarchy = owner == null ? type.newTypeHierarchy(monitor) : type.newSupertypeHierarchy(owner, monitor);
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        ArrayList<IType> result = new ArrayList<IType>(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            if (!subTypes[i].isBinary()) {
                result.add(subTypes[i]);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static Collection getAllSuperConstructorInvocations(IType type) throws JavaScriptModelException {
        IFunction[] constructors = JavaElementUtil.getAllConstructors(type);
        JavaScriptUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)type.getJavaScriptUnit(), false);
        ArrayList<SearchMatch> result = new ArrayList<SearchMatch>(constructors.length);
        int i = 0;
        while (i < constructors.length) {
            SuperConstructorInvocation superCall = ConstructorReferenceFinder.getSuperConstructorCallNode(constructors[i], cuNode);
            if (superCall != null) {
                result.add(ConstructorReferenceFinder.createSearchResult((ASTNode)superCall, constructors[i]));
            }
            ++i;
        }
        return result;
    }

    private static SearchMatch createSearchResult(ASTNode superCall, IFunction constructor) {
        int start = superCall.getStartPosition();
        int end = ASTNodes.getInclusiveEnd(superCall);
        IResource resource = constructor.getResource();
        return new SearchMatch((IJavaScriptElement)constructor, 0, start, end - start, SearchEngine.getDefaultSearchParticipant(), resource);
    }

    private static SuperConstructorInvocation getSuperConstructorCallNode(IFunction constructor, JavaScriptUnit cuNode) throws JavaScriptModelException {
        Assert.isTrue((boolean)constructor.isConstructor());
        FunctionDeclaration constructorNode = ASTNodeSearchUtil.getMethodDeclarationNode(constructor, cuNode);
        Assert.isTrue((boolean)constructorNode.isConstructor());
        Block body = constructorNode.getBody();
        Assert.isNotNull((Object)body);
        List statements = body.statements();
        if (!statements.isEmpty() && statements.get(0) instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)statements.get(0);
        }
        return null;
    }
}

