/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.log.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.log.impl.MimePartsImpl;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;

public class MessageEntryImpl
implements MessageEntry {
    protected String id;
    protected String conversationId;
    protected String type;
    protected String timestamp;
    protected String senderHostAndPort;
    protected String receiverHostAndPort;
    protected String message = "";
    protected String httpHeaders = "";
    protected int bom;
    protected String encoding = "";
    protected boolean isMimeContent = false;
    protected MimeParts mimeParts = new MimePartsImpl();
    protected ElementLocation elementLocation = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSenderHostAndPort() {
        return this.senderHostAndPort;
    }

    public void setSenderHostAndPort(String senderHostAndPort) {
        this.senderHostAndPort = senderHostAndPort;
    }

    public String getReceiverHostAndPort() {
        return this.receiverHostAndPort;
    }

    public void setReceiverHostAndPort(String receiverHostAndPort) {
        this.receiverHostAndPort = receiverHostAndPort;
    }

    public String getMessage() {
        if (!this.isMimeContent) {
            return this.message;
        }
        if (this.mimeParts.getRootPart() == null) {
            return "";
        }
        return this.mimeParts.getRootPart().getContent();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getBOM() {
        return this.bom;
    }

    public void setBOM(int bom) {
        this.bom = bom;
    }

    public String getHTTPHeaders() {
        return this.httpHeaders;
    }

    public void setHTTPHeaders(String httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public ElementLocation getElementLocation() {
        return this.elementLocation;
    }

    public void setElementLocation(ElementLocation elementLocation) {
        this.elementLocation = elementLocation;
    }

    public String toString() {
        return this.toXMLString("wsi-log");
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.print("<" + nsName + "messageEntry" + " ");
        pw.print("xsi:type=\"httpMessageEntry\" ");
        pw.print("ID=\"" + this.id + "\" ");
        pw.print("conversationID=\"" + this.conversationId + "\" ");
        pw.print("type=\"" + this.type + "\" ");
        pw.println("timestamp=\"" + this.timestamp + "\">");
        if (this.isMimeContent()) {
            pw.print("<" + nsName + "messageContentWithAttachments");
            if (this.bom != 0) {
                pw.print(" BOM=\"" + this.bom + "\"");
            }
            pw.print(">");
            Collection partList = this.mimeParts.getParts();
            if (!partList.isEmpty()) {
                Iterator iMimeParts = partList.iterator();
                while (iMimeParts.hasNext()) {
                    MimePart mimePart = (MimePart)iMimeParts.next();
                    pw.print(mimePart.toXMLString(namespaceName));
                }
            }
            pw.println("</" + nsName + "messageContentWithAttachments" + ">");
        } else {
            pw.print("<" + nsName + "messageContent");
            if (this.bom != 0) {
                pw.print(" BOM=\"" + this.bom + "\"");
            }
            pw.print(">");
            pw.print(XMLUtils.xmlEscapedString(this.message));
            pw.println("</" + nsName + "messageContent" + ">");
        }
        pw.println("<" + nsName + "senderHostAndPort" + ">" + this.senderHostAndPort + "</" + nsName + "senderHostAndPort" + ">");
        pw.println("<" + nsName + "receiverHostAndPort" + ">" + this.receiverHostAndPort + "</" + nsName + "receiverHostAndPort" + ">");
        pw.print("<" + nsName + "httpHeaders" + ">");
        pw.print(XMLUtils.xmlEscapedString(this.httpHeaders));
        pw.println("</" + nsName + "httpHeaders" + ">");
        pw.println("</" + nsName + "messageEntry" + ">");
        return sw.toString();
    }

    public boolean isMimeContent() {
        return this.isMimeContent;
    }

    public void setMimeContent(boolean isMimeContent) {
        this.isMimeContent = isMimeContent;
    }

    public MimeParts getMimeParts() {
        return this.mimeParts;
    }

    public void setMimeParts(MimeParts mimeParts) {
        this.mimeParts = mimeParts;
    }
}

