/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.TableGenerator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTableGenerator
extends AbstractJavaGenerator
implements JavaTableGenerator,
UniqueConstraint.Owner {
    protected String specifiedTable;
    protected String defaultTable;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final List<JavaUniqueConstraint> uniqueConstraints = new ArrayList<JavaUniqueConstraint>();

    public GenericJavaTableGenerator(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    protected TableGeneratorAnnotation getGeneratorResource() {
        return (TableGeneratorAnnotation)super.getGeneratorResource();
    }

    @Override
    public Integer getDefaultInitialValue() {
        return TableGenerator.DEFAULT_INITIAL_VALUE;
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.getGeneratorResource().setTable(newSpecifiedTable);
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    @Override
    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.getGeneratorResource().setCatalog(newSpecifiedCatalog);
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    @Override
    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.getGeneratorResource().setSchema(newSpecifiedSchema);
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    @Override
    public String getPkColumnName() {
        return this.getSpecifiedPkColumnName() == null ? this.getDefaultPkColumnName() : this.getSpecifiedPkColumnName();
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String newSpecifiedPkColumnName) {
        String oldSpecifiedPkColumnName = this.specifiedPkColumnName;
        this.specifiedPkColumnName = newSpecifiedPkColumnName;
        this.getGeneratorResource().setPkColumnName(newSpecifiedPkColumnName);
        this.firePropertyChanged("specifiedPkColumnNameProperty", oldSpecifiedPkColumnName, newSpecifiedPkColumnName);
    }

    protected void setSpecifiedPkColumnName_(String newSpecifiedPkColumnName) {
        String oldSpecifiedPkColumnName = this.specifiedPkColumnName;
        this.specifiedPkColumnName = newSpecifiedPkColumnName;
        this.firePropertyChanged("specifiedPkColumnNameProperty", oldSpecifiedPkColumnName, newSpecifiedPkColumnName);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    @Override
    public String getValueColumnName() {
        return this.getSpecifiedValueColumnName() == null ? this.getDefaultValueColumnName() : this.getSpecifiedValueColumnName();
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String newSpecifiedValueColumnName) {
        String oldSpecifiedValueColumnName = this.specifiedValueColumnName;
        this.specifiedValueColumnName = newSpecifiedValueColumnName;
        this.getGeneratorResource().setValueColumnName(newSpecifiedValueColumnName);
        this.firePropertyChanged("specifiedValueColumnNameProperty", oldSpecifiedValueColumnName, newSpecifiedValueColumnName);
    }

    protected void setSpecifiedValueColumnName_(String newSpecifiedValueColumnName) {
        String oldSpecifiedValueColumnName = this.specifiedValueColumnName;
        this.specifiedValueColumnName = newSpecifiedValueColumnName;
        this.firePropertyChanged("specifiedValueColumnNameProperty", oldSpecifiedValueColumnName, newSpecifiedValueColumnName);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    @Override
    public String getPkColumnValue() {
        return this.getSpecifiedPkColumnValue() == null ? this.getDefaultPkColumnValue() : this.getSpecifiedPkColumnValue();
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String newSpecifiedPkColumnValue) {
        String oldSpecifiedPkColumnValue = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = newSpecifiedPkColumnValue;
        this.getGeneratorResource().setPkColumnValue(newSpecifiedPkColumnValue);
        this.firePropertyChanged("specifiedPkColummValueProperty", oldSpecifiedPkColumnValue, newSpecifiedPkColumnValue);
    }

    public void setSpecifiedPkColumnValue_(String newSpecifiedPkColumnValue) {
        String oldSpecifiedPkColumnValue = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = newSpecifiedPkColumnValue;
        this.firePropertyChanged("specifiedPkColummValueProperty", oldSpecifiedPkColumnValue, newSpecifiedPkColumnValue);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    @Override
    public ListIterator<JavaUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        this.uniqueConstraints.add(index, uniqueConstraint);
        UniqueConstraintAnnotation uniqueConstraintAnnotation = this.getGeneratorResource().addUniqueConstraint(index);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        this.fireItemAdded("uniqueConstraintsList", index, uniqueConstraint);
        return uniqueConstraint;
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        JavaUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getGeneratorResource().removeUniqueConstraint(index);
        this.fireItemRemoved("uniqueConstraintsList", index, removedUniqueConstraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getGeneratorResource().moveUniqueConstraint(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraintsList", targetIndex, sourceIndex);
    }

    protected void addUniqueConstraint(int index, JavaUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    protected void removeUniqueConstraint_(JavaUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        if (dbTable != null) {
            return dbTable.columnNames();
        }
        return EmptyIterator.instance();
    }

    @Override
    public void initializeFromResource(TableGeneratorAnnotation tableGenerator) {
        super.initializeFromResource(tableGenerator);
        this.specifiedTable = this.specifiedTable(tableGenerator);
        this.specifiedCatalog = this.specifiedCatalog(tableGenerator);
        this.defaultCatalog = this.defaultCatalog();
        this.specifiedSchema = this.specifiedSchema(tableGenerator);
        this.defaultSchema = this.defaultSchema();
        this.specifiedPkColumnName = this.specifiedPkColumnName(tableGenerator);
        this.specifiedValueColumnName = this.specifiedValueColumnName(tableGenerator);
        this.specifiedPkColumnValue = this.specifiedPkColumnValue(tableGenerator);
        this.initializeUniqueConstraints(tableGenerator);
    }

    protected void initializeUniqueConstraints(TableGeneratorAnnotation tableGenerator) {
        for (UniqueConstraintAnnotation uniqueConstraintAnnotation : CollectionTools.iterable(tableGenerator.uniqueConstraints())) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraintAnnotation));
        }
    }

    @Override
    public void update(TableGeneratorAnnotation tableGenerator) {
        super.update(tableGenerator);
        this.setSpecifiedTable_(this.specifiedTable(tableGenerator));
        this.setSpecifiedCatalog_(this.specifiedCatalog(tableGenerator));
        this.setDefaultCatalog(this.defaultCatalog());
        this.setSpecifiedSchema_(this.specifiedSchema(tableGenerator));
        this.setDefaultSchema(this.defaultSchema());
        this.setSpecifiedPkColumnName_(this.specifiedPkColumnName(tableGenerator));
        this.setSpecifiedValueColumnName_(this.specifiedValueColumnName(tableGenerator));
        this.setSpecifiedPkColumnValue_(this.specifiedPkColumnValue(tableGenerator));
        this.updateUniqueConstraints(tableGenerator);
    }

    protected void updateUniqueConstraints(TableGeneratorAnnotation tableGenerator) {
        ListIterator<JavaUniqueConstraint> uniqueConstraints = this.uniqueConstraints();
        ListIterator<UniqueConstraintAnnotation> resourceUniqueConstraints = tableGenerator.uniqueConstraints();
        while (uniqueConstraints.hasNext()) {
            JavaUniqueConstraint uniqueConstraint = uniqueConstraints.next();
            if (resourceUniqueConstraints.hasNext()) {
                uniqueConstraint.update(resourceUniqueConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (resourceUniqueConstraints.hasNext()) {
            this.addUniqueConstraint(this.uniqueConstraintsSize(), this.buildUniqueConstraint(resourceUniqueConstraints.next()));
        }
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        return uniqueConstraint;
    }

    protected String specifiedTable(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getTable();
    }

    protected String specifiedCatalog(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getCatalog();
    }

    protected String specifiedSchema(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getSchema();
    }

    protected String specifiedPkColumnName(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getPkColumnName();
    }

    protected String specifiedValueColumnName(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getValueColumnName();
    }

    protected String specifiedPkColumnValue(TableGeneratorAnnotation tableGenerator) {
        return tableGenerator.getPkColumnValue();
    }

    protected String defaultSchema() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getSchema();
        }
        return this.getPersistenceUnit().getDefaultSchema();
    }

    protected String defaultCatalog() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getCatalog();
        }
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    @Override
    public Table getDbTable() {
        Schema schema = this.getDbSchema();
        return schema == null ? null : schema.tableNamed(this.getTable());
    }

    @Override
    public Schema getDbSchema() {
        return this.getDatabase().schemaNamed(this.getSchema());
    }
}

