/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryEditControl;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationEvent;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationListener;
import org.eclipse.jst.jsf.ui.internal.classpath.WarningMessageDialogWithToggle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class JSFLibraryWizard
extends Wizard
implements INewWizard {
    public static final int IMPLS = 1;
    public static final int NONIMPLS = 2;
    private JSFLibraryEditControl jsfLibraryEditControl;
    private boolean isNew = false;
    private boolean modified = false;
    private JSFLibrary curLibrary;
    private JSFLibrary workingCopyLibrary;
    private JSFLibraryWizardPage page;
    private boolean _impls;
    private boolean _nonimpls;
    private List<IProject> _projectsWithV1JSFLibraries = new ArrayList<IProject>();

    public JSFLibraryWizard(int libTypes) {
        if ((libTypes & 1) == 1) {
            this._impls = true;
        }
        if ((libTypes & 2) == 2) {
            this._nonimpls = true;
        }
    }

    public JSFLibraryWizard() {
        this._impls = true;
        this._nonimpls = true;
    }

    private boolean isImplsOnly() {
        return this._impls && !this._nonimpls;
    }

    private boolean isNonImplsOnly() {
        return this._nonimpls && !this._impls;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initV1LibrariesList();
        if (selection != null && selection.getFirstElement() instanceof JSFLibrary) {
            this.curLibrary = (JSFLibrary)selection.getFirstElement();
            this.workingCopyLibrary = this.curLibrary.getWorkingCopy();
        } else {
            this.isNew = true;
            this.workingCopyLibrary = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        }
        if (this.isImplsOnly()) {
            this.setWindowTitle(Messages.JSFLibraryWizard_CreateImplementation);
        } else {
            this.setWindowTitle(this.isNew ? Messages.JSFLibraryWizard_CreateJSFLibrary : Messages.JSFLibraryWizard_EditJSFLibrary);
        }
    }

    private void initV1LibrariesList() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (JSFLibraryRegistryUtil.doesProjectHaveV1JSFLibraries((IProject)project)) {
                this._projectsWithV1JSFLibraries.add(project);
            }
            ++i;
        }
    }

    public boolean performFinish() {
        String originalID;
        if (!this.isNew && this._projectsWithV1JSFLibraries.size() > 0) {
            String projectNames = "";
            for (IProject project : this._projectsWithV1JSFLibraries) {
                projectNames = String.valueOf(projectNames) + project.getName() + ",";
            }
            if (projectNames.length() > 0) {
                projectNames = projectNames.substring(0, projectNames.length() - 1);
            }
            String messageText = MessageFormat.format(Messages.JSFLibraryWizard_V1JSFLibrary_DialogMessage, projectNames);
            MessageDialogWithToggle dialog = WarningMessageDialogWithToggle.openOkCancelConfirm(this.getShell(), Messages.JSFLibraryWizard_V1JSFLibrary_DialogTitle, messageText, Messages.JSFLibraryWizard_JSFLibraryWizard_DontShowThisAgain_CheckBoxLabel, false, null, null);
            if (dialog.getReturnCode() != 0) {
                return false;
            }
            if (dialog.getToggleState()) {
                JSFLibraryRegistryUtil.removeV1JSFLibraryProperty(this._projectsWithV1JSFLibraries);
            }
        }
        String name = this.jsfLibraryEditControl.getJSFLibraryName();
        boolean isDeployed = this.jsfLibraryEditControl.getIsDeployed();
        boolean isImplementation = this.jsfLibraryEditControl.getIsImplementation();
        JSFVersion version = this.jsfLibraryEditControl.getJSFVersion();
        this.workingCopyLibrary.setName(name);
        this.workingCopyLibrary.setDeployed(isDeployed);
        this.workingCopyLibrary.setImplementation(isImplementation);
        this.workingCopyLibrary.setJSFVersion(version);
        String string = originalID = this.curLibrary != null ? this.curLibrary.getID() : this.workingCopyLibrary.getID();
        if (this.isNew) {
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(this.workingCopyLibrary);
        } else {
            this.curLibrary.updateValues(this.workingCopyLibrary);
            try {
                JSFLibraryRegistryUtil.rebindClasspathContainerEntries((String)originalID, (String)this.workingCopyLibrary.getID(), null);
            }
            catch (JavaModelException e) {
                JSFUiPlugin.log(4, "Exception while updating JSF Library containers", e);
            }
        }
        JSFLibraryRegistryUtil.getInstance().saveJSFLibraryRegistry();
        return true;
    }

    public void addPages() {
        this.page = new JSFLibraryWizardPage(Messages.JSFLibraryWizard_JSFLibrary);
        super.addPage((IWizardPage)this.page);
        this.page.setWizard((IWizard)this);
    }

    public JSFLibrary getJSFLibrary() {
        return this.workingCopyLibrary;
    }

    private class JSFLibraryWizardPage
    extends WizardPage {
        protected JSFLibraryWizardPage(String pageName) {
            super(pageName);
            this.setDescription(JSFLibraryWizard.this.isImplsOnly() ? Messages.JSFLibraryWizard_IMPLS_ONLY_DESC : Messages.JSFLibraryWizard_DESCRIPTION);
            this.setTitle(Messages.JSFLibraryWizard_JSFLibrary);
        }

        public boolean isPageComplete() {
            if (!JSFLibraryWizard.this.modified) {
                return false;
            }
            return super.isPageComplete();
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            JSFLibraryWizard.this.jsfLibraryEditControl = new JSFLibraryEditControl(JSFLibraryWizard.this.workingCopyLibrary, parent);
            JSFLibraryWizard.this.jsfLibraryEditControl.setImplOnly(JSFLibraryWizard.this.isImplsOnly());
            JSFLibraryWizard.this.jsfLibraryEditControl.setNonImplOnly(JSFLibraryWizard.this.isNonImplsOnly());
            JSFLibraryWizard.this.jsfLibraryEditControl.setLayout((Layout)new GridLayout(2, false));
            JSFLibraryWizard.this.jsfLibraryEditControl.setLayoutData(new GridData(1808));
            JSFLibraryWizard.this.jsfLibraryEditControl.addValidationListener(new JSFLibraryValidationListener(){

                public void notifyValidation(JSFLibraryValidationEvent e) {
                    JSFLibraryWizardPage.this.setErrorMessage(e.getMessage());
                    JSFLibraryWizard.this.modified = true;
                    JSFLibraryWizardPage.this.setPageComplete(JSFLibraryWizardPage.this.getErrorMessage() == null);
                }
            });
            this.setControl((Control)JSFLibraryWizard.this.jsfLibraryEditControl);
            this.setPageComplete(false);
        }
    }
}

