/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDElementFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDElementDeclarationToFragmentMapper
extends XSDToFragmentMapper {
    public XSDElementDeclarationToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        XSDElementDeclaration resolvedElement;
        XSDTypeDefinition typeDef;
        XSDElementDeclaration element = (XSDElementDeclaration)config.getXSDComponent();
        if (element != null && (typeDef = this.resolveXSDTypeDefinition(this.getXSDTypeDefinition(resolvedElement = this.resolveXSDElementDeclaration(element)))) != null) {
            int minOccurs = 1;
            int maxOccurs = 1;
            XSDConcreteComponent concreteComponent = element.getContainer();
            if (concreteComponent != null && concreteComponent instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)concreteComponent;
                if (particle.isSetMinOccurs()) {
                    minOccurs = particle.getMinOccurs();
                }
                if (particle.isSetMaxOccurs()) {
                    maxOccurs = particle.getMaxOccurs();
                }
            }
            config.setMinOccurs(minOccurs);
            config.setMaxOccurs(maxOccurs);
            XSDElementFragment elementFrag = new XSDElementFragment(id, resolvedElement.getName(), config);
            elementFrag.setXSDTypeDefinition(typeDef);
            XSDToFragmentConfiguration elementTypeConfig = new XSDToFragmentConfiguration();
            elementTypeConfig.setXSDComponent((XSDComponent)typeDef);
            elementTypeConfig.setMinOccurs(minOccurs);
            elementTypeConfig.setMaxOccurs(maxOccurs);
            elementTypeConfig.setStyle(config.getStyle());
            elementTypeConfig.setPartEncoding(config.getPartEncoding());
            elementTypeConfig.setWSDLPartName(config.getWSDLPartName());
            IXSDFragment xsdFragment = this.getController().getFragment(elementTypeConfig, elementFrag.genID(), resolvedElement.getName());
            elementFrag.setXSDDelegationFragment(xsdFragment);
            return elementFrag;
        }
        return this.getXSDDefaultFragment(config, id, name);
    }

    private XSDElementDeclaration resolveXSDElementDeclaration(XSDElementDeclaration element) {
        if (element.getResolvedElementDeclaration() != null) {
            XSDNamedComponent resolvedComponent;
            XSDElementDeclaration resolvedElement = element.getResolvedElementDeclaration();
            if (!this.isComponentResolvable((XSDComponent)resolvedElement) && (resolvedComponent = this.getWSDLPartsToXSDTypeMapper().resolveXSDNamedComponent((XSDNamedComponent)resolvedElement)) != null && resolvedComponent instanceof XSDElementDeclaration) {
                resolvedElement = (XSDElementDeclaration)resolvedComponent;
            }
            return resolvedElement;
        }
        return element;
    }

    private XSDTypeDefinition resolveXSDTypeDefinition(XSDTypeDefinition typeDef) {
        XSDNamedComponent resolvedComponent;
        if (!this.isComponentResolvable((XSDComponent)typeDef) && (resolvedComponent = this.getWSDLPartsToXSDTypeMapper().resolveXSDNamedComponent((XSDNamedComponent)typeDef)) instanceof XSDTypeDefinition) {
            return (XSDTypeDefinition)resolvedComponent;
        }
        return typeDef;
    }

    private XSDTypeDefinition getXSDTypeDefinition(XSDElementDeclaration element) {
        if (element.getTypeDefinition() != null) {
            return element.getTypeDefinition();
        }
        if (element.getAnonymousTypeDefinition() != null) {
            return element.getAnonymousTypeDefinition();
        }
        return null;
    }
}

