/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.internet.cache.internal.CachePlugin;
import org.eclipse.wst.internet.cache.internal.CacheURIResolverExtension;

public class CacheURIResolverExtensionTest
extends TestCase {
    private CacheURIResolverExtension cacheResolver;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.cache.internal.CacheURIResolverExtensionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cacheResolver = new CacheURIResolverExtension();
        CachePlugin.getDefault().setCacheEnabled(true);
    }

    public void testResolveNullSystemId() {
        String result = this.cacheResolver.resolve(null, "http://www.eclipse.org/webtools", null, null);
        CacheURIResolverExtensionTest.assertNull((String)"The result is not null.", (Object)result);
    }

    public void testResolveNullSystemIdAndBaselocation() {
        String result = this.cacheResolver.resolve(null, null, null, null);
        CacheURIResolverExtensionTest.assertNull((String)"The result is not null.", (Object)result);
    }

    public void testAbsoluteSystemId() {
        String result = this.cacheResolver.resolve(null, "http://www.eclipse.org/webtools", null, "http://www.eclipse.org");
        CacheURIResolverExtensionTest.assertNotNull((String)"The result is null.", (Object)result);
    }

    public void testAbsoluteSystemIdNullBaselocation() {
        String result = this.cacheResolver.resolve(null, null, null, "http://www.eclipse.org");
        CacheURIResolverExtensionTest.assertNotNull((String)"The result is null.", (Object)result);
    }

    public void testRelativeSystemId() {
        String result = this.cacheResolver.resolve(null, "http://www.eclipse.org/webtools/community/somefile.xml", null, "community.html");
        CacheURIResolverExtensionTest.assertNotNull((String)"The result is null.", (Object)result);
    }

    public void testRelativeSystemIdWillNullBaselocation() {
        String result = this.cacheResolver.resolve(null, null, null, "community.html");
        CacheURIResolverExtensionTest.assertNull((String)"The result is not null.", (Object)result);
    }

    public void testReturnsNullWhenDisabled() {
        CachePlugin.getDefault().setCacheEnabled(false);
        String result = this.cacheResolver.resolve(null, "http://www.eclipse.org/webtools/", null, "http://www.eclipse.org/webtools/");
        CacheURIResolverExtensionTest.assertNull((String)"The result is not null.", (Object)result);
        CachePlugin.getDefault().setCacheEnabled(true);
    }
}

