/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.util.Collections;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IDynamicPreset;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.BasicTests;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;

public final class PresetsTests
extends TestCase {
    private PresetsTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Presets Tests");
        suite.addTest((Test)new PresetsTests("testSimpleStaticPresets"));
        suite.addTest((Test)new PresetsTests("testDerivedStaticPresets"));
        suite.addTest((Test)new PresetsTests("testDynamicPresets"));
        suite.addTest((Test)new PresetsTests("testStaticPresetsExtendingDynamicPresets1"));
        suite.addTest((Test)new PresetsTests("testStaticPresetsExtendingDynamicPresets2"));
        suite.addTest((Test)new PresetsTests("testUserDefinedPresets"));
        return suite;
    }

    public void testSimpleStaticPresets() {
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_preset1"));
        IPreset preset1 = ProjectFacetsManager.getPreset((String)"pt_preset1");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset1));
        PresetsTests.assertEquals((String)preset1.getId(), (String)"pt_preset1");
        PresetsTests.assertEquals((Object)preset1.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((String)preset1.getLabel(), (String)"Preset 1");
        PresetsTests.assertEquals((String)preset1.getDescription(), (String)"This is the description for the first preset.");
        PresetsTests.assertEquals((Object)preset1.getProjectFacets(), TestUtils.asSet(BasicTests.f1v20, BasicTests.f2v35a, BasicTests.f2extv10));
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_preset2"));
        IPreset preset2 = ProjectFacetsManager.getPreset((String)"pt_preset2");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset2));
        PresetsTests.assertEquals((String)preset2.getId(), (String)"pt_preset2");
        PresetsTests.assertEquals((Object)preset2.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((String)preset2.getLabel(), (String)"pt_preset2");
        PresetsTests.assertEquals((String)preset2.getDescription(), (String)"");
        PresetsTests.assertEquals((Object)preset2.getProjectFacets(), TestUtils.asSet(BasicTests.f3av10, BasicTests.f3bv10, BasicTests.f3cv10));
    }

    public void testDerivedStaticPresets() {
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_preset3"));
        IPreset preset3 = ProjectFacetsManager.getPreset((String)"pt_preset3");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset3));
        PresetsTests.assertEquals((String)preset3.getId(), (String)"pt_preset3");
        PresetsTests.assertEquals((Object)preset3.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((Object)preset3.getProjectFacets(), TestUtils.asSet(BasicTests.f1v121, BasicTests.f2v35a, BasicTests.f2extv10, BasicTests.f3av10));
    }

    public void testDynamicPresets() {
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_dyn_preset"));
        IPreset preset = ProjectFacetsManager.getPreset((String)"pt_dyn_preset");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset));
        PresetsTests.assertEquals((String)preset.getId(), (String)"pt_dyn_preset");
        PresetsTests.assertEquals((Object)preset.getType(), (Object)IPreset.Type.DYNAMIC);
        PresetsTests.assertEquals((String)preset.getLabel(), (String)"pt_dyn_preset");
        PresetsTests.assertEquals((String)preset.getDescription(), (String)"");
        PresetsTests.assertEquals((Object)preset.getProjectFacets(), Collections.emptySet());
        IDynamicPreset dynamicPreset = (IDynamicPreset)preset;
        IPreset resolved = dynamicPreset.resolve(Collections.emptyMap());
        PresetsTests.assertEquals((String)resolved.getId(), (String)"pt_dyn_preset");
        PresetsTests.assertEquals((Object)resolved.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((String)resolved.getLabel(), (String)"Dynamic Preset");
        PresetsTests.assertEquals((String)resolved.getDescription(), (String)"The description of the dynamic preset.");
        PresetsTests.assertEquals((Object)resolved.getProjectFacets(), TestUtils.asSet(BasicTests.f1v20, BasicTests.f2extv10, BasicTests.f3cv10));
    }

    public void testStaticPresetsExtendingDynamicPresets1() {
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_static_extending_dynamic_preset_1"));
        IPreset preset = ProjectFacetsManager.getPreset((String)"pt_static_extending_dynamic_preset_1");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset));
        PresetsTests.assertEquals((String)preset.getId(), (String)"pt_static_extending_dynamic_preset_1");
        PresetsTests.assertEquals((Object)preset.getType(), (Object)IPreset.Type.DYNAMIC);
        PresetsTests.assertEquals((String)preset.getLabel(), (String)"Static Extending Dynamic Preset");
        PresetsTests.assertEquals((String)preset.getDescription(), (String)"This is the static-dynamic description.");
        PresetsTests.assertEquals((Object)preset.getProjectFacets(), Collections.emptySet());
        IDynamicPreset dynamicPreset = (IDynamicPreset)preset;
        IPreset resolved = dynamicPreset.resolve(Collections.emptyMap());
        PresetsTests.assertEquals((String)resolved.getId(), (String)"pt_static_extending_dynamic_preset_1");
        PresetsTests.assertEquals((Object)resolved.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((String)resolved.getLabel(), (String)"Static Extending Dynamic Preset");
        PresetsTests.assertEquals((String)resolved.getDescription(), (String)"This is the static-dynamic description.");
        PresetsTests.assertEquals((Object)resolved.getProjectFacets(), TestUtils.asSet(BasicTests.f1v20, BasicTests.f2extv10, BasicTests.f3cv10, BasicTests.f2v35a, BasicTests.f3bv10));
    }

    public void testStaticPresetsExtendingDynamicPresets2() {
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_static_extending_dynamic_preset_2"));
        IPreset preset = ProjectFacetsManager.getPreset((String)"pt_static_extending_dynamic_preset_2");
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset));
        PresetsTests.assertEquals((String)preset.getId(), (String)"pt_static_extending_dynamic_preset_2");
        PresetsTests.assertEquals((Object)preset.getType(), (Object)IPreset.Type.DYNAMIC);
        PresetsTests.assertEquals((String)preset.getLabel(), (String)"Static Extending Dynamic Preset 2");
        PresetsTests.assertEquals((String)preset.getDescription(), (String)"This is the static-dynamic description 2.");
        PresetsTests.assertEquals((Object)preset.getProjectFacets(), Collections.emptySet());
        IDynamicPreset dynamicPreset = (IDynamicPreset)preset;
        IPreset resolved = dynamicPreset.resolve(Collections.emptyMap());
        PresetsTests.assertEquals((String)resolved.getId(), (String)"pt_static_extending_dynamic_preset_2");
        PresetsTests.assertEquals((Object)resolved.getType(), (Object)IPreset.Type.STATIC);
        PresetsTests.assertEquals((String)resolved.getLabel(), (String)"Static Extending Dynamic Preset 2");
        PresetsTests.assertEquals((String)resolved.getDescription(), (String)"This is the static-dynamic description 2.");
        PresetsTests.assertEquals((Object)resolved.getProjectFacets(), TestUtils.asSet(BasicTests.f1v121, BasicTests.f2extv10, BasicTests.f3cv10, BasicTests.f2v35a, BasicTests.f3bv10, BasicTests.f3av10));
    }

    public void testUserDefinedPresets() {
        PresetsTests.assertFalse((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_user_defined"));
        IPreset preset = ProjectFacetsManager.definePreset((String)"pt_user_defined", (String)"the description", TestUtils.asSet(BasicTests.f1v121, BasicTests.f2extv10));
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.isPresetDefined((String)preset.getId()));
        PresetsTests.assertTrue((boolean)ProjectFacetsManager.getPresets().contains(preset));
        PresetsTests.assertEquals((Object)preset.getType(), (Object)IPreset.Type.USER_DEFINED);
        PresetsTests.assertEquals((String)preset.getLabel(), (String)"pt_user_defined");
        PresetsTests.assertEquals((String)preset.getDescription(), (String)"the description");
        PresetsTests.assertEquals((Object)preset.getProjectFacets(), TestUtils.asSet(BasicTests.f1v121, BasicTests.f2extv10));
        ProjectFacetsManager.deletePreset((IPreset)preset);
        PresetsTests.assertFalse((boolean)ProjectFacetsManager.isPresetDefined((String)"pt_user_defined"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PresetFactory
    implements IPresetFactory {
        public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
            return new PresetDefinition("Dynamic Preset", "The description of the dynamic preset.", TestUtils.asSet(BasicTests.f1v20, BasicTests.f2extv10, BasicTests.f3cv10));
        }
    }
}

