/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.util;

import java.io.FileOutputStream;
import java.util.Iterator;
import javax.wsdl.OperationType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.internal.impl.BindingFaultImpl;
import org.eclipse.wst.wsdl.internal.impl.BindingImpl;
import org.eclipse.wst.wsdl.internal.impl.BindingInputImpl;
import org.eclipse.wst.wsdl.internal.impl.BindingOperationImpl;
import org.eclipse.wst.wsdl.internal.impl.BindingOutputImpl;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.OperationImpl;
import org.eclipse.wst.wsdl.internal.impl.PortImpl;
import org.eclipse.wst.wsdl.internal.impl.PortTypeImpl;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.tests.util.DefinitionVisitor;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLConverter
extends DefinitionVisitor {
    private Document doc;
    private Element description;
    private Element currentTypes;
    private Element currentService;
    private Element currentEndpoint;
    private Element currentInterface;
    private Element currentOperation;
    private Element currentBinding;
    private Element currentBindingOperation;
    private Element currentBindingInput;
    private Element currentBindingOutput;
    private Element currentBindingFault;
    private String wsdlNamespacePrefix;
    private String xsdNamespacePrefix;

    public WSDLConverter(String name) {
        super(name);
    }

    public WSDLConverter(Definition definition) {
        super(definition);
    }

    public void generate20(String filename) throws Exception {
        this.createDocument();
        this.visit();
        this.serialize(filename);
    }

    private void serialize(String filename) throws Exception {
        DOMSource domSource = new DOMSource(this.doc);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(domSource, new StreamResult(new FileOutputStream(filename)));
    }

    private void createDocument() throws ParserConfigurationException {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    private Element createWSDLElement(String name) {
        Element element = this.doc.createElementNS("http://www.w3.org/2004/08/wsdl", name);
        if (this.wsdlNamespacePrefix != null) {
            element.setPrefix(this.wsdlNamespacePrefix);
        }
        return element;
    }

    private void processDocumentation(Element docElement, Element parent) {
        if (docElement == null) {
            return;
        }
        Element adoptedDocElement = (Element)this.doc.importNode(docElement, true);
        parent.appendChild(adoptedDocElement);
    }

    protected void visitDefinition(Definition def) {
        this.description = this.createWSDLElement("description");
        this.processDocumentation(def.getDocumentationElement(), this.description);
        this.description.setAttribute("xmlns:soapenv", "http://www.w3.org/2003/05/soap-envelop");
        this.description.setAttribute("xmlns:wsoap", "http://www.w3.org/2004/08/soap12");
        String targetNamespace = def.getTargetNamespace();
        if (targetNamespace != null) {
            this.description.setAttribute("targetNamespace", targetNamespace);
        }
        Iterator iterator = def.getNamespaces().keySet().iterator();
        String prefix = null;
        String namespace = null;
        while (iterator.hasNext()) {
            prefix = (String)iterator.next();
            namespace = def.getNamespace(prefix);
            if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                if (prefix.length() == 0) {
                    this.description.setAttribute("xmlns", "http://www.w3.org/2004/08/wsdl");
                    continue;
                }
                this.description.setAttribute("xmlns:" + prefix, "http://www.w3.org/2004/08/wsdl");
                this.wsdlNamespacePrefix = prefix;
                this.description.setPrefix(this.wsdlNamespacePrefix);
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace)) {
                this.description.setAttribute("xmlns:" + prefix, "http://www.w3.org/2003/05/soap-envelop");
                this.description.setAttribute("xmlns:wsoap", "http://www.w3.org/2004/08/soap12");
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                this.xsdNamespacePrefix = prefix;
            }
            if (prefix.length() == 0) {
                this.description.setAttribute("xmlns" + prefix, namespace);
                continue;
            }
            this.description.setAttribute("xmlns:" + prefix, namespace);
        }
        this.doc.appendChild(this.description);
        super.visitDefinition(def);
    }

    protected void visitImport(Import wsdlImport) {
        if (this.importingSchema(wsdlImport)) {
            this.currentTypes = this.createWSDLElement("types");
            this.description.appendChild(this.currentTypes);
            Element schemaImport = this.doc.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            if (this.xsdNamespacePrefix == null) {
                this.description.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
                this.xsdNamespacePrefix = "xs";
                schemaImport.setPrefix(this.xsdNamespacePrefix);
            } else if (!"".equals(this.xsdNamespacePrefix)) {
                schemaImport.setPrefix(this.xsdNamespacePrefix);
            }
            schemaImport.setAttribute("namespace", wsdlImport.getNamespaceURI());
            schemaImport.setAttribute("schemaLocation", wsdlImport.getLocationURI());
            this.processDocumentation(wsdlImport.getDocumentationElement(), schemaImport);
            this.currentTypes.appendChild(schemaImport);
        } else {
            Element importElement = wsdlImport.getElement();
            Element adoptedImportElement = (Element)this.doc.importNode(importElement, true);
            this.processDocumentation(wsdlImport.getDocumentationElement(), adoptedImportElement);
            this.description.appendChild(adoptedImportElement);
        }
    }

    private boolean importingSchema(Import myImport) {
        return myImport.getDefinition() == null;
    }

    protected void visitTypes(Types types) {
        if (this.currentTypes == null) {
            this.currentTypes = this.createWSDLElement("types");
            this.processDocumentation(types.getDocumentationElement(), this.currentTypes);
            this.description.appendChild(this.currentTypes);
        }
        Iterator iterator = types.getSchemas().iterator();
        XSDSchema schema = null;
        Element schemaElement = null;
        Element adoptedSchemaElement = null;
        while (iterator.hasNext()) {
            schema = (XSDSchema)iterator.next();
            schema.updateElement();
            schemaElement = schema.getElement();
            adoptedSchemaElement = (Element)this.doc.importNode(schemaElement, true);
            this.currentTypes.appendChild(adoptedSchemaElement);
        }
    }

    protected void visitPart(Part part) {
    }

    protected void visitPortType(PortType portType) {
        this.currentInterface = this.createWSDLElement("interface");
        this.processDocumentation(portType.getDocumentationElement(), this.currentInterface);
        Element portTypeElement = portType.getElement();
        if (portTypeElement.hasAttribute("name")) {
            this.currentInterface.setAttribute("name", portTypeElement.getAttribute("name"));
        }
        this.description.appendChild(this.currentInterface);
        super.visitPortType(portType);
    }

    protected void visitOperation(Operation operation) {
        OperationType opType;
        this.currentOperation = this.createWSDLElement("operation");
        this.processDocumentation(operation.getDocumentationElement(), this.currentOperation);
        Element operationElement = operation.getElement();
        if (operationElement.hasAttribute("name")) {
            this.currentOperation.setAttribute("name", operationElement.getAttribute("name"));
        }
        if (OperationType.REQUEST_RESPONSE == (opType = operation.getStyle())) {
            this.currentOperation.setAttribute("pattern", "http://www.w3.org/2004/03/wsdl/in-out");
        } else if (OperationType.SOLICIT_RESPONSE == opType) {
            this.currentOperation.setAttribute("pattern", "http://www.w3.org/2004/03/wsdl/out-in");
        } else if (OperationType.NOTIFICATION == opType) {
            this.currentOperation.setAttribute("pattern", "http://www.w3.org/2004/03/wsdl/out-only");
        } else if (OperationType.ONE_WAY == opType) {
            this.currentOperation.setAttribute("pattern", "http://www.w3.org/2004/03/wsdl/in-only");
        }
        this.currentInterface.appendChild(this.currentOperation);
        super.visitOperation(operation);
    }

    protected void visitInput(Input input) {
        Element partElement;
        Element currentInput = this.createWSDLElement("input");
        this.processDocumentation(input.getDocumentationElement(), currentInput);
        Element inputElement = input.getElement();
        if (inputElement.hasAttribute("name")) {
            currentInput.setAttribute("messageLabel", inputElement.getAttribute("name"));
        }
        if ((partElement = this.getPartElement((MessageReference)input)).hasAttribute("element")) {
            currentInput.setAttribute("element", partElement.getAttribute("element"));
        }
        this.currentOperation.appendChild(currentInput);
    }

    private Element getPartElement(MessageReference messageRef) {
        Iterator iterator = messageRef.getEMessage().getEParts().iterator();
        Part part = (Part)iterator.next();
        Element partElement = part.getElement();
        return partElement;
    }

    protected void visitOutput(Output output) {
        Element partElement;
        Element currentOutput = this.createWSDLElement("output");
        this.processDocumentation(output.getDocumentationElement(), currentOutput);
        Element outputElement = output.getElement();
        if (outputElement.hasAttribute("name")) {
            currentOutput.setAttribute("messageLabel", outputElement.getAttribute("name"));
        }
        if ((partElement = this.getPartElement((MessageReference)output)).hasAttribute("element")) {
            currentOutput.setAttribute("element", partElement.getAttribute("element"));
        }
        this.currentOperation.appendChild(currentOutput);
    }

    protected void visitFault(Fault fault) {
    }

    protected void visitBinding(Binding binding) {
        this.currentBinding = this.createWSDLElement("binding");
        this.processDocumentation(binding.getDocumentationElement(), this.currentBinding);
        Element bindingElement = binding.getElement();
        if (bindingElement.hasAttribute("name")) {
            this.currentBinding.setAttribute("name", bindingElement.getAttribute("name"));
        }
        if (bindingElement.hasAttribute("type")) {
            this.currentBinding.setAttribute("interface", bindingElement.getAttribute("type"));
        }
        this.currentBinding.setAttribute("type", "http://www.w3.org/2004/08/wsdl/soap12");
        this.currentBinding.setAttribute("wsoap:protocol", "http://www.w3.org/2003/05/soap/bindings/HTTP");
        this.currentBinding.setAttribute("wsoap:mepDefault", "http://www.w3.org.2003/05/soap/mep/request-response");
        this.description.appendChild(this.currentBinding);
        super.visitBinding(binding);
    }

    protected void visitBindingOperation(BindingOperation operation) {
        this.currentBindingOperation = this.createWSDLElement("operation");
        this.processDocumentation(operation.getDocumentationElement(), this.currentBindingOperation);
        String operationName = operation.getEOperation().getName();
        String prefix = null;
        String targetNamespace = null;
        Definition def = operation.getEnclosingDefinition();
        if (def != null) {
            targetNamespace = def.getTargetNamespace();
        }
        if (targetNamespace != null) {
            prefix = def.getPrefix(targetNamespace);
        }
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        this.currentBindingOperation.setAttribute("ref", String.valueOf(prefix) + operationName);
        this.currentBinding.appendChild(this.currentBindingOperation);
        super.visitBindingOperation(operation);
    }

    protected void visitBindingInput(BindingInput input) {
        this.currentBindingInput = this.createWSDLElement("input");
        this.processDocumentation(input.getDocumentationElement(), this.currentBindingInput);
        Element inputElement = input.getElement();
        String inputName = input.getName();
        if (inputName != null) {
            inputElement.setAttribute("name", inputName);
        }
        this.currentBindingOperation.appendChild(this.currentBindingInput);
        super.visitBindingInput(input);
    }

    protected void visitBindingOutput(BindingOutput output) {
        this.currentBindingOutput = this.createWSDLElement("output");
        this.processDocumentation(output.getDocumentationElement(), this.currentBindingOutput);
        Element outputElement = output.getElement();
        String outputName = output.getName();
        if (outputName != null) {
            outputElement.setAttribute("name", outputName);
        }
        this.currentBindingOperation.appendChild(this.currentBindingOutput);
        super.visitBindingOutput(output);
    }

    protected void visitBindingFault(BindingFault fault) {
        this.currentBindingFault = this.createWSDLElement("fault");
        this.processDocumentation(fault.getDocumentationElement(), this.currentBindingFault);
        Element faultElement = fault.getElement();
        String faultName = fault.getName();
        if (faultName != null) {
            faultElement.setAttribute("name", faultName);
        }
        this.currentBindingOperation.appendChild(this.currentBindingFault);
        super.visitBindingFault(fault);
    }

    protected void visitService(Service service) {
        this.currentService = this.createWSDLElement("service");
        this.processDocumentation(service.getDocumentationElement(), this.currentService);
        Element serviceElement = service.getElement();
        if (serviceElement.hasAttribute("name")) {
            this.currentService.setAttribute("name", serviceElement.getAttribute("name"));
        }
        this.description.appendChild(this.currentService);
        super.visitService(service);
    }

    protected void visitPort(Port port) {
        Element bindingElement;
        Binding binding;
        this.currentEndpoint = this.createWSDLElement("endpoint");
        this.processDocumentation(port.getDocumentationElement(), this.currentEndpoint);
        Element portElement = port.getElement();
        if (portElement.hasAttribute("name")) {
            this.currentEndpoint.setAttribute("name", portElement.getAttribute("name"));
        }
        if (portElement.hasAttribute("binding")) {
            this.currentEndpoint.setAttribute("binding", portElement.getAttribute("binding"));
        }
        if ((binding = port.getEBinding()) != null && (bindingElement = binding.getElement()).hasAttribute("type")) {
            this.currentService.setAttribute("interface", bindingElement.getAttribute("type"));
        }
        this.currentService.appendChild(this.currentEndpoint);
        super.visitPort(port);
    }

    protected void visitExtensibilityElement(ExtensibleElement owner, ExtensibilityElement extensibilityElement) {
        if (owner instanceof PortImpl) {
            Element soapElement = extensibilityElement.getElement();
            if (soapElement.hasAttribute("location")) {
                this.currentEndpoint.setAttribute("address", soapElement.getAttribute("location"));
            }
        } else {
            Element domElement = extensibilityElement.getElement();
            Element adoptedDOMElement = (Element)this.doc.importNode(domElement, true);
            if (owner instanceof DefinitionImpl) {
                this.description.insertBefore(adoptedDOMElement, this.description.getFirstChild());
            } else if (owner instanceof ServiceImpl) {
                this.currentService.insertBefore(adoptedDOMElement, this.currentService.getFirstChild());
            } else if (owner instanceof PortTypeImpl) {
                this.currentInterface.insertBefore(adoptedDOMElement, this.currentInterface.getFirstChild());
            } else if (owner instanceof OperationImpl) {
                this.currentOperation.insertBefore(adoptedDOMElement, this.currentOperation.getFirstChild());
            } else if (owner instanceof BindingImpl) {
                this.currentBinding.insertBefore(adoptedDOMElement, this.currentBinding.getFirstChild());
            } else if (owner instanceof BindingOperationImpl) {
                this.currentBindingOperation.insertBefore(adoptedDOMElement, this.currentBindingOperation.getFirstChild());
            } else if (owner instanceof BindingInputImpl) {
                this.currentBindingInput.insertBefore(adoptedDOMElement, this.currentBindingInput.getFirstChild());
            } else if (owner instanceof BindingOutputImpl) {
                this.currentBindingOutput.insertBefore(adoptedDOMElement, this.currentBindingOutput.getFirstChild());
            } else if (owner instanceof BindingFaultImpl) {
                this.currentBindingFault.insertBefore(adoptedDOMElement, this.currentBindingFault.getFirstChild());
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WSDLConverter("Convert"){

            protected void runTest() {
                this.testConvert();
            }
        });
        return suite;
    }

    public void testConvert() {
        try {
            Definition def = DefinitionLoader.load("d:/eclipse301/eclipse/workspace/org.eclipse.wst.wsdl.tests/PTATimeDistribution.wsdl");
            WSDLConverter converter = new WSDLConverter(def);
            converter.generate20("d:/eclipse301/eclipse/workspace/org.eclipse.wst.wsdl.tests/PTATimeDistribution20.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)WSDLConverter.suite());
    }
}

