/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.tests.unittest;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.tests.plugin.TestsPlugin;

public class WSDLCopierTests
extends TestCase {
    private static final String DATA_DIR = "data/wsdlcopier/";
    private static final String WSDL_FOLDER1 = "wsdl1";
    private static final String WSDL_FOLDER2 = "wsdl2";
    private static final String WSDL_FOLDER3 = "wsdl3";
    private static final String WSDL_FOLDER4 = "wsdl4";
    private IProject project;

    public static Test suite() {
        TestSuite suite = new TestSuite("WSDLCopierTests");
        suite.addTest((Test)new WSDLCopierTests("testCase1"));
        suite.addTest((Test)new WSDLCopierTests("testCase2"));
        suite.addTest((Test)new WSDLCopierTests("testCase3"));
        suite.addTest((Test)new WSDLCopierTests("testCase4"));
        suite.addTest((Test)new WSDLCopierTests("testCase5"));
        suite.addTest((Test)new WSDLCopierTests("testCase6"));
        return suite;
    }

    public WSDLCopierTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("WSDLCopierTests");
        if (!this.project.exists()) {
            this.project.create(null);
        }
        if (!this.project.isOpen()) {
            this.project.open(null);
        }
    }

    protected IFolder createFolder(String name) throws CoreException {
        IFolder folder = this.project.getFolder((IPath)new Path(name));
        folder.create(false, true, null);
        return folder;
    }

    private void validate(IFolder folder, String filename) {
        WSDLCopierTests.assertNotNull((Object)folder.findMember("1/2/3/test.wsdl"));
        WSDLCopierTests.assertNotNull((Object)folder.findMember("1/2a/" + filename));
        WSDLCopierTests.assertNotNull((Object)folder.findMember("1/2a/test.xsd"));
        WSDLCopierTests.assertNotNull((Object)folder.findMember("test.xsd"));
    }

    private long[] validateTimestamps(IFolder folder, long[] oldTimestamps) {
        long[] currentTimestamps = new long[3];
        currentTimestamps[0] = folder.findMember("1/2/3/test.wsdl").getModificationStamp();
        if (oldTimestamps != null) {
            WSDLCopierTests.assertEquals((long)currentTimestamps[0], (long)oldTimestamps[0]);
        }
        currentTimestamps[1] = folder.findMember("1/2a/test.xsd").getModificationStamp();
        if (oldTimestamps != null) {
            WSDLCopierTests.assertEquals((long)currentTimestamps[1], (long)oldTimestamps[1]);
        }
        currentTimestamps[2] = folder.findMember("test.xsd").getModificationStamp();
        if (oldTimestamps != null) {
            WSDLCopierTests.assertEquals((long)currentTimestamps[2], (long)oldTimestamps[2]);
        }
        return currentTimestamps;
    }

    public void testCase1() {
        try {
            URL url = TestsPlugin.getDefault().getBundle().getEntry("data/wsdlcopier/1/2a/start.wsdl");
            url = FileLocator.toFileURL((URL)url);
            IFolder folder = this.createFolder(WSDL_FOLDER1);
            String folderURI = "platform:/resource" + folder.getFullPath();
            System.out.println("Copying from: " + url);
            System.out.println("Copying to:   " + folderURI);
            WSDLCopier copier = new WSDLCopier();
            copier.setSourceURI(url.toString());
            copier.setTargetFolderURI(folderURI);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.validate(folder, "start.wsdl");
            WSDLCopierTests.assertEquals((String)copier.getRelativePath().toString(), (String)"1/2a/start.wsdl");
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    public void testCase2() {
        try {
            IResource resource = this.project.getFolder(WSDL_FOLDER1).findMember("1/2a/start.wsdl");
            IFolder folder = this.createFolder(WSDL_FOLDER2);
            String path = "platform:/resource" + resource.getFullPath();
            String folderURI = folder.getLocationURI().toString();
            System.out.println("Copying from: " + path);
            System.out.println("Copying to:   " + folderURI);
            WSDLCopier copier = new WSDLCopier();
            copier.setSourceURI(path);
            copier.setTargetFolderURI(folderURI);
            copier.setTargetFilename("newname.wsdl");
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.validate(folder, "newname.wsdl");
            WSDLCopierTests.assertEquals((String)copier.getRelativePath().toString(), (String)"1/2a/newname.wsdl");
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    public void testCase3() {
        try {
            IFolder folder = this.createFolder(WSDL_FOLDER3);
            String folderURI = folder.getLocationURI().toString();
            System.out.println("Copying from: N/A");
            System.out.println("Copying to:   " + folderURI);
            WSDLCopier copier = new WSDLCopier();
            copier.setTargetFolderURI(folderURI);
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
                WSDLCopierTests.assertTrue((String)"Should not get here", (boolean)false);
            }
            catch (CoreException ce) {
                System.out.println((Object)ce);
            }
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    public void testCase4() {
        try {
            IResource resource = this.project.getFolder(WSDL_FOLDER1).findMember("1/2a/start.wsdl");
            IFolder folder = this.project.getFolder(WSDL_FOLDER4);
            String path = resource.getLocationURI().toString();
            String folderURI = "platform:/resource" + folder.getFullPath();
            System.out.println("Copying from: " + path);
            System.out.println("Copying to:   " + folderURI);
            WSDLCopierTests.assertTrue((!folder.exists() ? 1 : 0) != 0);
            WSDLCopier copier = new WSDLCopier();
            copier.setSourceURI(path);
            copier.setTargetFolderURI(folderURI);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            WSDLCopierTests.assertTrue((boolean)folder.exists());
            this.validate(folder, "start.wsdl");
            WSDLCopierTests.assertEquals((String)copier.getRelativePath().toString(), (String)"1/2a/start.wsdl");
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    public void testCase5() {
        try {
            IResource resource = this.project.getFolder(WSDL_FOLDER1).findMember("1/2a/start.wsdl");
            String path = "platform:/resource" + resource.getFullPath();
            System.out.println("Copying from: " + path);
            System.out.println("Copying to:   N/A");
            WSDLCopier copier = new WSDLCopier();
            copier.setSourceURI(path);
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
                WSDLCopierTests.assertTrue((String)"Should not get here", (boolean)false);
            }
            catch (CoreException ce) {
                System.out.println((Object)ce);
            }
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    public void testCase6() {
        try {
            IFolder folder = this.project.getFolder(WSDL_FOLDER1);
            IResource resource = folder.findMember("1/2a/start.wsdl");
            String path = "platform:/resource" + resource.getFullPath();
            String folderURI = folder.getLocationURI().toString();
            System.out.println("Copying from: " + path);
            System.out.println("Copying to:   " + folderURI);
            WSDLCopier copier = new WSDLCopier();
            copier.setSourceURI(path);
            copier.setTargetFolderURI(folderURI);
            long[] oldTimestamps = this.validateTimestamps(folder, null);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)copier, null);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.validate(folder, "start.wsdl");
            this.validateTimestamps(folder, oldTimestamps);
            WSDLCopierTests.assertEquals((String)copier.getRelativePath().toString(), (String)"1/2a/start.wsdl");
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.out.println(e);
            WSDLCopierTests.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }
}

