/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.TemporalType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmIdMappingTests
extends ContextModelTestCase {
    public OrmIdMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private void createColumnAnnotation() throws Exception {
        this.createAnnotationAndMembers("Column", "String name() default \"\";boolean unique() default false;boolean nullable() default true;boolean insertable() default true;boolean updatable() default true;String columnDefinition() default \"\";String table() default \"\";int length() default 255;int precision() default 0;int scale() default 0;");
    }

    private void createTemporalAnnotation() throws Exception {
        this.createAnnotationAndMembers("Temporal", "TemporalType value();");
    }

    private void createGeneratedValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("GeneratedValue", "GenerationType strategy() default AUTO;String generator() default \"\"; ");
    }

    private void createSequenceGeneratorAnnotation() throws Exception {
        this.createAnnotationAndMembers("SequenceGenerator", "String name();String sequenceName() default \"\"; int initialValue() default 0; int allocationSize() default 50;");
    }

    private void createTableGeneratorAnnotation() throws Exception {
        this.createAnnotationAndMembers("TableGenerator", "String name(); String table() default \"\"; String catalog() default \"\"; String schema() default \"\";String pkColumnName() default \"\"; String valueColumnName() default \"\"; String pkColumnValue() default \"\"; int initialValue() default 0; int allocationSize() default 50; UniqueConstraint[] uniqueConstraints() default {};");
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        this.createColumnAnnotation();
        this.createTemporalAnnotation();
        this.createGeneratedValueAnnotation();
        this.createSequenceGeneratorAnnotation();
        this.createTableGeneratorAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column", "javax.persistence.Temporal", "javax.persistence.TemporalType", "javax.persistence.GeneratedValue", "javax.persistence.GenerationType", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
                sb.append(CR);
                sb.append("    @GeneratedValue(strategy=GenerationType.TABLE, generator=\"myTableGenerator\")");
                sb.append(CR);
                sb.append("    @TableGenerator(name=\"myTableGenerator\", table=\"myTable\", catalog=\"myCatalog\", schema=\"mySchema\", pkColumnName=\"myPkColumnName\", valueColumnName=\"myValueColumnName\", pkColumnValue=\"myPkColumnValue\", initialValue=1, allocationSize=1)");
                sb.append(CR);
                sb.append("    @SequenceGenerator(name=\"mySequenceGenerator\")");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)idResource.getName());
        idResource.setName("newName");
        OrmIdMappingTests.assertEquals((String)"newName", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"newName", (String)idResource.getName());
        idResource.setName(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)idResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)idResource.getName());
        ormIdMapping.setName("newName");
        OrmIdMappingTests.assertEquals((String)"newName", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"newName", (String)idResource.getName());
        ormIdMapping.setName(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)idResource.getName());
    }

    public void testUpdateTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.DATE);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertEquals((Object)TemporalType.DATE, (Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.TIME);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.TIMESTAMP);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)idResource.getTemporal());
        idResource.setTemporal(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        ormIdMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.DATE);
        OrmIdMappingTests.assertEquals((Object)TemporalType.DATE, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)ormIdMapping.getTemporal());
        ormIdMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)ormIdMapping.getTemporal());
        ormIdMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIMESTAMP);
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormIdMapping.getTemporal());
        ormIdMapping.setTemporal(null);
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
    }

    public void testAddSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        ormIdMapping.addSequenceGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getSequenceGenerator());
        try {
            ormIdMapping.addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        ormIdMapping.addSequenceGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getSequenceGenerator());
        ormIdMapping.removeSequenceGenerator();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        try {
            ormIdMapping.removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        idResource.setSequenceGenerator((XmlSequenceGenerator)OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        ormIdMapping.getSequenceGenerator().setName("foo");
        OrmIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        idResource.setSequenceGenerator(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
    }

    public void testAddTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        ormIdMapping.addTableGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getTableGenerator());
        try {
            ormIdMapping.addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        ormIdMapping.addTableGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getTableGenerator());
        ormIdMapping.removeTableGenerator();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        try {
            ormIdMapping.removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        idResource.setTableGenerator((XmlTableGenerator)OrmFactory.eINSTANCE.createXmlTableGeneratorImpl());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        ormIdMapping.getTableGenerator().setName("foo");
        OrmIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
        idResource.setTableGenerator(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)ormIdMapping.getPersistenceUnit().allGenerators()));
    }

    public void testAddGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        ormIdMapping.addGeneratedValue();
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        try {
            ormIdMapping.addGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        ormIdMapping.addGeneratedValue();
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        ormIdMapping.removeGeneratedValue();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        try {
            ormIdMapping.removeGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        idResource.setGeneratedValue((XmlGeneratedValue)OrmFactory.eINSTANCE.createXmlGeneratedValueImpl());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        idResource.setGeneratedValue(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
    }

    public void testIdMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedPersistentAttribute("id", "foo");
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"foo", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmIdMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getDefaultUnique());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultNullable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultInsertable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultUpdatable());
        OrmIdMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmIdMappingTests.assertEquals((Object)255, (Object)ormColumn.getDefaultLength());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultPrecision());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)ormIdMapping.getTemporal());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertEquals((String)"MY_COLUMN", (String)ormColumn.getSpecifiedName());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmIdMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"MY_TABLE", (String)ormColumn.getSpecifiedTable());
        OrmIdMappingTests.assertEquals((Object)5, (Object)ormColumn.getSpecifiedLength());
        OrmIdMappingTests.assertEquals((Object)6, (Object)ormColumn.getSpecifiedPrecision());
        OrmIdMappingTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedScale());
        OrmGeneratedValue ormGeneratedValue = ormIdMapping.getGeneratedValue();
        OrmIdMappingTests.assertEquals((String)"myTableGenerator", (String)ormGeneratedValue.getSpecifiedGenerator());
        OrmIdMappingTests.assertEquals((Object)GenerationType.TABLE, (Object)ormGeneratedValue.getSpecifiedStrategy());
        OrmTableGenerator ormTableGenerator = ormIdMapping.getTableGenerator();
        OrmIdMappingTests.assertEquals((String)"myTableGenerator", (String)ormTableGenerator.getName());
        OrmIdMappingTests.assertEquals((String)"myTable", (String)ormTableGenerator.getSpecifiedTable());
        OrmIdMappingTests.assertEquals((String)"myCatalog", (String)ormTableGenerator.getSpecifiedCatalog());
        OrmIdMappingTests.assertEquals((String)"mySchema", (String)ormTableGenerator.getSpecifiedSchema());
        OrmIdMappingTests.assertEquals((String)"myPkColumnName", (String)ormTableGenerator.getSpecifiedPkColumnName());
        OrmIdMappingTests.assertEquals((String)"myPkColumnValue", (String)ormTableGenerator.getSpecifiedPkColumnValue());
        OrmIdMappingTests.assertEquals((String)"myValueColumnName", (String)ormTableGenerator.getSpecifiedValueColumnName());
        OrmIdMappingTests.assertEquals((Object)1, (Object)ormTableGenerator.getSpecifiedInitialValue());
        OrmIdMappingTests.assertEquals((Object)1, (Object)ormTableGenerator.getSpecifiedAllocationSize());
        OrmSequenceGenerator ormSequenceGenerator = ormIdMapping.getSequenceGenerator();
        OrmIdMappingTests.assertEquals((String)"mySequenceGenerator", (String)ormSequenceGenerator.getName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmIdMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified("id");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormColumn.getName());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getUnique());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getNullable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getInsertable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getTable());
        OrmIdMappingTests.assertEquals((Object)255, (Object)ormColumn.getLength());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getPrecision());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTemporal());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmIdMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getDefaultUnique());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultNullable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultInsertable());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getDefaultUpdatable());
        OrmIdMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmIdMappingTests.assertEquals((Object)255, (Object)ormColumn.getDefaultLength());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultPrecision());
        OrmIdMappingTests.assertEquals((Object)0, (Object)ormColumn.getDefaultScale());
    }

    public void testIdMorphToBasicMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((BasicMapping)ormPersistentAttribute.getMapping()).getTemporal());
        OrmIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testIdMorphToVersionMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((VersionMapping)ormPersistentAttribute.getMapping()).getTemporal());
        OrmIdMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testIdMorphToTransientMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToOneToOneMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToOneToManyMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToManyToOneMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToManyToManyMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }
}

