/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmJoinColumnTests
extends ContextModelTestCase {
    public OrmJoinColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getName());
        joinColumnResource.setName("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getName());
        joinColumnResource.setName(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getName());
        joinColumnResource.setName("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getName());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getName());
        joinColumn.setSpecifiedName("foo");
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumnResource.getName());
        joinColumn.setSpecifiedName(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
    }

    public void testUpdateSpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getReferencedColumnName());
        joinColumnResource.setReferencedColumnName("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getReferencedColumnName());
        joinColumnResource.setReferencedColumnName(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getReferencedColumnName());
        joinColumnResource.setReferencedColumnName("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getReferencedColumnName());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getReferencedColumnName());
        joinColumn.setSpecifiedReferencedColumnName("foo");
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumnResource.getReferencedColumnName());
        joinColumn.setSpecifiedReferencedColumnName(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getReferencedColumnName());
    }

    public void testUpdateSpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getColumnDefinition());
        joinColumnResource.setColumnDefinition("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getColumnDefinition());
        joinColumnResource.setColumnDefinition(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getColumnDefinition());
        joinColumnResource.setColumnDefinition("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getColumnDefinition());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getColumnDefinition());
        joinColumn.setColumnDefinition("foo");
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumnResource.getColumnDefinition());
        joinColumn.setColumnDefinition(null);
        OrmJoinColumnTests.assertNull((Object)joinColumn.getColumnDefinition());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getColumnDefinition());
    }

    public void testUpdateSpecifiedTable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getTable());
        joinColumnResource.setTable("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getTable());
        joinColumnResource.setTable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getTable());
        joinColumnResource.setTable("FOO");
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertEquals((String)"FOO", (String)joinColumnResource.getTable());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedTable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getTable());
        ormJoinColumn.setSpecifiedTable("foo");
        OrmJoinColumnTests.assertEquals((String)"foo", (String)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertEquals((String)"foo", (String)joinColumnResource.getTable());
        ormJoinColumn.setSpecifiedTable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedTable());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getTable());
    }

    public void testUpdateSpecifiedNullable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getNullable());
        joinColumnResource.setNullable(Boolean.TRUE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumnResource.getNullable());
        joinColumnResource.setNullable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getNullable());
        joinColumnResource.setNullable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getNullable());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedNullable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getNullable());
        ormJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getNullable());
        ormJoinColumn.setSpecifiedNullable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedNullable());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getNullable());
    }

    public void testUpdateSpecifiedUpdatable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUpdatable());
        joinColumnResource.setUpdatable(Boolean.TRUE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumnResource.getUpdatable());
        joinColumnResource.setUpdatable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUpdatable());
        joinColumnResource.setUpdatable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getUpdatable());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedUpdatable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUpdatable());
        ormJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getUpdatable());
        ormJoinColumn.setSpecifiedUpdatable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getUpdatable());
    }

    public void testUpdateSpecifiedInsertable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getInsertable());
        joinColumnResource.setInsertable(Boolean.TRUE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumnResource.getInsertable());
        joinColumnResource.setInsertable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getInsertable());
        joinColumnResource.setInsertable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getInsertable());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedInsertable() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getInsertable());
        ormJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getInsertable());
        ormJoinColumn.setSpecifiedInsertable(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedInsertable());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getInsertable());
    }

    public void testUpdateSpecifiedUnique() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUnique());
        joinColumnResource.setUnique(Boolean.TRUE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumnResource.getUnique());
        joinColumnResource.setUnique(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUnique());
        joinColumnResource.setUnique(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getUnique());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinColumnTests.assertFalse((boolean)ormJoinTable.specifiedJoinColumns().hasNext());
        OrmJoinColumnTests.assertTrue((boolean)joinTableResource.getJoinColumns().isEmpty());
    }

    public void testModifySpecifiedUnique() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTable ormJoinTable = ormManyToManyMapping.getJoinTable();
        OrmJoinColumn ormJoinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlJoinColumn joinColumnResource = (XmlJoinColumn)joinTableResource.getJoinColumns().get(0);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertNull((Object)joinColumnResource.getUnique());
        ormJoinColumn.setSpecifiedUnique(Boolean.FALSE);
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumnResource.getUnique());
        ormJoinColumn.setSpecifiedUnique(null);
        OrmJoinColumnTests.assertNull((Object)ormJoinColumn.getSpecifiedUnique());
        OrmJoinColumnTests.assertNull((Object)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getUnique());
    }
}

