/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmOneToManyMappingTests
extends ContextModelTestCase {
    public OrmOneToManyMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)oneToMany.getName());
        oneToMany.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        oneToMany.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"oneToManyMapping", (String)oneToMany.getName());
        ormOneToManyMapping.setName("newName");
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertEquals((String)"newName", (String)oneToMany.getName());
        ormOneToManyMapping.setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getName());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"newTargetEntity", (String)oneToMany.getTargetEntity());
        ormOneToManyMapping.setSpecifiedTargetEntity(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        oneToManyResource.setFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToManyResource = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToManyMapping.getSpecifiedFetch());
        ormOneToManyMapping.setSpecifiedFetch(null);
        OrmOneToManyMappingTests.assertNull((Object)oneToManyResource.getFetch());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
        ormOneToManyMapping.setMappedBy("newMappedBy");
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertEquals((String)"newMappedBy", (String)oneToMany.getMappedBy());
        ormOneToManyMapping.setMappedBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMappedBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMappedBy());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey((MapKey)OrmFactory.eINSTANCE.createMapKeyImpl());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setMapKey("myMapKey");
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setMapKey(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        oneToMany.setOrderBy("newOrderBy");
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToMany.getOrderBy());
        oneToMany.setOrderBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
    }

    public void testModifyOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
        ormOneToManyMapping.setOrderBy("newOrderBy");
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertEquals((String)"newOrderBy", (String)oneToMany.getOrderBy());
        ormOneToManyMapping.setOrderBy(null);
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderBy());
        OrmOneToManyMappingTests.assertNull((Object)oneToMany.getOrderBy());
    }

    public void testIsNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoOrdering());
        ormOneToManyMapping.setOrderBy("foo");
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoOrdering());
        ormOneToManyMapping.setOrderBy(null);
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoOrdering());
    }

    public void testSetNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoOrdering());
        ormOneToManyMapping.setOrderBy("foo");
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoOrdering());
        ormOneToManyMapping.setNoOrdering(true);
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoOrdering());
        OrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getOrderBy());
    }

    public void testIsCustomOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomOrdering());
        ormOneToManyMapping.setOrderBy("foo");
        OrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isCustomOrdering());
        ormOneToManyMapping.setOrderBy(null);
        OrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomOrdering());
    }

    public void testOneToManyMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToManyMorphToOneToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToManyToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertEquals((String)"mappedBy", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getMappedBy());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        JoinTable joinTable = ((ManyToManyMapping)ormPersistentAttribute.getMapping()).getJoinTable();
        OrmOneToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmOneToManyMappingTests.assertEquals((String)"name", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"referenceName", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedReferencedColumnName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedName());
        OrmOneToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedReferencedColumnName());
    }

    public void testOneToManyMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToManyMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentAttribute.getMapping();
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        oneToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToManyMapping.setOrderBy("customOrder");
        oneToManyMapping.setMapKey("mapKey");
        oneToManyMapping.setMappedBy("mappedBy");
        oneToManyMapping.getCascade().setAll(true);
        oneToManyMapping.getCascade().setMerge(true);
        oneToManyMapping.getCascade().setPersist(true);
        oneToManyMapping.getCascade().setRefresh(true);
        oneToManyMapping.getCascade().setRemove(true);
        oneToManyMapping.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = oneToManyMapping.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = oneToManyMapping.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmOneToManyMappingTests.assertFalse((boolean)oneToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmOneToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getName());
    }
}

