/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmSequenceGeneratorTests
extends ContextModelTestCase {
    public OrmSequenceGeneratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGeneratorResource.setName("FOO");
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGenerator.getName());
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGeneratorResource.getName());
        sequenceGeneratorResource.setName(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getName());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getName());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGeneratorResource.getName());
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGenerator.getName());
        sequenceGenerator.setName(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getName());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getName());
    }

    public void testUpdateSpecifiedSequenceName() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGeneratorResource.setSequenceName("FOO");
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGenerator.getSpecifiedSequenceName());
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGeneratorResource.getSequenceName());
        sequenceGeneratorResource.setSequenceName(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedSequenceName());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getSequenceName());
    }

    public void testModifySpecifiedSequenceName() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGenerator.setSpecifiedSequenceName("FOO");
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGeneratorResource.getSequenceName());
        OrmSequenceGeneratorTests.assertEquals((String)"FOO", (String)sequenceGenerator.getSpecifiedSequenceName());
        sequenceGenerator.setSpecifiedSequenceName(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getSequenceName());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedSequenceName());
    }

    public void testUpdateSpecifiedInitialValue() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGeneratorResource.setInitialValue(Integer.valueOf(10));
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGenerator.getSpecifiedInitialValue());
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGeneratorResource.getInitialValue());
        sequenceGeneratorResource.setInitialValue(Integer.valueOf(1));
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGenerator.getSpecifiedInitialValue());
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGeneratorResource.getInitialValue());
        sequenceGeneratorResource.setInitialValue(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedInitialValue());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getInitialValue());
    }

    public void testModifySpecifiedInitialValue() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGenerator.setSpecifiedInitialValue(Integer.valueOf(10));
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGeneratorResource.getInitialValue());
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGenerator.getSpecifiedInitialValue());
        sequenceGenerator.setSpecifiedInitialValue(Integer.valueOf(1));
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGeneratorResource.getInitialValue());
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGenerator.getSpecifiedInitialValue());
        sequenceGenerator.setSpecifiedInitialValue(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getInitialValue());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedInitialValue());
    }

    public void testUpdateSpecifiedAllocationSize() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGeneratorResource.setAllocationSize(Integer.valueOf(10));
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGenerator.getSpecifiedAllocationSize());
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGeneratorResource.getAllocationSize());
        sequenceGeneratorResource.setAllocationSize(Integer.valueOf(1));
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGenerator.getSpecifiedAllocationSize());
        OrmSequenceGeneratorTests.assertEquals((Object)1, (Object)sequenceGeneratorResource.getAllocationSize());
        sequenceGeneratorResource.setAllocationSize(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedAllocationSize());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getAllocationSize());
    }

    public void testModifySpecifiedAllocationSize() throws Exception {
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        XmlSequenceGenerator sequenceGeneratorResource = (XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0);
        sequenceGenerator.setSpecifiedAllocationSize(Integer.valueOf(10));
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGeneratorResource.getAllocationSize());
        OrmSequenceGeneratorTests.assertEquals((Object)10, (Object)sequenceGenerator.getSpecifiedAllocationSize());
        sequenceGenerator.setSpecifiedAllocationSize(Integer.valueOf(50));
        OrmSequenceGeneratorTests.assertEquals((Object)50, (Object)sequenceGeneratorResource.getAllocationSize());
        OrmSequenceGeneratorTests.assertEquals((Object)50, (Object)sequenceGenerator.getSpecifiedAllocationSize());
        sequenceGenerator.setSpecifiedAllocationSize(null);
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGeneratorResource.getAllocationSize());
        OrmSequenceGeneratorTests.assertNull((Object)sequenceGenerator.getSpecifiedAllocationSize());
    }
}

