/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class TableTests
extends JavaResourceModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String SCHEMA_NAME = "MY_SCHEMA";
    private static final String CATALOG_NAME = "MY_CATALOG";

    public TableTests(String name) {
        super(name);
    }

    private void createTableAnnotation() throws Exception {
        this.createUniqueConstraintAnnotation();
        this.createAnnotationAndMembers("Table", "String name() default \"\"; String catalog() default \"\"; String schema() default \"\"; UniqueConstraint[] uniqueConstraints() default {};");
    }

    private void createUniqueConstraintAnnotation() throws Exception {
        this.createAnnotationAndMembers("UniqueConstraint", "String[] columnNames();");
    }

    private ICompilationUnit createTestTable() throws Exception {
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Table");
            }
        });
    }

    private ICompilationUnit createTestTableWithName() throws Exception {
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Table(name=\"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestTableWithSchema() throws Exception {
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Table(schema=\"MY_SCHEMA\")");
            }
        });
    }

    private ICompilationUnit createTestTableWithCatalog() throws Exception {
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Table"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Table(catalog=\"MY_CATALOG\")");
            }
        });
    }

    private ICompilationUnit createTestTableWithUniqueConstraints() throws Exception {
        this.createTableAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Table", "javax.persistence.UniqueConstraint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Table(uniqueConstraints={@UniqueConstraint(columnNames={\"BAR\"}), @UniqueConstraint(columnNames={\"FOO\"}), @UniqueConstraint(columnNames={\"BAZ\"})})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestTableWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertNull((Object)table.getName());
        TableTests.assertNull((Object)table.getCatalog());
        TableTests.assertNull((Object)table.getSchema());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertNull((Object)table.getName());
        table.setName("Foo");
        TableTests.assertEquals((String)"Foo", (String)table.getName());
        this.assertSourceContains("@Table(name=\"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestTableWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setName(null);
        TableTests.assertNull((Object)table.getName());
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        TableTests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@Table(catalog=\"Foo\")", cu);
    }

    public void testSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        TableTests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertNotNull((Object)table);
        TableTests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        TableTests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@Table(schema=\"Foo\")", cu);
    }

    public void testSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        TableTests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertEquals((int)0, (int)table.uniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        TableTests.assertEquals((int)2, (int)table.uniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        TableTests.assertEquals((int)3, (int)table.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        TableTests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        TableTests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        TableTests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).columnNamesSize());
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames=\"BAR\"),@UniqueConstraint(columnNames=\"FOO\"), @UniqueConstraint})", cu);
    }

    public void testAddUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1).addColumnName("BAR");
        table.uniqueConstraintAt(1).addColumnName("BAZ");
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint,@UniqueConstraint(columnNames={ \"BAR\", \"BAZ\" }), @UniqueConstraint(columnNames=\"FOO\")})", cu);
        TableTests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(2).columnNames().next()));
        ListIterator columnNames = table.uniqueConstraintAt(1).columnNames();
        TableTests.assertEquals((String)"BAR", (String)((String)columnNames.next()));
        TableTests.assertEquals((String)"BAZ", (String)((String)columnNames.next()));
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.removeUniqueConstraint(1);
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames={\"BAR\"}), @UniqueConstraint(columnNames={\"BAZ\"})})", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceContains("@Table(uniqueConstraints=@UniqueConstraint(columnNames={\"BAZ\"}))", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testRemoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1).addColumnName("BAR");
        table.addUniqueConstraint(2).addColumnName("BAZ");
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames=\"FOO\"),@UniqueConstraint(columnNames=\"BAR\"), @UniqueConstraint(columnNames=\"BAZ\")})", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames=\"BAR\"),@UniqueConstraint(columnNames=\"BAZ\")})", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceContains("@Table(uniqueConstraints=@UniqueConstraint(columnNames=\"BAZ\"))", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testRemoveUniqueConstraint3() throws Exception {
        ICompilationUnit cu = this.createTestTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1).addColumnName("BAR");
        table.addUniqueConstraint(2).addColumnName("BAZ");
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames=\"FOO\"),@UniqueConstraint(columnNames=\"BAR\"), @UniqueConstraint(columnNames=\"BAZ\")})", cu);
        table.removeUniqueConstraint(2);
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames=\"FOO\"),@UniqueConstraint(columnNames=\"BAR\")})", cu);
        table.removeUniqueConstraint(1);
        this.assertSourceContains("@Table(uniqueConstraints=@UniqueConstraint(columnNames=\"FOO\"))", cu);
        table.removeUniqueConstraint(0);
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames={\"FOO\"}), @UniqueConstraint(columnNames={\"BAZ\"}), @UniqueConstraint(columnNames={\"BAR\"})})", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        TableAnnotation table = (TableAnnotation)typeResource.getAnnotation("javax.persistence.Table");
        table.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@Table(uniqueConstraints={@UniqueConstraint(columnNames={\"BAZ\"}), @UniqueConstraint(columnNames={\"BAR\"}), @UniqueConstraint(columnNames={\"FOO\"})})", cu);
    }
}

