/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByImpl
extends AbstractResourceAnnotation<Attribute>
implements OrderByAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OrderBy");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = OrderByImpl.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    protected OrderByImpl(JavaResourceNode parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, VALUE_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OrderBy";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected String value(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }

    public static class OrderByAnnotationDefinition
    implements AnnotationDefinition {
        private static final OrderByAnnotationDefinition INSTANCE = new OrderByAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private OrderByAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new OrderByImpl(parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.OrderBy";
        }
    }
}

