/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.logging;

import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkJpaProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.EclipseLinkLogging;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logger;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logging;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.LoggingLevel;
import org.eclipse.jpt.eclipselink.core.tests.internal.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class LoggingAdapterTests
extends PersistenceUnitTestCase {
    private Logging logging;
    public static final String LEVEL_KEY = "eclipselink.logging.level";
    public static final LoggingLevel LEVEL_TEST_VALUE = LoggingLevel.fine;
    public static final LoggingLevel LEVEL_TEST_VALUE_2 = LoggingLevel.finest;
    public static final String TIMESTAMP_KEY = "eclipselink.logging.timestamp";
    public static final Boolean TIMESTAMP_TEST_VALUE = false;
    public static final Boolean TIMESTAMP_TEST_VALUE_2 = TIMESTAMP_TEST_VALUE == false;
    public static final String THREAD_KEY = "eclipselink.logging.thread";
    public static final Boolean THREAD_TEST_VALUE = false;
    public static final Boolean THREAD_TEST_VALUE_2 = THREAD_TEST_VALUE == false;
    public static final String SESSION_KEY = "eclipselink.logging.session";
    public static final Boolean SESSION_TEST_VALUE = false;
    public static final Boolean SESSION_TEST_VALUE_2 = SESSION_TEST_VALUE == false;
    public static final String EXCEPTIONS_KEY = "eclipselink.logging.exceptions";
    public static final Boolean EXCEPTIONS_TEST_VALUE = false;
    public static final Boolean EXCEPTIONS_TEST_VALUE_2 = EXCEPTIONS_TEST_VALUE == false;
    private static final String LOG_FILE_LOCATION_KEY = "eclipselink.logging.file";
    private static final String LOG_FILE_LOCATION_TEST_VALUE = "C:/temp";
    private static final String LOG_FILE_LOCATION_TEST_VALUE_2 = "C:/tmp";
    private static final String LOGGER_KEY = "eclipselink.logging.logger";
    private static final Logger LOGGER_TEST_VALUE = Logger.java_logger;
    private static final String LOGGER_TEST_VALUE_2 = "custom.logger.test";

    public LoggingAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.logging = this.persistenceUnitProperties.getLogging();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.logging.addPropertyChangeListener("levelProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("timestampProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("threadProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("sessionProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("exceptionsProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("logFileLocationProperty", propertyChangeListener);
        this.logging.addPropertyChangeListener("loggerProperty", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 7;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut(LEVEL_KEY, LEVEL_TEST_VALUE);
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut(THREAD_KEY, THREAD_TEST_VALUE.toString());
        this.persistenceUnitPut(SESSION_KEY, SESSION_TEST_VALUE.toString());
        this.persistenceUnitPut(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.4", "value.4");
        this.persistenceUnitPut(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE);
        this.persistenceUnitPut(LOGGER_KEY, LOGGER_TEST_VALUE);
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(TIMESTAMP_KEY);
        ListValueModel propertyListAdapter = ((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertyListAdapter();
        LoggingAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        LoggingAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.logging, "timestampProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkLogging elLogging = (EclipseLinkLogging)this.logging;
        PersistenceUnitPropertyListListener propertyListListener = elLogging.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        LoggingAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.logging, "timestampProperty");
    }

    public void testSetLevel() throws Exception {
        this.verifyModelInitialized(LEVEL_KEY, LEVEL_TEST_VALUE);
        this.verifySetProperty(LEVEL_KEY, LEVEL_TEST_VALUE, LEVEL_TEST_VALUE_2);
    }

    public void testAddRemoveLevel() throws Exception {
        this.verifyAddRemoveProperty(LEVEL_KEY, LEVEL_TEST_VALUE, LEVEL_TEST_VALUE_2);
    }

    public void testSetThrowExceptions() throws Exception {
        this.verifyModelInitialized(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE);
        this.verifySetProperty(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE, TIMESTAMP_TEST_VALUE_2);
    }

    public void testAddRemoveThrowExceptions() throws Exception {
        this.verifyAddRemoveProperty(TIMESTAMP_KEY, TIMESTAMP_TEST_VALUE, TIMESTAMP_TEST_VALUE_2);
    }

    public void testSetThread() throws Exception {
        this.verifyModelInitialized(THREAD_KEY, THREAD_TEST_VALUE);
        this.verifySetProperty(THREAD_KEY, THREAD_TEST_VALUE, THREAD_TEST_VALUE_2);
    }

    public void testAddRemoveThread() throws Exception {
        this.verifyAddRemoveProperty(THREAD_KEY, THREAD_TEST_VALUE, THREAD_TEST_VALUE_2);
    }

    public void testSetSession() throws Exception {
        this.verifyModelInitialized(SESSION_KEY, SESSION_TEST_VALUE);
        this.verifySetProperty(SESSION_KEY, SESSION_TEST_VALUE, SESSION_TEST_VALUE_2);
    }

    public void testAddRemoveSession() throws Exception {
        this.verifyAddRemoveProperty(SESSION_KEY, SESSION_TEST_VALUE, SESSION_TEST_VALUE_2);
    }

    public void testSetExceptions() throws Exception {
        this.verifyModelInitialized(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE);
        this.verifySetProperty(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE, EXCEPTIONS_TEST_VALUE_2);
    }

    public void testAddRemoveExceptions() throws Exception {
        this.verifyAddRemoveProperty(EXCEPTIONS_KEY, EXCEPTIONS_TEST_VALUE, EXCEPTIONS_TEST_VALUE_2);
    }

    public void testSetLogFileLocation() throws Exception {
        this.verifyModelInitialized(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE);
        this.verifySetProperty(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE, LOG_FILE_LOCATION_TEST_VALUE_2);
    }

    public void testAddRemoveLogFileLocation() throws Exception {
        this.verifyAddRemoveProperty(LOG_FILE_LOCATION_KEY, LOG_FILE_LOCATION_TEST_VALUE, LOG_FILE_LOCATION_TEST_VALUE_2);
    }

    public void testSetLogger() throws Exception {
        this.verifyModelInitialized(LOGGER_KEY, this.getEclipseLinkStringValueOf(LOGGER_TEST_VALUE));
        this.verifySetProperty(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
        this.verifySetLogger(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
    }

    public void testAddRemoveLogger() throws Exception {
        this.verifyAddRemoveProperty(LOGGER_KEY, LOGGER_TEST_VALUE, LOGGER_TEST_VALUE_2);
    }

    protected void verifySetLogger(String elKey, Object testValue1, Object testValue2) throws Exception {
        Property property = this.persistenceUnit().getProperty(elKey);
        String propertyName = this.model().propertyIdFor(property);
        this.clearEvent();
        this.setProperty(propertyName, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.logging.setLogger(null);
        LoggingAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, null);
        this.clearEvent();
        this.setProperty(propertyName, testValue1.toString());
        LoggingAdapterTests.assertTrue((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, this.getEclipseLinkStringValueOf(testValue1));
        this.clearEvent();
        this.logging.setLogger(null);
        LoggingAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(elKey));
        this.verifyPutProperty(propertyName, null);
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("levelProperty")) {
            this.logging.setLevel((LoggingLevel)newValue);
        } else if (propertyName.equals("timestampProperty")) {
            this.logging.setTimestamp((Boolean)newValue);
        } else if (propertyName.equals("threadProperty")) {
            this.logging.setThread((Boolean)newValue);
        } else if (propertyName.equals("sessionProperty")) {
            this.logging.setSession((Boolean)newValue);
        } else if (propertyName.equals("exceptionsProperty")) {
            this.logging.setExceptions((Boolean)newValue);
        } else if (propertyName.equals("logFileLocationProperty")) {
            this.logging.setLogFileLocation((String)newValue);
        } else if (propertyName.equals("loggerProperty")) {
            if (newValue.getClass().isEnum()) {
                this.logging.setLogger((Logger)newValue);
            } else {
                this.logging.setLogger((String)newValue);
            }
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("levelProperty")) {
            modelValue = this.logging.getLevel();
        } else if (propertyName.equals("timestampProperty")) {
            modelValue = this.logging.getTimestamp();
        } else if (propertyName.equals("threadProperty")) {
            modelValue = this.logging.getThread();
        } else if (propertyName.equals("sessionProperty")) {
            modelValue = this.logging.getSession();
        } else if (propertyName.equals("exceptionsProperty")) {
            modelValue = this.logging.getExceptions();
        } else if (propertyName.equals("logFileLocationProperty")) {
            modelValue = this.logging.getLogFileLocation();
        } else if (propertyName.equals("loggerProperty")) {
            modelValue = this.logging.getLogger();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        Object expectedValue_ = expectedValue;
        if (propertyName.equals("loggerProperty")) {
            expectedValue_ = expectedValue != null && expectedValue.getClass().isEnum() ? this.getEclipseLinkStringValueOf(LOGGER_TEST_VALUE) : expectedValue;
        }
        super.verifyPutProperty(propertyName, expectedValue_);
    }

    protected PersistenceUnitProperties model() {
        return this.logging;
    }
}

