/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ClasspathDecorationsManager {
    private final File f;
    private final HashMap decorations;

    public ClasspathDecorationsManager(String plugin) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        File wsdir = ws.getRoot().getLocation().toFile();
        File wsmdroot = new File(wsdir, ".metadata/.plugins");
        File pmdroot = new File(wsmdroot, plugin);
        this.f = new File(pmdroot, "classpath.decorations.xml");
        this.decorations = this.read();
    }

    public ClasspathDecorations getDecorations(String key, String entry) {
        HashMap submap = (HashMap)this.decorations.get(key);
        if (submap == null) {
            return null;
        }
        return (ClasspathDecorations)submap.get(entry);
    }

    public void setDecorations(String key, String entry, ClasspathDecorations dec) {
        HashMap<String, ClasspathDecorations> submap = (HashMap<String, ClasspathDecorations>)this.decorations.get(key);
        if (submap == null) {
            submap = new HashMap<String, ClasspathDecorations>();
            this.decorations.put(key, submap);
        }
        submap.put(entry, dec);
    }

    public void clearAllDecorations(String key) {
        this.decorations.remove(key);
    }

    public void save() {
        File folder = this.f.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            return;
        }
        PrintWriter w = null;
        try {
            try {
                w = new PrintWriter(new BufferedWriter(new FileWriter(this.f)));
                w.println("<classpath>");
                for (Map.Entry entry1 : this.decorations.entrySet()) {
                    Map submap = (Map)entry1.getValue();
                    w.print("  <container id=\"");
                    w.print((String)entry1.getKey());
                    w.println("\">");
                    for (Map.Entry entry2 : submap.entrySet()) {
                        ClasspathDecorations dec = (ClasspathDecorations)entry2.getValue();
                        w.print("    <entry id=\"");
                        w.print((String)entry2.getKey());
                        w.println("\">");
                        if (dec.getSourceAttachmentPath() != null) {
                            w.print("      <source-attachment-path>");
                            w.print(dec.getSourceAttachmentPath().toString());
                            w.println("</source-attachment-path>");
                        }
                        if (dec.getSourceAttachmentRootPath() != null) {
                            w.print("      <source-attachment-root-path>");
                            w.print(dec.getSourceAttachmentRootPath().toString());
                            w.println("</source-attachment-root-path>");
                        }
                        IClasspathAttribute[] attrs = dec.getExtraAttributes();
                        int i = 0;
                        while (i < attrs.length) {
                            IClasspathAttribute attr = attrs[i];
                            w.print("      <attribute name=\"");
                            w.print(attr.getName());
                            w.print("\">");
                            w.print(attr.getValue());
                            w.println("</attribute>");
                            ++i;
                        }
                        w.println("    </entry>");
                    }
                    w.println("  </container>");
                }
                w.println("</classpath>");
            }
            catch (IOException e) {
                CommonFrameworksPlugin.log(e);
                w.close();
            }
        }
        finally {
            w.close();
        }
    }

    private HashMap read() {
        HashMap map = new HashMap();
        if (!this.f.exists()) {
            return map;
        }
        InputStream in = null;
        Element root = null;
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docbuilder = factory.newDocumentBuilder();
                in = new BufferedInputStream(new FileInputStream(this.f));
                root = docbuilder.parse(in).getDocumentElement();
            }
            catch (Exception e) {
                CommonFrameworksPlugin.log(e);
                HashMap hashMap = map;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        Iterator itr1 = ClasspathDecorationsManager.elements(root, "container");
        while (itr1.hasNext()) {
            Element e1 = (Element)itr1.next();
            String cid = e1.getAttribute("id");
            HashMap<String, ClasspathDecorations> submap = new HashMap<String, ClasspathDecorations>();
            map.put(cid, submap);
            Iterator itr2 = ClasspathDecorationsManager.elements(e1, "entry");
            while (itr2.hasNext()) {
                Element e2 = (Element)itr2.next();
                String eid = e2.getAttribute("id");
                ClasspathDecorations dec = new ClasspathDecorations();
                submap.put(eid, dec);
                Iterator itr3 = ClasspathDecorationsManager.elements(e2);
                while (itr3.hasNext()) {
                    Element e3 = (Element)itr3.next();
                    String n = e3.getNodeName();
                    if (n.equals("source-attachment-path")) {
                        dec.setSourceAttachmentPath((IPath)new Path(ClasspathDecorationsManager.text(e3)));
                        continue;
                    }
                    if (n.equals("source-attachment-root-path")) {
                        dec.setSourceAttachmentRootPath((IPath)new Path(ClasspathDecorationsManager.text(e3)));
                        continue;
                    }
                    if (!n.equals("attribute")) continue;
                    String name = e3.getAttribute("name");
                    dec.addExtraAttribute(name, ClasspathDecorationsManager.text(e3));
                }
            }
        }
        return map;
    }

    private static String text(Element el) {
        NodeList nodes = el.getChildNodes();
        String str = null;
        StringBuffer buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuffer();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str;
    }

    private static Iterator elements(Element el, String name) {
        return new ElementsIterator(el, name);
    }

    private static Iterator elements(Element el) {
        return new ElementsIterator(el, null);
    }

    private static final class ElementsIterator
    implements Iterator {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(Element parent, String name) {
            this.nodes = parent.getChildNodes();
            this.length = this.nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || node.getNodeName().equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        public boolean hasNext() {
            return this.element != null;
        }

        public Object next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

