/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenAction;
import org.eclipse.jst.j2ee.internal.actions.ComponentEditorInput;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.ejb.provider.J2EEJavaClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.BinaryEditorUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class OpenJ2EEResourceAction
extends AbstractOpenAction {
    public static final String ID = "org.eclipse.jst.j2ee.internal.internal.ui.actions.OpenJ2EEResourceAction";
    public static final String JAVA_EDITOR_ID = "org.eclipse.jst.j2ee.internal.internal.ejb.ui.java.EnterpriseBeanJavaEditor";
    public static final String BASE_JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    protected static IEditorDescriptor javaEditorDescriptor;
    protected static IEditorDescriptor baseJavaEditorDescriptor;

    public OpenJ2EEResourceAction() {
        super("Open");
    }

    public String getID() {
        return ID;
    }

    public static IEditorDescriptor getJavaEditorDescriptor() {
        if (javaEditorDescriptor == null) {
            javaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(JAVA_EDITOR_ID);
        }
        return javaEditorDescriptor;
    }

    public static IEditorDescriptor getBaseJavaEditorDescriptor() {
        if (baseJavaEditorDescriptor == null) {
            baseJavaEditorDescriptor = OpenJ2EEResourceAction.findEditorDescriptor(BASE_JAVA_EDITOR_ID);
        }
        return baseJavaEditorDescriptor;
    }

    protected void openAppropriateEditor(IVirtualComponent c) {
        if (c == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            JavaEEQuickPeek qp;
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ComponentEditorInput editorInput = null;
            if (c instanceof VirtualArchiveComponent && ((qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)c)).getJavaEEVersion() == 50 || qp.getType() == 2)) {
                String path = ((EObject)this.srcObject).eResource().getURI().toString();
                editorInput = BinaryEditorUtilities.getBinaryEditorInput((VirtualArchiveComponent)c, path);
            }
            if (editorInput == null) {
                editorInput = new ComponentEditorInput(c);
            }
            if ((editor = page.openEditor((IEditorInput)editorInput, this.currentDescriptor.getId())) instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IResource r) {
        if (r == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            editor = page.openEditor((IEditorInput)new FileEditorInput((IFile)r), this.currentDescriptor.getId());
            if (editor instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString("Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.srcObject instanceof J2EEJavaClassProviderHelper) {
            ((J2EEJavaClassProviderHelper)this.srcObject).openInEditor();
            return;
        }
        if (this.isEJB3BeanObject(this.srcObject)) {
            SessionBean bean;
            String name = "";
            if (this.srcObject instanceof SessionBean) {
                bean = (SessionBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof MessageDrivenBean) {
                bean = (MessageDrivenBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof EntityBean) {
                bean = (EntityBean)this.srcObject;
                name = bean.getEjbClass();
            }
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)this.srcObject));
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject.exists()) {
                IType type = null;
                try {
                    if (name != null) {
                        type = javaProject.findType(name);
                    }
                    if (type != null) {
                        ICompilationUnit cu = type.getCompilationUnit();
                        EditorUtility.openInEditor((Object)cu);
                    } else {
                        this.openAppropriateEditor((IResource)resource);
                    }
                }
                catch (JavaModelException e) {
                    J2EEUIPlugin.logError(-1, e.getMessage(), e);
                }
                catch (PartInitException e) {
                    J2EEUIPlugin.logError(-1, e.getMessage(), e);
                }
            }
            return;
        }
        if (this.srcObject instanceof EObject) {
            EObject ro = (EObject)this.srcObject;
            IProject p = ProjectUtilities.getProject((EObject)ro);
            if (ro instanceof BeanLink) {
                this.openBeanLinkInJavaEditor((BeanLink)ro, p);
                return;
            }
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)this.srcObject));
            if (resource != null && resource.exists()) {
                this.openAppropriateEditor((IResource)resource);
            } else if (ro.eResource() != null) {
                ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)ro);
                if (moduleFile != null) {
                    ArchiveOptions options = moduleFile.getOptions();
                    if (options instanceof ComponentArchiveOptions) {
                        IVirtualComponent component = ((ComponentArchiveOptions)options).getComponent();
                        this.openAppropriateEditor(component);
                    }
                } else {
                    IVirtualComponent component;
                    IArchive archive = JavaEEArchiveUtilities.findArchive((Object)ro);
                    if (archive != null && (component = JavaEEArchiveUtilities.findComponent((IArchive)archive)) != null) {
                        this.openAppropriateEditor(component);
                    }
                }
            }
        } else if (this.srcObject instanceof Resource) {
            this.openAppropriateEditor((IResource)WorkbenchResourceHelper.getFile((Resource)((Resource)this.srcObject)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateSelection(IStructuredSelection s) {
        block21: {
            block24: {
                block25: {
                    block26: {
                        block23: {
                            block22: {
                                if (!super.updateSelection(s)) {
                                    return false;
                                }
                                obj = s.getFirstElement();
                                if (!(obj instanceof J2EEJavaClassProviderHelper)) break block22;
                                this.currentDescriptor = OpenJ2EEResourceAction.getJavaEditorDescriptor();
                                break block21;
                            }
                            if (!(obj instanceof BeanLink)) break block23;
                            this.currentDescriptor = OpenJ2EEResourceAction.getBaseJavaEditorDescriptor();
                            break block21;
                        }
                        if (this.isEJB3BeanObject(obj)) break block21;
                        if (!(obj instanceof EObject)) break block24;
                        registry = PlatformUI.getWorkbench().getEditorRegistry();
                        file = WorkbenchResourceHelper.getFile((EObject)((EObject)obj));
                        if (file == null) break block25;
                        isJavaEEDDFile = this.isJavaEEDDFile((EObject)obj);
                        isParentJavaEEDDFile = this.isJavaEEDDFile(this.getRootObject(obj));
                        if ((!isJavaEEDDFile || !file.exists()) && (!isParentJavaEEDDFile || !file.exists())) break block26;
                        contentType = IDE.getContentType((IFile)file);
                        this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                        break block21;
                    }
                    this.currentDescriptor = null;
                    return false;
                }
                if (((EObject)obj).eResource() == null || (archive = JavaEEArchiveUtilities.findArchive((Object)(eObj = (EObject)obj))) == null || !archive.containsArchiveResource((IPath)(path = new Path(((EObject)obj).eResource().getURI().toString())))) break block21;
                stream = null;
                try {
                    resource = archive.getArchiveResource((IPath)path);
                    stream = resource.getInputStream();
                    type = Platform.getContentTypeManager().findContentTypeFor(stream, path.lastSegment());
                    this.currentDescriptor = registry.getDefaultEditor(path.lastSegment(), type);
                }
                catch (FileNotFoundException e) {
                    J2EEUIPlugin.logError(-1, e.getMessage(), e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            J2EEUIPlugin.logError(-1, e.getMessage(), e);
                        }
                    }
                    break block21;
                }
                catch (IOException e) {
                    try {
                        J2EEUIPlugin.logError(-1, e.getMessage(), e);
                        break block21;
                    }
                    catch (Throwable var11_23) {
                        throw var11_23;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                J2EEUIPlugin.logError(-1, e.getMessage(), e);
                            }
                        }
                    }
                }
                ** if (stream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        J2EEUIPlugin.logError(-1, e.getMessage(), e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                }
            }
            if (obj instanceof Resource) {
                registry = PlatformUI.getWorkbench().getEditorRegistry();
                file = WorkbenchResourceHelper.getFile((Resource)((Resource)obj));
                contentType = IDE.getContentType((IFile)file);
                this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
            } else {
                this.currentDescriptor = null;
                return false;
            }
        }
        this.setAttributesFromDescriptor();
        this.srcObject = obj;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openBeanLinkInJavaEditor(BeanLink link, IProject p) {
        EJBArtifactEdit artifactEdit;
        String linkName = null;
        JavaClass javaClass = null;
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)link);
        if (link instanceof EJBLink) {
            linkName = ((EJBLink)link).getEjbLink();
            artifactEdit = null;
            try {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
                org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = artifactEdit.getEJBJar();
                if (ejbJar == null) {
                    return;
                }
                EnterpriseBean bean = ejbJar.getEnterpriseBeanNamed(linkName);
                if (bean == null) {
                    return;
                }
                javaClass = bean.getEjbClass();
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        linkName = ((ServletLink)link).getServletLink();
        artifactEdit = null;
        try {
            artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = artifactEdit.getWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = webApp.getServletNamed(linkName);
            if (servlet == null) {
                return;
            }
            javaClass = servlet.getServletClass();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        try {
            J2EEEditorUtility.openInEditor(javaClass, p);
            return;
        }
        catch (Exception cantOpen) {
            J2EEUIPlugin.logError(-1, cantOpen.getMessage(), cantOpen);
        }
    }

    protected EObject getRootObject(Object obj) {
        if (obj instanceof EObject) {
            EObject refObj = (EObject)obj;
            while (refObj != null && refObj.eContainer() != null) {
                refObj = refObj.eContainer();
            }
            return refObj;
        }
        return null;
    }

    private boolean isJavaEEDDFile(EObject obj) {
        boolean isDD = obj instanceof EJBJar || obj instanceof WebApp || obj instanceof org.eclipse.jst.javaee.applicationclient.ApplicationClient || obj instanceof org.eclipse.jst.javaee.application.Application || obj instanceof org.eclipse.jst.j2ee.ejb.EJBJar || obj instanceof org.eclipse.jst.j2ee.webapplication.WebApp || obj instanceof ApplicationClient || obj instanceof Connector || obj instanceof Application;
        return isDD;
    }

    private boolean isEJB3BeanObject(Object obj) {
        boolean isBean = obj instanceof SessionBean || obj instanceof MessageDrivenBean || obj instanceof EntityBean;
        return isBean;
    }
}

