/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.test.util.TestUtil;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class FacesConfigEditorTest
extends TestCase {
    public IProject project;
    public FacesConfigEditor editor;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this.project = TestUtil.createProjectFromZip("emptyjsfproject", "emptyjsfproject.zip");
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor j2eePersp = reg.findPerspectiveWithId("org.eclipse.jst.j2ee.J2EEPerspective");
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(j2eePersp);
        this.openEditor();
    }

    protected void openEditor() throws PartInitException, InterruptedException {
        this.editor = (FacesConfigEditor)this.openWithEditor("WebContent/WEB-INF/faces-config.xml");
        this.editor.doPageLoad(60000L);
    }

    protected IEditorPart openWithEditor(String name) throws PartInitException {
        Path filePath = new Path(name);
        IFile facesConfigFile = this.project.getFile((IPath)filePath);
        FacesConfigEditorTest.assertNotNull((Object)facesConfigFile);
        FacesConfigEditorTest.assertTrue((String)"The facesconfig file doesn't exists.", (boolean)facesConfigFile.exists());
        FileEditorInput fileInput = new FileEditorInput(facesConfigFile);
        IEditorPart editor1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fileInput, "org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor");
        FacesConfigEditorTest.assertNotNull((Object)editor1);
        return editor1;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this.editor, false);
        JSFTestUtil.safeDelete((IResource)this.project, (int)10, (int)200);
    }
}

